/*
 * Decompiled with CFR 0.152.
 */
package pavocado.exoticbirds.entity.TileEntity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import pavocado.exoticbirds.gui.container.ContainerEggSorter;
import pavocado.exoticbirds.init.EggList;
import pavocado.exoticbirds.init.ExoticbirdsAchievements;
import pavocado.exoticbirds.init.ExoticbirdsBlocks;
import pavocado.exoticbirds.init.ExoticbirdsItems;
import pavocado.exoticbirds.items.Eggs.ItemBirdEgg;

public class TileEntityEggSorter
extends TileEntityLockableLoot
implements ITickable,
ISidedInventory {
    private static final int[] SLOTS_TOP = new int[]{0};
    private static final int[] SLOTS_BOTTOM = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
    private static final int[] SLOTS_SIDES = new int[]{0, 1};
    private ItemStack[] eggsorterItemStacks = new ItemStack[17];
    public int eggIdentifyTime;
    private String customName;
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public int func_70302_i_() {
        return this.eggsorterItemStacks.length;
    }

    public ItemStack func_70301_a(int index) {
        return this.eggsorterItemStacks[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        this.func_184281_d(null);
        ItemStack itemstack = ItemStackHelper.func_188382_a((ItemStack[])this.eggsorterItemStacks, (int)index, (int)count);
        if (itemstack != null) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        this.func_184281_d(null);
        return ItemStackHelper.func_188383_a((ItemStack[])this.eggsorterItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.func_184281_d(null);
        this.eggsorterItemStacks[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.eggsorter";
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.eggIdentifyTime = compound.func_74762_e("IdentifyTime");
        this.eggsorterItemStacks = new ItemStack[this.func_70302_i_()];
        if (!this.func_184283_b(compound)) {
            NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
                if (j < 0 || j >= this.eggsorterItemStacks.length) continue;
                this.eggsorterItemStacks[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
            }
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("IdentifyTime", (int)((short)this.eggIdentifyTime));
        if (!this.func_184282_c(compound)) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.eggsorterItemStacks.length; ++i) {
                if (this.eggsorterItemStacks[i] == null) continue;
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74774_a("Slot", (byte)i);
                this.eggsorterItemStacks[i].func_77955_b(nbttagcompound);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound);
            }
            compound.func_74782_a("Items", (NBTBase)nbttaglist);
        }
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean isBurning() {
        return this.eggIdentifyTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isBurning(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    public void func_73660_a() {
        boolean flag1 = false;
        if (!this.field_145850_b.field_72995_K) {
            ItemStack fuelstack = this.eggsorterItemStacks[1];
            ItemStack eggstack = this.eggsorterItemStacks[0];
            if (fuelstack != null && eggstack != null) {
                if (this.canSmelt()) {
                    ++this.eggIdentifyTime;
                    if (this.eggIdentifyTime == 200) {
                        this.eggIdentifyTime = 0;
                        this.smeltItem();
                        flag1 = true;
                        --fuelstack.field_77994_a;
                        --eggstack.field_77994_a;
                        if (fuelstack.field_77994_a <= 0) {
                            this.eggsorterItemStacks[1] = null;
                        }
                        if (eggstack.field_77994_a <= 0) {
                            this.eggsorterItemStacks[0] = null;
                        }
                    }
                } else {
                    this.eggIdentifyTime = 0;
                }
            } else if (this.isBurning()) {
                this.eggIdentifyTime = 0;
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    private boolean canSmelt() {
        if (this.eggsorterItemStacks[0].func_77973_b() != ExoticbirdsItems.mystery_egg) {
            return false;
        }
        int emptySpaces = 0;
        for (int i = 2; i < 17; ++i) {
            if (this.eggsorterItemStacks[i] != null) continue;
            ++emptySpaces;
        }
        return emptySpaces != 0;
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            for (int i = 2; i < 17; ++i) {
                if (this.eggsorterItemStacks[i] != null) continue;
                if (new Random().nextInt(500) < 3) {
                    this.eggsorterItemStacks[i] = new ItemStack(ExoticbirdsBlocks.phoenix_egg, 1);
                    break;
                }
                if (new Random().nextInt(10) < 3) {
                    this.eggsorterItemStacks[i] = new ItemStack(ExoticbirdsItems.eggshell, new Random().nextInt(3) + 1);
                    break;
                }
                Item eggItem = EggList.getEggType();
                if (eggItem instanceof ItemBirdEgg) {
                    ((ItemBirdEgg)eggItem).defaultSpawnChance = 50 + (int)(Math.log(Math.random() + 1.0) * 8.0) * 5;
                }
                this.eggsorterItemStacks[i] = new ItemStack(eggItem, 1);
                EntityPlayer playerIn = this.field_145850_b.func_184137_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0, false);
                if (playerIn == null) break;
                playerIn.func_71064_a((StatBase)ExoticbirdsAchievements.achievementIdentifyEgg, 1);
                break;
            }
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0 && stack.func_77973_b() == ExoticbirdsItems.mystery_egg) {
            return true;
        }
        ItemStack itemstack = this.eggsorterItemStacks[1];
        return index == 1 && TileEntityEggSorter.isItemFuel(stack);
    }

    public static boolean isItemFuel(ItemStack stack) {
        return TileEntityEggSorter.getItemBurnTime(stack) > 0;
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item == Items.field_151137_ax) {
            return 200;
        }
        return 0;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public String func_174875_k() {
        return "exoticbirds:eggsorter";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerEggSorter(playerInventory, (IInventory)this);
    }

    public void func_174888_l() {
        this.func_184281_d(null);
        for (int i = 0; i < this.eggsorterItemStacks.length; ++i) {
            this.eggsorterItemStacks[i] = null;
        }
    }

    public int func_174887_a_(int id) {
        return this.eggIdentifyTime;
    }

    public void func_174885_b(int id, int value) {
        this.eggIdentifyTime = value;
    }

    public int func_174890_g() {
        return 1;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_BOTTOM : (side == EnumFacing.UP ? SLOTS_TOP : SLOTS_SIDES);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return direction != EnumFacing.DOWN || index != 1 && index != 0;
    }
}

