/*
 * Decompiled with CFR 0.152.
 */
package pavocado.exoticbirds.entity.TileEntity;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pavocado.exoticbirds.gui.container.ContainerIncubator;
import pavocado.exoticbirds.items.Eggs.ItemBirdEgg;

public class TileEntityIncubator
extends TileEntityLockableLoot
implements ITickable {
    private ItemStack[] incubatorItemStacks = new ItemStack[15];
    public int eggIncubateTime;
    private String customName;

    public int func_70302_i_() {
        return this.incubatorItemStacks.length;
    }

    public ItemStack func_70301_a(int index) {
        this.func_184281_d(null);
        return this.incubatorItemStacks[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        this.func_184281_d(null);
        ItemStack itemstack = ItemStackHelper.func_188382_a((ItemStack[])this.incubatorItemStacks, (int)index, (int)count);
        if (itemstack != null) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        this.func_184281_d(null);
        return ItemStackHelper.func_188383_a((ItemStack[])this.incubatorItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.func_184281_d(null);
        this.incubatorItemStacks[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.incubator";
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.incubatorItemStacks = new ItemStack[this.func_70302_i_()];
        this.eggIncubateTime = compound.func_74762_e("IncubateTime");
        if (!this.func_184283_b(compound)) {
            NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
                if (j < 0 || j >= this.incubatorItemStacks.length) continue;
                this.incubatorItemStacks[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
            }
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("IncubateTime", (int)((short)this.eggIncubateTime));
        if (!this.func_184282_c(compound)) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.incubatorItemStacks.length; ++i) {
                if (this.incubatorItemStacks[i] == null) continue;
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74774_a("Slot", (byte)i);
                this.incubatorItemStacks[i].func_77955_b(nbttagcompound);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound);
            }
            compound.func_74782_a("Items", (NBTBase)nbttaglist);
        }
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean isBurning() {
        return this.eggIncubateTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isBurning(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    public void func_73660_a() {
        boolean flag1 = false;
        if (!this.field_145850_b.field_72995_K) {
            ItemStack itemstack = this.incubatorItemStacks[0];
            if (itemstack != null) {
                if (this.canSmelt()) {
                    ++this.eggIncubateTime;
                    if (this.eggIncubateTime == 500 && itemstack != null) {
                        Item item = itemstack.func_77973_b();
                        --itemstack.field_77994_a;
                        this.eggIncubateTime = 0;
                        this.smeltItem();
                        flag1 = true;
                        if (itemstack.field_77994_a <= 0) {
                            this.incubatorItemStacks[0] = null;
                        }
                    }
                } else {
                    this.eggIncubateTime = 0;
                }
            } else if (this.isBurning()) {
                this.eggIncubateTime = 0;
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    private boolean canSmelt() {
        int filledSpaces = 0;
        for (int i = 1; i < 15; ++i) {
            if (this.incubatorItemStacks[i] == null) continue;
            ++filledSpaces;
        }
        return filledSpaces > 0;
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            for (int i = 1; i < 15; ++i) {
                NBTTagCompound svalue;
                ItemStack eggStack;
                Item eggItem;
                if (this.incubatorItemStacks[i] == null || !((eggItem = (eggStack = this.incubatorItemStacks[i]).func_77973_b()) instanceof ItemBirdEgg)) continue;
                if (eggStack.func_77978_p() == null || !eggStack.func_77978_p().func_74764_b("eggValues")) {
                    eggStack.func_77982_d(new NBTTagCompound());
                    NBTTagCompound nbt = new NBTTagCompound();
                    nbt.func_74768_a("spawnChance", 10);
                    eggStack.func_77978_p().func_74782_a("eggValues", (NBTBase)nbt);
                } else if (eggStack.func_77978_p().func_74764_b("eggValues") && (svalue = (NBTTagCompound)eggStack.func_77978_p().func_74781_a("eggValues")).func_74762_e("spawnChance") <= 95) {
                    int spawnValue = 10;
                    spawnValue = svalue.func_74762_e("spawnChance") + 5;
                    NBTTagCompound nbt = new NBTTagCompound();
                    nbt.func_74768_a("spawnChance", spawnValue);
                    eggStack.func_77978_p().func_74782_a("eggValues", (NBTBase)nbt);
                }
                this.incubatorItemStacks[i] = eggStack;
            }
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index != 0) {
            return true;
        }
        ItemStack itemstack = this.incubatorItemStacks[1];
        return TileEntityIncubator.isItemFuel(stack);
    }

    public static boolean isItemFuel(ItemStack stack) {
        return TileEntityIncubator.getItemBurnTime(stack) > 0;
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item == Items.field_151065_br) {
            return 250;
        }
        return 0;
    }

    public boolean canInsertItem(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public String func_174875_k() {
        return "exoticbirds:incubator";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerIncubator(playerInventory, (IInventory)this);
    }

    public void func_174888_l() {
        this.func_184281_d(null);
        for (int i = 0; i < this.incubatorItemStacks.length; ++i) {
            this.incubatorItemStacks[i] = null;
        }
    }

    public int func_174887_a_(int id) {
        return this.eggIncubateTime;
    }

    public void func_174885_b(int id, int value) {
        this.eggIncubateTime = value;
    }

    public int func_174890_g() {
        return 1;
    }
}

