/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client;

import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.client.model.tools.AdvancedModelRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.MathHelper;

public class RollBuffer {
    private int yawTimer = 0;
    private float yawVariation = 0.0f;
    private float[] yawArray;

    public RollBuffer(int numberOfParentedBoxes) {
        this.yawArray = new float[numberOfParentedBoxes];
    }

    public void resetRotations() {
        this.yawVariation = 0.0f;
    }

    public void calculateChainRollBuffer(float maxAngle, int bufferTime, float angleDecrement, EntityLivingBase entity) {
        if (entity.field_70761_aq != entity.field_70760_ar && MathHelper.func_76135_e((float)this.yawVariation) < maxAngle) {
            this.yawVariation += entity.field_70760_ar - entity.field_70761_aq;
        }
        if (this.yawVariation > 0.7f * angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation -= angleDecrement;
                if (MathHelper.func_76135_e((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = 0.0f;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        } else if (this.yawVariation < -0.7f * angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation += angleDecrement;
                if (MathHelper.func_76135_e((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = 0.0f;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        }
        for (int i = 0; i < this.yawArray.length; ++i) {
            this.yawArray[i] = (float)Math.PI / 180 * this.yawVariation / (float)this.yawArray.length;
        }
    }

    public void applyChainRollBuffer(AdvancedModelRenderer[] boxes) {
        if (boxes.length == this.yawArray.length) {
            for (int i = 0; i < boxes.length; ++i) {
                boxes[i].field_78808_h += this.yawArray[i];
            }
        } else {
            LLibrary.LOGGER.error("Wrong array length being used in the buffer! (Y axis)");
        }
    }
}

