/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers;

import java.util.ArrayList;
import java.util.Arrays;
import moze_intel.projecte.emc.NormalizedSimpleStack;
import moze_intel.projecte.emc.collector.IMappingCollector;
import moze_intel.projecte.emc.mappers.IEMCMapper;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreDictionary;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.api.carving.ICarvingGroup;
import team.chisel.api.carving.ICarvingRegistry;
import team.chisel.api.carving.ICarvingVariation;

public class Chisel2Mapper
implements IEMCMapper<NormalizedSimpleStack, Integer> {
    private static final String[] chiselBlockNames = new String[]{"marble", "limestone", "andesite", "granite", "diorite"};

    @Override
    public String getName() {
        return "Chisel2Mapper";
    }

    @Override
    public String getDescription() {
        return "Add mappings for Blocks that are created with Chisel.";
    }

    @Override
    public boolean isAvailable() {
        return Loader.isModLoaded((String)"chisel");
    }

    @Override
    public void addMappings(IMappingCollector<NormalizedSimpleStack, Integer> mapper, Configuration config) {
        ICarvingRegistry carvingRegistry = CarvingUtils.getChiselRegistry();
        if (carvingRegistry == null) {
            return;
        }
        for (String name : chiselBlockNames) {
            Block block = Block.func_149684_b((String)("chisel:" + name));
            if (block == null) continue;
            mapper.setValueBefore(NormalizedSimpleStack.getFor(block), 1);
        }
        for (String name : carvingRegistry.getSortedGroupNames()) {
            this.handleCarvingGroup(mapper, config, carvingRegistry.getGroup(name));
        }
    }

    private void handleCarvingGroup(IMappingCollector<NormalizedSimpleStack, Integer> mapper, Configuration config, ICarvingGroup group) {
        if (!config.getBoolean(group.getName(), "enableCarvingGroups", true, "Enable ICarvingGroup with name=" + group.getName() + (group.getOreName() == null ? "" : " and oreName=" + group.getOreName()))) {
            return;
        }
        ArrayList<NormalizedSimpleStack> stacks = new ArrayList<NormalizedSimpleStack>();
        for (ICarvingVariation v : group.getVariations()) {
            stacks.add(NormalizedSimpleStack.getFor(v.getBlock(), v.getBlock().func_176201_c(v.getBlockState())));
        }
        if (group.getOreName() != null) {
            for (ItemStack ore : OreDictionary.getOres((String)group.getOreName())) {
                stacks.add(NormalizedSimpleStack.getFor(ore));
            }
        }
        for (int i = 1; i < stacks.size(); ++i) {
            mapper.addConversion(1, (NormalizedSimpleStack)stacks.get(0), (Iterable<NormalizedSimpleStack>)Arrays.asList((NormalizedSimpleStack)stacks.get(i)));
            mapper.addConversion(1, (NormalizedSimpleStack)stacks.get(i), (Iterable<NormalizedSimpleStack>)Arrays.asList((NormalizedSimpleStack)stacks.get(0)));
        }
    }
}

