/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.container;

import javax.annotation.Nonnull;
import moze_intel.projecte.emc.FuelMapper;
import moze_intel.projecte.gameObjs.container.slots.SlotGhost;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.container.slots.ValidatedSlot;
import moze_intel.projecte.gameObjs.tiles.CollectorMK1Tile;
import moze_intel.projecte.network.PacketHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

public class CollectorMK1Container
extends Container {
    final CollectorMK1Tile tile;
    public int sunLevel = 0;
    public int emc = 0;
    public double kleinChargeProgress = 0.0;
    public double fuelProgress = 0.0;
    public int kleinEmc = 0;

    public CollectorMK1Container(InventoryPlayer invPlayer, CollectorMK1Tile collector) {
        this.tile = collector;
        this.initSlots(invPlayer);
    }

    void initSlots(InventoryPlayer invPlayer) {
        int j;
        int i;
        IItemHandler aux = this.tile.getAux();
        IItemHandler main = this.tile.getInput();
        this.func_75146_a((Slot)new ValidatedSlot(aux, 0, 124, 58, SlotPredicates.COLLECTOR_INV));
        int counter = main.getSlots() - 1;
        for (i = 0; i <= 1; ++i) {
            for (j = 0; j <= 3; ++j) {
                this.func_75146_a((Slot)new ValidatedSlot(main, counter--, 20 + i * 18, 8 + j * 18, SlotPredicates.COLLECTOR_INV));
            }
        }
        this.func_75146_a((Slot)new ValidatedSlot(aux, 1, 124, 13, SlotPredicates.COLLECTOR_INV));
        this.func_75146_a((Slot)new SlotGhost(aux, 2, 153, 36, SlotPredicates.COLLECTOR_LOCK));
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)invPlayer, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)invPlayer, i, 8 + i * 18, 142));
        }
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        PacketHandler.sendProgressBarUpdateInt(listener, this, 0, this.tile.getSunLevel());
        PacketHandler.sendProgressBarUpdateInt(listener, this, 1, (int)this.tile.getStoredEmc());
        PacketHandler.sendProgressBarUpdateInt(listener, this, 2, (int)(this.tile.getItemChargeProportion() * 8000.0));
        PacketHandler.sendProgressBarUpdateInt(listener, this, 3, (int)(this.tile.getFuelProgress() * 8000.0));
        PacketHandler.sendProgressBarUpdateInt(listener, this, 4, (int)(this.tile.getItemCharge() * 8000.0));
    }

    public ItemStack func_184996_a(int slot, int button, ClickType flag, EntityPlayer player) {
        if (slot >= 0 && this.func_75139_a(slot) instanceof SlotGhost && this.func_75139_a(slot).func_75211_c() != null) {
            this.func_75139_a(slot).func_75215_d(null);
            return null;
        }
        return super.func_184996_a(slot, button, flag, player);
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.sunLevel != this.tile.getSunLevel()) {
            for (IContainerListener icrafting : this.field_75149_d) {
                PacketHandler.sendProgressBarUpdateInt(icrafting, this, 0, this.tile.getSunLevel());
            }
            this.sunLevel = this.tile.getSunLevel();
        }
        if (this.emc != (int)this.tile.getStoredEmc()) {
            for (IContainerListener icrafting : this.field_75149_d) {
                PacketHandler.sendProgressBarUpdateInt(icrafting, this, 1, (int)this.tile.getStoredEmc());
            }
            this.emc = (int)this.tile.getStoredEmc();
        }
        if (this.kleinChargeProgress != this.tile.getItemChargeProportion()) {
            for (IContainerListener icrafting : this.field_75149_d) {
                PacketHandler.sendProgressBarUpdateInt(icrafting, this, 2, (int)(this.tile.getItemChargeProportion() * 8000.0));
            }
            this.kleinChargeProgress = this.tile.getItemChargeProportion();
        }
        if (this.fuelProgress != this.tile.getFuelProgress()) {
            for (IContainerListener icrafting : this.field_75149_d) {
                PacketHandler.sendProgressBarUpdateInt(icrafting, this, 3, (int)(this.tile.getFuelProgress() * 8000.0));
            }
            this.fuelProgress = this.tile.getFuelProgress();
        }
        if (this.kleinEmc != (int)this.tile.getItemCharge()) {
            for (IContainerListener icrafting : this.field_75149_d) {
                PacketHandler.sendProgressBarUpdateInt(icrafting, this, 4, (int)this.tile.getItemCharge());
            }
            this.kleinEmc = (int)this.tile.getItemCharge();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        switch (id) {
            case 0: {
                this.sunLevel = data;
                break;
            }
            case 1: {
                this.emc = data;
                break;
            }
            case 2: {
                this.kleinChargeProgress = (double)data / 8000.0;
                break;
            }
            case 3: {
                this.fuelProgress = (double)data / 8000.0;
                break;
            }
            case 4: {
                this.kleinEmc = data;
            }
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        Slot slot = this.func_75139_a(slotIndex);
        if (slot == null || !slot.func_75216_d()) {
            return null;
        }
        ItemStack stack = slot.func_75211_c();
        ItemStack newStack = stack.func_77946_l();
        if (slotIndex <= 10) {
            if (!this.func_75135_a(stack, 11, 46, false)) {
                return null;
            }
        } else if (slotIndex <= 46) {
            if (!FuelMapper.isStackFuel(stack) || FuelMapper.isStackMaxFuel(stack) || !this.func_75135_a(stack, 1, 8, false)) {
                return null;
            }
        } else {
            return null;
        }
        if (stack.field_77994_a == 0) {
            slot.func_75215_d(null);
        } else {
            slot.func_75218_e();
        }
        slot.func_82870_a(player, stack);
        return newStack;
    }

    public boolean func_75145_c(@Nonnull EntityPlayer player) {
        return player.func_70092_e((double)this.tile.func_174877_v().func_177958_n() + 0.5, (double)this.tile.func_174877_v().func_177956_o() + 0.5, (double)this.tile.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }
}

