/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.PESounds;
import moze_intel.projecte.api.item.IPedestalItem;
import moze_intel.projecte.api.item.IProjectileShooter;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.entity.EntityLavaProjectile;
import moze_intel.projecte.gameObjs.items.IFireProtector;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.utils.ClientKeyHelper;
import moze_intel.projecte.utils.FluidHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.PlayerHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles")
public class VolcaniteAmulet
extends ItemPE
implements IProjectileShooter,
IBauble,
IPedestalItem,
IFireProtector {
    public VolcaniteAmulet() {
        this.func_77655_b("volcanite_amulet");
        this.func_77625_d(1);
        this.func_77642_a(this);
    }

    @Nonnull
    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing sideHit, float f1, float f2, float f3) {
        if (!world.field_72995_K && PlayerHelper.hasEditPermission((EntityPlayerMP)player, pos) && VolcaniteAmulet.consumeFuel(player, stack, 32.0, true)) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, sideHit)) {
                FluidHelper.tryFillTank(tile, FluidRegistry.LAVA, sideHit, 1000);
            } else {
                this.placeLava(world, player, pos.func_177972_a(sideHit));
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.TRANSMUTE, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    private void placeLava(World world, EntityPlayer player, BlockPos pos) {
        PlayerHelper.checkedPlaceBlock((EntityPlayerMP)player, pos, Blocks.field_150356_k.func_176223_P());
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int invSlot, boolean par5) {
        if (invSlot > 8 || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        int x = (int)Math.floor(player.field_70165_t);
        int y = (int)(player.field_70163_u - player.func_70033_W());
        int z = (int)Math.floor(player.field_70161_v);
        BlockPos pos = new BlockPos(x, y, z);
        if ((player.func_130014_f_().func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150353_l || player.func_130014_f_().func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150356_k) && player.func_130014_f_().func_175623_d(pos)) {
            if (!player.func_70093_af()) {
                player.field_70181_x = 0.0;
                player.field_70143_R = 0.0f;
                player.field_70122_E = true;
            }
            if (!player.func_130014_f_().field_72995_K && player.field_71075_bZ.func_75094_b() < 0.25f) {
                PlayerHelper.setPlayerWalkSpeed(player, 0.25f);
            }
        } else if (!player.func_130014_f_().field_72995_K && player.field_71075_bZ.func_75094_b() != 0.1f) {
            PlayerHelper.setPlayerWalkSpeed(player, 0.1f);
        }
    }

    @Override
    public boolean shootProjectile(@Nonnull EntityPlayer player, @Nonnull ItemStack stack, EnumHand hand) {
        player.func_130014_f_().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.TRANSMUTE, SoundCategory.PLAYERS, 1.0f, 1.0f);
        EntityLavaProjectile ent = new EntityLavaProjectile(player.func_130014_f_(), player);
        ent.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
        player.func_130014_f_().func_72838_d((Entity)ent);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean par4) {
        list.add(I18n.func_135052_a((String)"pe.volcanite.tooltip1", (Object[])new Object[]{ClientKeyHelper.getKeyName(PEKeybind.FIRE_PROJECTILE)}));
        list.add(I18n.func_135052_a((String)"pe.volcanite.tooltip2", (Object[])new Object[0]));
        list.add(I18n.func_135052_a((String)"pe.volcanite.tooltip3", (Object[])new Object[0]));
        list.add(I18n.func_135052_a((String)"pe.volcanite.tooltip4", (Object[])new Object[0]));
    }

    @Optional.Method(modid="Baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.AMULET;
    }

    @Optional.Method(modid="Baubles")
    public void onWornTick(ItemStack stack, EntityLivingBase ent) {
        if (!(ent instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)ent;
        int x = (int)Math.floor(player.field_70165_t);
        int y = (int)(player.field_70163_u - player.func_70033_W());
        int z = (int)Math.floor(player.field_70161_v);
        BlockPos pos = new BlockPos(x, y, z);
        if ((player.func_130014_f_().func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150353_l || player.func_130014_f_().func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150356_k) && player.func_130014_f_().func_175623_d(pos)) {
            if (!player.func_70093_af()) {
                player.field_70181_x = 0.0;
                player.field_70143_R = 0.0f;
                player.field_70122_E = true;
            }
            if (!player.func_130014_f_().field_72995_K && player.field_71075_bZ.func_75094_b() < 0.25f) {
                PlayerHelper.setPlayerWalkSpeed(player, 0.25f);
            }
        } else if (!player.func_130014_f_().field_72995_K && player.field_71075_bZ.func_75094_b() != 0.1f) {
            PlayerHelper.setPlayerWalkSpeed(player, 0.1f);
        }
    }

    @Optional.Method(modid="Baubles")
    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="Baubles")
    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Override
    public void updateInPedestal(@Nonnull World world, @Nonnull BlockPos pos) {
        if (!world.field_72995_K && ProjectEConfig.volcanitePedCooldown != -1) {
            DMPedestalTile tile = (DMPedestalTile)world.func_175625_s(pos);
            if (tile.getActivityCooldown() == 0) {
                world.func_72912_H().func_76080_g(0);
                world.func_72912_H().func_76090_f(0);
                world.func_72912_H().func_76084_b(false);
                world.func_72912_H().func_76069_a(false);
                tile.setActivityCooldown(ProjectEConfig.volcanitePedCooldown);
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public List<String> getPedestalDescription() {
        ArrayList list = Lists.newArrayList();
        if (ProjectEConfig.volcanitePedCooldown != -1) {
            list.add(TextFormatting.BLUE + I18n.func_135052_a((String)"pe.volcanite.pedestal1", (Object[])new Object[0]));
            list.add(TextFormatting.BLUE + I18n.func_135052_a((String)"pe.volcanite.pedestal2", (Object[])new Object[]{MathUtils.tickToSecFormatted(ProjectEConfig.volcanitePedCooldown)}));
        }
        return list;
    }

    @Override
    public boolean canProtectAgainstFire(ItemStack stack, EntityPlayerMP player) {
        return true;
    }
}

