/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.armor;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import moze_intel.projecte.PECore;
import moze_intel.projecte.gameObjs.items.IFlightProvider;
import moze_intel.projecte.gameObjs.items.IStepAssister;
import moze_intel.projecte.gameObjs.items.armor.GemArmorBase;
import moze_intel.projecte.utils.ClientKeyHelper;
import moze_intel.projecte.utils.PEKeybind;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GemFeet
extends GemArmorBase
implements IFlightProvider,
IStepAssister {
    private static final UUID MODIFIER = UUID.randomUUID();

    public GemFeet() {
        super(EntityEquipmentSlot.FEET);
    }

    public static boolean isStepAssistEnabled(ItemStack boots) {
        return !boots.func_77942_o() || !boots.func_77978_p().func_74764_b("StepAssist") || boots.func_77978_p().func_74767_n("StepAssist");
    }

    public void toggleStepAssist(ItemStack boots, EntityPlayer player) {
        boolean value;
        if (!boots.func_77942_o()) {
            boots.func_77982_d(new NBTTagCompound());
        }
        if (boots.func_77978_p().func_74764_b("StepAssist")) {
            boots.func_77978_p().func_74757_a("StepAssist", !boots.func_77978_p().func_74767_n("StepAssist"));
            value = boots.func_77978_p().func_74767_n("StepAssist");
        } else {
            boots.func_77978_p().func_74757_a("StepAssist", false);
            value = false;
        }
        TextFormatting e = value ? TextFormatting.GREEN : TextFormatting.RED;
        String s = value ? "pe.gem.enabled" : "pe.gem.disabled";
        player.func_145747_a(new TextComponentTranslation("pe.gem.stepassist_tooltip", new Object[0]).func_150258_a(" ").func_150257_a(new TextComponentTranslation(s, new Object[0]).func_150255_a(new Style().func_150238_a(e))));
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (!world.field_72995_K) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            playerMP.field_70143_R = 0.0f;
        } else {
            if (!player.field_71075_bZ.field_75100_b && PECore.proxy.isJumpPressed()) {
                player.field_70181_x += 0.1;
            }
            if (!player.field_70122_E) {
                if (player.field_70181_x <= 0.0) {
                    player.field_70181_x *= 0.9;
                }
                if (!player.field_71075_bZ.field_75100_b) {
                    if (player.field_70701_bs < 0.0f) {
                        player.field_70159_w *= 0.9;
                        player.field_70179_y *= 0.9;
                    } else if (player.field_70701_bs > 0.0f && player.field_70159_w * player.field_70159_w + player.field_70181_x * player.field_70181_x + player.field_70179_y * player.field_70179_y < 3.0) {
                        player.field_70159_w *= 1.1;
                        player.field_70179_y *= 1.1;
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltips, boolean unused) {
        tooltips.add(I18n.func_135052_a((String)"pe.gem.feet.lorename", (Object[])new Object[0]));
        tooltips.add(I18n.func_135052_a((String)"pe.gem.stepassist.prompt", (Object[])new Object[]{ClientKeyHelper.getKeyName(PEKeybind.ARMOR_TOGGLE)}));
        TextFormatting e = this.canStep(stack) ? TextFormatting.GREEN : TextFormatting.RED;
        String s = this.canStep(stack) ? "pe.gem.enabled" : "pe.gem.disabled";
        tooltips.add(I18n.func_135052_a((String)"pe.gem.stepassist_tooltip", (Object[])new Object[0]) + " " + e + I18n.func_135052_a((String)s, (Object[])new Object[0]));
    }

    private boolean canStep(ItemStack stack) {
        return stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("StepAssist") && stack.func_77978_p().func_74767_n("StepAssist");
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EntityEquipmentSlot slot, ItemStack stack) {
        if (slot != EntityEquipmentSlot.FEET) {
            return super.getAttributeModifiers(slot, stack);
        }
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(MODIFIER, "Armor modifier", 1.0, 2));
        return multimap;
    }

    @Override
    public boolean canProvideFlight(ItemStack stack, EntityPlayerMP player) {
        return player.func_184582_a(EntityEquipmentSlot.FEET) == stack;
    }

    @Override
    public boolean canAssistStep(ItemStack stack, EntityPlayerMP player) {
        return player.func_184582_a(EntityEquipmentSlot.FEET) == stack && this.canStep(stack);
    }
}

