/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.PESounds;
import moze_intel.projecte.api.item.IExtraFunction;
import moze_intel.projecte.api.item.IModeChanger;
import moze_intel.projecte.api.item.IProjectileShooter;
import moze_intel.projecte.gameObjs.entity.EntityFireProjectile;
import moze_intel.projecte.gameObjs.entity.EntitySWRGProjectile;
import moze_intel.projecte.gameObjs.items.IFireProtector;
import moze_intel.projecte.gameObjs.items.IFlightProvider;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles")
public class Arcana
extends ItemPE
implements IBauble,
IModeChanger,
IFlightProvider,
IFireProtector,
IExtraFunction,
IProjectileShooter {
    public Arcana() {
        this.func_77655_b("arcana_ring");
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77642_a(this);
        this.func_185043_a(new ResourceLocation("projecte", "on"), (stack, worldIn, entityIn) -> stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("Active") ? 1.0f : 0.0f);
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull Item item, CreativeTabs cTab, List<ItemStack> list) {
        for (int i = 0; i < 4; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChange) {
        return this.getMode(oldStack) != this.getMode(newStack) || oldStack.func_77942_o() && newStack.func_77942_o() && oldStack.func_77978_p().func_74767_n("Active") != newStack.func_77978_p().func_74767_n("Active");
    }

    @Override
    public byte getMode(@Nonnull ItemStack stack) {
        return (byte)stack.func_77952_i();
    }

    @Override
    public boolean changeMode(@Nonnull EntityPlayer player, @Nonnull ItemStack stack, EnumHand hand) {
        stack.func_77964_b((stack.func_77952_i() + 1) % 4);
        return true;
    }

    private void tick(ItemStack stack, World world, EntityPlayerMP player) {
        if (stack.func_77978_p().func_74767_n("Active")) {
            switch (stack.func_77952_i()) {
                case 0: {
                    WorldHelper.freezeInBoundingBox(world, player.func_174813_aQ().func_72314_b(5.0, 5.0, 5.0), (EntityPlayer)player, true);
                    break;
                }
                case 1: {
                    WorldHelper.igniteNearby(world, (EntityPlayer)player);
                    break;
                }
                case 2: {
                    WorldHelper.growNearbyRandomly(true, world, new BlockPos((Entity)player), (EntityPlayer)player);
                    break;
                }
                case 3: {
                    WorldHelper.repelEntitiesInAABBFromPoint(world, player.func_174813_aQ().func_72314_b(5.0, 5.0, 5.0), player.field_70165_t, player.field_70163_u, player.field_70161_v, true);
                }
            }
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean held) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (world.field_72995_K || slot > 8 || !(entity instanceof EntityPlayerMP)) {
            return;
        }
        this.tick(stack, world, (EntityPlayerMP)entity);
    }

    @Optional.Method(modid="Baubles")
    public BaubleType getBaubleType(ItemStack stack) {
        return BaubleType.RING;
    }

    @Optional.Method(modid="Baubles")
    public void onWornTick(ItemStack stack, EntityLivingBase entity) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (entity.func_130014_f_().field_72995_K || !(entity instanceof EntityPlayerMP)) {
            return;
        }
        this.tick(stack, entity.func_130014_f_(), (EntityPlayerMP)entity);
    }

    @Optional.Method(modid="Baubles")
    public void onEquipped(ItemStack stack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public void onUnequipped(ItemStack stack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public boolean canEquip(ItemStack stack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="Baubles")
    public boolean canUnequip(ItemStack stack, EntityLivingBase player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean b) {
        if (stack.func_77942_o()) {
            if (!stack.func_77978_p().func_74767_n("Active")) {
                list.add(TextFormatting.RED + I18n.func_135052_a((String)"pe.arcana.inactive", (Object[])new Object[0]));
            } else {
                list.add(I18n.func_135052_a((String)"pe.arcana.mode", (Object[])new Object[0]) + TextFormatting.AQUA + I18n.func_135052_a((String)("pe.arcana.mode." + stack.func_77952_i()), (Object[])new Object[0]));
            }
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            NBTTagCompound compound;
            compound.func_74757_a("Active", !(compound = stack.func_77978_p()).func_74767_n("Active"));
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    public boolean doExtraFunction(@Nonnull ItemStack stack, @Nonnull EntityPlayer player, EnumHand hand) {
        World world = player.func_130014_f_();
        if (world.field_72995_K) {
            return true;
        }
        switch (stack.func_77952_i()) {
            case 1: {
                switch (player.func_174811_aO()) {
                    case SOUTH: 
                    case NORTH: {
                        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)player.func_180425_c().func_177982_a(-30, -5, -3), (BlockPos)player.func_180425_c().func_177982_a(30, 5, 3))) {
                            if (!world.func_175623_d(pos)) continue;
                            PlayerHelper.checkedPlaceBlock((EntityPlayerMP)player, pos.func_185334_h(), Blocks.field_150480_ab.func_176223_P());
                        }
                        break;
                    }
                    case WEST: 
                    case EAST: {
                        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)player.func_180425_c().func_177982_a(-3, -5, -30), (BlockPos)player.func_180425_c().func_177982_a(3, 5, 30))) {
                            if (!world.func_175623_d(pos)) continue;
                            PlayerHelper.checkedPlaceBlock((EntityPlayerMP)player, pos.func_185334_h(), Blocks.field_150480_ab.func_176223_P());
                        }
                        break;
                    }
                }
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.POWER, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
        return true;
    }

    @Override
    public boolean shootProjectile(@Nonnull EntityPlayer player, @Nonnull ItemStack stack, EnumHand hand) {
        World world = player.func_130014_f_();
        if (world.field_72995_K) {
            return false;
        }
        switch (stack.func_77952_i()) {
            case 0: {
                EntitySnowball snowball = new EntitySnowball(world, (EntityLivingBase)player);
                world.func_72838_d((Entity)snowball);
                snowball.func_184185_a(SoundEvents.field_187797_fA, 1.0f, 1.0f);
                break;
            }
            case 1: {
                EntityFireProjectile fire = new EntityFireProjectile(world, player);
                fire.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
                world.func_72838_d((Entity)fire);
                fire.func_184185_a(PESounds.POWER, 1.0f, 1.0f);
                break;
            }
            case 3: {
                EntitySWRGProjectile lightning = new EntitySWRGProjectile(world, player, true);
                lightning.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
                world.func_72838_d((Entity)lightning);
            }
        }
        return true;
    }

    @Override
    public boolean canProtectAgainstFire(ItemStack stack, EntityPlayerMP player) {
        return true;
    }

    @Override
    public boolean canProvideFlight(ItemStack stack, EntityPlayerMP player) {
        return true;
    }
}

