/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.item.IPedestalItem;
import moze_intel.projecte.gameObjs.items.rings.RingToggle;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MindStone
extends RingToggle
implements IPedestalItem {
    private static final int TRANSFER_RATE = 50;

    public MindStone() {
        super("mind_stone");
        this.setNoRepair();
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        if (world.field_72995_K || par4 > 8 || !(entity instanceof EntityPlayer)) {
            return;
        }
        super.func_77663_a(stack, world, entity, par4, par5);
        EntityPlayer player = (EntityPlayer)entity;
        if (stack.func_77952_i() != 0 && this.getXP(player) > 0) {
            int toAdd = this.getXP(player) >= 50 ? 50 : this.getXP(player);
            this.addStoredXP(stack, toAdd);
            this.removeXP(player, 50);
        }
    }

    @Nonnull
    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float par8, float par9, float par10) {
        int toAdd;
        if (!world.field_72995_K && stack.func_77952_i() == 0 && this.getStoredXP(stack) != 0 && (toAdd = this.removeStoredXP(stack, 50)) > 0) {
            this.addXP(player, toAdd);
        }
        return EnumActionResult.SUCCESS;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        if (stack.func_77978_p() != null) {
            tooltip.add(String.format(TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"pe.misc.storedxp_tooltip", (Object[])new Object[0]) + " " + TextFormatting.GREEN + "%,d", this.getStoredXP(stack)));
        }
    }

    private void removeXP(EntityPlayer player, int amount) {
        int experiencetotal = this.getXP(player) - amount;
        if (experiencetotal < 0) {
            player.field_71067_cb = 0;
            player.field_71068_ca = 0;
            player.field_71106_cc = 0.0f;
        } else {
            player.field_71067_cb = experiencetotal;
            player.field_71068_ca = this.getLvlForXP(experiencetotal);
            player.field_71106_cc = (float)(experiencetotal - this.getXPForLvl(player.field_71068_ca)) / (float)player.func_71050_bK();
        }
    }

    private void addXP(EntityPlayer player, int amount) {
        int experiencetotal;
        player.field_71067_cb = experiencetotal = this.getXP(player) + amount;
        player.field_71068_ca = this.getLvlForXP(experiencetotal);
        player.field_71106_cc = (float)(experiencetotal - this.getXPForLvl(player.field_71068_ca)) / (float)player.func_71050_bK();
    }

    private int getXP(EntityPlayer player) {
        return (int)((float)this.getXPForLvl(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    private int getXPForLvl(int level) {
        if (level < 0) {
            return Integer.MAX_VALUE;
        }
        if (level <= 16) {
            return level * level + 6 * level;
        }
        if (level <= 31) {
            return (int)((double)(level * level) * 2.5 - 40.5 * (double)level + 360.0);
        }
        return (int)((double)(level * level) * 4.5 - 162.5 * (double)level + 2220.0);
    }

    private int getLvlForXP(int totalXP) {
        int result = 0;
        while (this.getXPForLvl(result) <= totalXP) {
            ++result;
        }
        return --result;
    }

    private int getStoredXP(ItemStack stack) {
        return stack.func_77978_p().func_74762_e("StoredXP");
    }

    private void setStoredXP(ItemStack stack, int XP) {
        stack.func_77978_p().func_74768_a("StoredXP", XP);
    }

    private void addStoredXP(ItemStack stack, int XP) {
        long result = this.getStoredXP(stack) + XP;
        if (result > Integer.MAX_VALUE) {
            result = Integer.MAX_VALUE;
        }
        this.setStoredXP(stack, (int)result);
    }

    private int removeStoredXP(ItemStack stack, int XP) {
        int currentXP = this.getStoredXP(stack);
        int result = 0;
        int returnResult = 0;
        if (currentXP < XP) {
            result = 0;
            returnResult = currentXP;
        } else {
            result = currentXP - XP;
            returnResult = XP;
        }
        this.setStoredXP(stack, result);
        return returnResult;
    }

    @Override
    public void updateInPedestal(@Nonnull World world, @Nonnull BlockPos pos) {
        DMPedestalTile tile = (DMPedestalTile)world.func_175625_s(pos);
        List orbs = world.func_72872_a(EntityXPOrb.class, tile.getEffectBounds());
        for (EntityXPOrb orb : orbs) {
            WorldHelper.gravitateEntityTowards((Entity)orb, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            if (world.field_72995_K || !(orb.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) < 1.21)) continue;
            this.suckXP(orb, tile.getInventory().getStackInSlot(0));
        }
    }

    private void suckXP(EntityXPOrb orb, ItemStack mindStone) {
        long l;
        if (!mindStone.func_77942_o()) {
            mindStone.func_77982_d(new NBTTagCompound());
        }
        if ((l = (long)this.getStoredXP(mindStone)) + (long)orb.field_70530_e > Integer.MAX_VALUE) {
            orb.field_70530_e = (int)(l + (long)orb.field_70530_e - Integer.MAX_VALUE);
            this.setStoredXP(mindStone, Integer.MAX_VALUE);
        } else {
            this.addStoredXP(mindStone, orb.field_70530_e);
            orb.func_70106_y();
        }
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public List<String> getPedestalDescription() {
        return Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"pe.mind.pedestal1", (Object[])new Object[0])});
    }
}

