/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.proxies;

import java.util.Map;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IAlchBagProvider;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.state.PEStateProps;
import moze_intel.projecte.api.state.enums.EnumFuelType;
import moze_intel.projecte.api.state.enums.EnumMatterType;
import moze_intel.projecte.events.TransmutationRenderingEvent;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.blocks.NovaCataclysm;
import moze_intel.projecte.gameObjs.blocks.NovaCatalyst;
import moze_intel.projecte.gameObjs.entity.EntityFireProjectile;
import moze_intel.projecte.gameObjs.entity.EntityHomingArrow;
import moze_intel.projecte.gameObjs.entity.EntityLavaProjectile;
import moze_intel.projecte.gameObjs.entity.EntityLensProjectile;
import moze_intel.projecte.gameObjs.entity.EntityMobRandomizer;
import moze_intel.projecte.gameObjs.entity.EntityNovaCataclysmPrimed;
import moze_intel.projecte.gameObjs.entity.EntityNovaCatalystPrimed;
import moze_intel.projecte.gameObjs.entity.EntitySWRGProjectile;
import moze_intel.projecte.gameObjs.entity.EntityWaterProjectile;
import moze_intel.projecte.gameObjs.items.KleinStar;
import moze_intel.projecte.gameObjs.tiles.AlchChestTile;
import moze_intel.projecte.gameObjs.tiles.CondenserMK2Tile;
import moze_intel.projecte.gameObjs.tiles.CondenserTile;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.manual.ManualPageHandler;
import moze_intel.projecte.proxies.IProxy;
import moze_intel.projecte.rendering.ChestRenderer;
import moze_intel.projecte.rendering.CondenserMK2Renderer;
import moze_intel.projecte.rendering.CondenserRenderer;
import moze_intel.projecte.rendering.LayerYue;
import moze_intel.projecte.rendering.NovaCataclysmRenderer;
import moze_intel.projecte.rendering.NovaCatalystRenderer;
import moze_intel.projecte.rendering.PedestalRenderer;
import moze_intel.projecte.utils.ClientKeyHelper;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.client.renderer.entity.RenderTippedArrow;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class ClientProxy
implements IProxy {
    @Override
    public void clearClientKnowledge() {
        ((IKnowledgeProvider)FMLClientHandler.instance().getClientPlayerEntity().getCapability(ProjectEAPI.KNOWLEDGE_CAPABILITY, null)).clearKnowledge();
    }

    @Override
    public IKnowledgeProvider getClientTransmutationProps() {
        return (IKnowledgeProvider)FMLClientHandler.instance().getClientPlayerEntity().getCapability(ProjectEAPI.KNOWLEDGE_CAPABILITY, null);
    }

    @Override
    public IAlchBagProvider getClientBagProps() {
        return (IAlchBagProvider)FMLClientHandler.instance().getClientPlayerEntity().getCapability(ProjectEAPI.ALCH_BAG_CAPABILITY, null);
    }

    @Override
    public void registerKeyBinds() {
        ClientKeyHelper.registerMCBindings();
    }

    @Override
    public void registerModels() {
        ModelLoader.setCustomStateMapper((Block)ObjHandler.novaCatalyst, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{NovaCatalyst.field_176246_a}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ObjHandler.novaCataclysm, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{NovaCataclysm.field_176246_a}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ObjHandler.alchChest, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{PEStateProps.FACING}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ObjHandler.condenser, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{PEStateProps.FACING}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ObjHandler.condenserMk2, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{PEStateProps.FACING}).func_178441_a());
        this.registerCovalenceDust();
        this.registerBags();
        this.registerFuels();
        this.registerMatter();
        this.registerKlein();
        this.registerPowerStones();
        this.registerPowerItems();
        this.registerItem(ObjHandler.waterOrb);
        this.registerItem(ObjHandler.lavaOrb);
        this.registerItem(ObjHandler.mobRandomizer);
        this.registerItem(ObjHandler.lensExplosive);
        this.registerItem(ObjHandler.windProjectile);
        this.registerItem(ObjHandler.fireProjectile);
        this.registerItem(ObjHandler.philosStone);
        this.registerItem(ObjHandler.repairTalisman);
        this.registerItem(ObjHandler.ironBand);
        this.registerItem(ObjHandler.dCatalyst);
        this.registerItem(ObjHandler.hyperLens);
        this.registerItem(ObjHandler.cataliticLens);
        this.registerItem(ObjHandler.tome);
        this.registerItem(ObjHandler.transmutationTablet);
        this.registerItem(ObjHandler.everTide);
        this.registerItem(ObjHandler.volcanite);
        this.registerItem(ObjHandler.dRod1);
        this.registerItem(ObjHandler.dRod2);
        this.registerItem(ObjHandler.dRod3);
        this.registerItem(ObjHandler.angelSmite);
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.angelSmite, (int)1, (ModelResourceLocation)new ModelResourceLocation(ObjHandler.angelSmite.getRegistryName(), "inventory"));
        this.registerItem(ObjHandler.mercEye);
        this.registerItem(ObjHandler.dmPick);
        this.registerItem(ObjHandler.dmAxe);
        this.registerItem(ObjHandler.dmShovel);
        this.registerItem(ObjHandler.dmSword);
        this.registerItem(ObjHandler.dmHoe);
        this.registerItem(ObjHandler.dmShears);
        this.registerItem(ObjHandler.dmHammer);
        this.registerItem(ObjHandler.dmHelmet);
        this.registerItem(ObjHandler.dmChest);
        this.registerItem(ObjHandler.dmLegs);
        this.registerItem(ObjHandler.dmFeet);
        this.registerItem(ObjHandler.rmPick);
        this.registerItem(ObjHandler.rmAxe);
        this.registerItem(ObjHandler.rmShovel);
        this.registerItem(ObjHandler.rmSword);
        this.registerItem(ObjHandler.rmHoe);
        this.registerItem(ObjHandler.rmShears);
        this.registerItem(ObjHandler.rmHammer);
        this.registerItem(ObjHandler.rmKatar);
        this.registerItem(ObjHandler.rmStar);
        this.registerItem(ObjHandler.rmHelmet);
        this.registerItem(ObjHandler.rmChest);
        this.registerItem(ObjHandler.rmLegs);
        this.registerItem(ObjHandler.rmFeet);
        this.registerItem(ObjHandler.gemHelmet);
        this.registerItem(ObjHandler.gemChest);
        this.registerItem(ObjHandler.gemLegs);
        this.registerItem(ObjHandler.gemFeet);
        this.registerItem(ObjHandler.manual);
        this.registerBlock(ObjHandler.alchChest);
        this.registerBlock(ObjHandler.collectorMK2);
        this.registerBlock(ObjHandler.collectorMK3);
        this.registerBlock(ObjHandler.condenser);
        this.registerBlock(ObjHandler.condenserMk2);
        this.registerBlock(ObjHandler.confuseTorch);
        this.registerBlock(ObjHandler.dmFurnaceOff);
        this.registerBlock(ObjHandler.dmPedestal);
        this.registerBlock(ObjHandler.energyCollector);
        this.registerBlock(ObjHandler.novaCatalyst);
        this.registerBlock(ObjHandler.novaCataclysm);
        this.registerBlock(ObjHandler.relay);
        this.registerBlock(ObjHandler.relayMK2);
        this.registerBlock(ObjHandler.relayMK3);
        this.registerBlock(ObjHandler.rmFurnaceOff);
        this.registerBlock(ObjHandler.transmuteStone);
    }

    private void registerBlock(Block b) {
        String name = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)b).toString();
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)b), (int)0, (ModelResourceLocation)new ModelResourceLocation(name, "inventory"));
    }

    private void registerItem(Item i) {
        this.registerItem(i, 0);
    }

    private void registerItem(Item i, int meta) {
        String name = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)i).toString();
        ModelLoader.setCustomModelResourceLocation((Item)i, (int)meta, (ModelResourceLocation)new ModelResourceLocation(name, "inventory"));
    }

    private void registerCovalenceDust() {
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.covalence, (int)0, (ModelResourceLocation)new ModelResourceLocation("projecte:covalence_low", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.covalence, (int)1, (ModelResourceLocation)new ModelResourceLocation("projecte:covalence_medium", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.covalence, (int)2, (ModelResourceLocation)new ModelResourceLocation("projecte:covalence_high", "inventory"));
    }

    private void registerBags() {
        for (EnumDyeColor e : EnumDyeColor.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.alchBag, (int)e.func_176765_a(), (ModelResourceLocation)new ModelResourceLocation("projecte:bags/alchbag_" + e.func_176610_l(), "inventory"));
        }
    }

    private void registerFuels() {
        for (EnumFuelType e : EnumFuelType.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.fuels, (int)e.ordinal(), (ModelResourceLocation)new ModelResourceLocation("projecte:" + e.func_176610_l(), "inventory"));
            String name = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)ObjHandler.fuelBlock).toString();
            ModelLoader.registerItemVariants((Item)Item.func_150898_a((Block)ObjHandler.fuelBlock), (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(name, "fueltype=" + e.func_176610_l())});
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ObjHandler.fuelBlock), (int)e.ordinal(), (ModelResourceLocation)new ModelResourceLocation(name, "fueltype=" + e.func_176610_l()));
        }
    }

    private void registerMatter() {
        for (EnumMatterType m : EnumMatterType.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.matter, (int)m.ordinal(), (ModelResourceLocation)new ModelResourceLocation("projecte:" + m.func_176610_l(), "inventory"));
            String name = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)ObjHandler.matterBlock).toString();
            ModelLoader.registerItemVariants((Item)Item.func_150898_a((Block)ObjHandler.matterBlock), (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(name, "tier=" + m.func_176610_l())});
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ObjHandler.matterBlock), (int)m.ordinal(), (ModelResourceLocation)new ModelResourceLocation(name, "tier=" + m.func_176610_l()));
        }
    }

    private void registerKlein() {
        for (KleinStar.EnumKleinTier e : KleinStar.EnumKleinTier.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.kleinStars, (int)e.ordinal(), (ModelResourceLocation)new ModelResourceLocation("projecte:stars/klein_star_" + e.name, "inventory"));
        }
    }

    private void registerPowerStones() {
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.bodyStone, (int)0, (ModelResourceLocation)new ModelResourceLocation("projecte:body_stone_off", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.bodyStone, (int)1, (ModelResourceLocation)new ModelResourceLocation("projecte:body_stone_on", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.soulStone, (int)0, (ModelResourceLocation)new ModelResourceLocation("projecte:soul_stone_off", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.soulStone, (int)1, (ModelResourceLocation)new ModelResourceLocation("projecte:soul_stone_on", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.mindStone, (int)0, (ModelResourceLocation)new ModelResourceLocation("projecte:mind_stone_off", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.mindStone, (int)1, (ModelResourceLocation)new ModelResourceLocation("projecte:mind_stone_on", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.lifeStone, (int)0, (ModelResourceLocation)new ModelResourceLocation("projecte:life_stone_off", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.lifeStone, (int)1, (ModelResourceLocation)new ModelResourceLocation("projecte:life_stone_on", "inventory"));
    }

    private void registerPowerItems() {
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.blackHole, (int)0, (ModelResourceLocation)new ModelResourceLocation("projecte:bhb_off", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.blackHole, (int)1, (ModelResourceLocation)new ModelResourceLocation("projecte:bhb_on", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.harvestGod, (int)0, (ModelResourceLocation)new ModelResourceLocation("projecte:harvgod_off", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.harvestGod, (int)1, (ModelResourceLocation)new ModelResourceLocation("projecte:harvgod_on", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.eternalDensity, (int)0, (ModelResourceLocation)new ModelResourceLocation("projecte:goed_off", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.eternalDensity, (int)1, (ModelResourceLocation)new ModelResourceLocation("projecte:goed_on", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.timeWatch, (int)0, (ModelResourceLocation)new ModelResourceLocation("projecte:timewatch_off", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.timeWatch, (int)1, (ModelResourceLocation)new ModelResourceLocation("projecte:timewatch_on", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.ignition, (int)0, (ModelResourceLocation)new ModelResourceLocation("projecte:ignition_off", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.ignition, (int)1, (ModelResourceLocation)new ModelResourceLocation("projecte:ignition_on", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.zero, (int)0, (ModelResourceLocation)new ModelResourceLocation("projecte:zero_off", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.zero, (int)1, (ModelResourceLocation)new ModelResourceLocation("projecte:zero_on", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.swrg, (int)0, (ModelResourceLocation)new ModelResourceLocation("projecte:swrg_off", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.swrg, (int)1, (ModelResourceLocation)new ModelResourceLocation("projecte:swrg_fly", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.swrg, (int)2, (ModelResourceLocation)new ModelResourceLocation("projecte:swrg_repel", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.swrg, (int)3, (ModelResourceLocation)new ModelResourceLocation("projecte:swrg_both", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.voidRing, (int)0, (ModelResourceLocation)new ModelResourceLocation("projecte:voidring_off", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.voidRing, (int)1, (ModelResourceLocation)new ModelResourceLocation("projecte:voidring_on", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.arcana, (int)0, (ModelResourceLocation)new ModelResourceLocation("projecte:arcana_zero_off", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.arcana, (int)1, (ModelResourceLocation)new ModelResourceLocation("projecte:arcana_ignition_off", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.arcana, (int)2, (ModelResourceLocation)new ModelResourceLocation("projecte:arcana_harv_off", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.arcana, (int)3, (ModelResourceLocation)new ModelResourceLocation("projecte:arcana_swrg_off", "inventory"));
    }

    @Override
    public void registerRenderers() {
        ClientRegistry.bindTileEntitySpecialRenderer(AlchChestTile.class, (TileEntitySpecialRenderer)new ChestRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(CondenserTile.class, (TileEntitySpecialRenderer)new CondenserRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(CondenserMK2Tile.class, (TileEntitySpecialRenderer)new CondenserMK2Renderer());
        ClientRegistry.bindTileEntitySpecialRenderer(DMPedestalTile.class, (TileEntitySpecialRenderer)new PedestalRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityWaterProjectile.class, ClientProxy.createRenderFactoryForSnowball(ObjHandler.waterOrb));
        RenderingRegistry.registerEntityRenderingHandler(EntityLavaProjectile.class, ClientProxy.createRenderFactoryForSnowball(ObjHandler.lavaOrb));
        RenderingRegistry.registerEntityRenderingHandler(EntityMobRandomizer.class, ClientProxy.createRenderFactoryForSnowball(ObjHandler.mobRandomizer));
        RenderingRegistry.registerEntityRenderingHandler(EntityLensProjectile.class, ClientProxy.createRenderFactoryForSnowball(ObjHandler.lensExplosive));
        RenderingRegistry.registerEntityRenderingHandler(EntityFireProjectile.class, ClientProxy.createRenderFactoryForSnowball(ObjHandler.fireProjectile));
        RenderingRegistry.registerEntityRenderingHandler(EntitySWRGProjectile.class, ClientProxy.createRenderFactoryForSnowball(ObjHandler.windProjectile));
        RenderingRegistry.registerEntityRenderingHandler(EntityNovaCatalystPrimed.class, NovaCatalystRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityNovaCataclysmPrimed.class, NovaCataclysmRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHomingArrow.class, RenderTippedArrow::new);
    }

    @Override
    public void registerLayerRenderers() {
        Map skinMap = Minecraft.func_71410_x().func_175598_ae().getSkinMap();
        RenderPlayer render = (RenderPlayer)skinMap.get("default");
        render.func_177094_a((LayerRenderer)new LayerYue(render));
        render = (RenderPlayer)skinMap.get("slim");
        render.func_177094_a((LayerRenderer)new LayerYue(render));
    }

    private static <T extends Entity> IRenderFactory<T> createRenderFactoryForSnowball(Item itemToRender) {
        return manager -> new RenderSnowball(manager, itemToRender, Minecraft.func_71410_x().func_175599_af());
    }

    @Override
    public void registerClientOnlyEvents() {
        MinecraftForge.EVENT_BUS.register((Object)new TransmutationRenderingEvent());
    }

    @Override
    public void initializeManual() {
        ManualPageHandler.init();
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return FMLClientHandler.instance().getClientPlayerEntity();
    }

    @Override
    public boolean isJumpPressed() {
        return FMLClientHandler.instance().getClient().field_71474_y.field_74314_A.func_151470_d();
    }
}

