/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.rendering;

import javax.annotation.Nonnull;
import moze_intel.projecte.api.state.PEStateProps;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.tiles.CondenserTile;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CondenserRenderer
extends TileEntitySpecialRenderer<CondenserTile> {
    private final ResourceLocation texture = new ResourceLocation("ProjectE".toLowerCase(), "textures/blocks/condenser.png");
    private final ModelChest model = new ModelChest();

    public void renderTileEntityAt(@Nonnull CondenserTile condenser, double x, double y, double z, float par8, int par9) {
        EnumFacing direction = null;
        if (condenser.func_145831_w() != null && !condenser.func_145837_r()) {
            IBlockState state = condenser.func_145831_w().func_180495_p(condenser.func_174877_v());
            direction = state.func_177230_c() == ObjHandler.condenser ? (EnumFacing)state.func_177229_b(PEStateProps.FACING) : null;
        }
        this.func_147499_a(this.texture);
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)x, (double)(y + 1.0), (double)(z + 1.0));
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
        int angle = 0;
        if (direction != null) {
            switch (direction) {
                case NORTH: {
                    angle = 180;
                    break;
                }
                case SOUTH: {
                    angle = 0;
                    break;
                }
                case WEST: {
                    angle = 90;
                    break;
                }
                case EAST: {
                    angle = -90;
                }
            }
        }
        GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        float adjustedLidAngle = condenser.prevLidAngle + (condenser.lidAngle - condenser.prevLidAngle) * par8;
        adjustedLidAngle = 1.0f - adjustedLidAngle;
        adjustedLidAngle = 1.0f - adjustedLidAngle * adjustedLidAngle * adjustedLidAngle;
        this.model.field_78234_a.field_78795_f = -(adjustedLidAngle * (float)Math.PI / 2.0f);
        this.model.func_78231_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

