/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import baubles.api.BaublesApi;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.CooldownResetPKT;
import moze_intel.projecte.network.packets.SetFlyPKT;
import moze_intel.projecte.network.packets.StepHeightPKT;
import moze_intel.projecte.utils.ReflectionHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketAnimation;
import net.minecraft.scoreboard.IScoreCriteria;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class PlayerHelper {
    public static boolean checkedPlaceBlock(EntityPlayerMP player, BlockPos pos, IBlockState state) {
        if (!PlayerHelper.hasEditPermission(player, pos)) {
            return false;
        }
        World world = player.func_130014_f_();
        BlockSnapshot before = BlockSnapshot.getBlockSnapshot((World)world, (BlockPos)pos);
        world.func_175656_a(pos, state);
        BlockEvent.PlaceEvent evt = new BlockEvent.PlaceEvent(before, Blocks.field_150350_a.func_176223_P(), (EntityPlayer)player);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        if (evt.isCanceled()) {
            world.restoringBlockSnapshots = true;
            before.restore(true, false);
            world.restoringBlockSnapshots = false;
            return false;
        }
        return true;
    }

    public static boolean checkedReplaceBlock(EntityPlayerMP player, BlockPos pos, IBlockState state) {
        return PlayerHelper.hasBreakPermission(player, pos) && PlayerHelper.checkedPlaceBlock(player, pos, state);
    }

    public static ItemStack findFirstItem(EntityPlayer player, ItemPE consumeFrom) {
        for (ItemStack s : player.field_71071_by.field_70462_a) {
            if (s == null || s.func_77973_b() != consumeFrom) continue;
            return s;
        }
        return null;
    }

    public static IItemHandler getBaubles(EntityPlayer player) {
        if (!Loader.isModLoaded((String)"Baubles")) {
            return null;
        }
        return BaublesApi.getBaublesHandler((EntityPlayer)player);
    }

    public static BlockPos getBlockLookingAt(EntityPlayer player, double maxDistance) {
        Pair<Vec3d, Vec3d> vecs = PlayerHelper.getLookVec(player, maxDistance);
        RayTraceResult mop = player.func_130014_f_().func_72933_a((Vec3d)vecs.getLeft(), (Vec3d)vecs.getRight());
        if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK) {
            return mop.func_178782_a();
        }
        return null;
    }

    public static Pair<Vec3d, Vec3d> getLookVec(EntityPlayer player, double maxDistance) {
        Vec3d look = player.func_70676_i(1.0f);
        Vec3d playerPos = new Vec3d(player.field_70165_t, player.field_70163_u + (double)(player.func_70047_e() - player.getDefaultEyeHeight()), player.field_70161_v);
        Vec3d src = playerPos.func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
        Vec3d dest = src.func_72441_c(look.field_72450_a * maxDistance, look.field_72448_b * maxDistance, look.field_72449_c * maxDistance);
        return ImmutablePair.of((Object)src, (Object)dest);
    }

    public static boolean hasBreakPermission(EntityPlayerMP player, BlockPos pos) {
        return PlayerHelper.hasEditPermission(player, pos) && ForgeHooks.onBlockBreakEvent((World)player.func_130014_f_(), (GameType)player.field_71134_c.func_73081_b(), (EntityPlayerMP)player, (BlockPos)pos) != -1;
    }

    public static boolean hasEditPermission(EntityPlayerMP player, BlockPos pos) {
        if (FMLCommonHandler.instance().getMinecraftServerInstance().func_175579_a(player.func_130014_f_(), pos, (EntityPlayer)player)) {
            return false;
        }
        for (EnumFacing e : EnumFacing.field_82609_l) {
            if (player.func_175151_a(pos, e, null)) continue;
            return false;
        }
        return true;
    }

    public static void resetCooldown(EntityPlayer player) {
        player.func_184821_cY();
        PacketHandler.sendTo(new CooldownResetPKT(), (EntityPlayerMP)player);
    }

    public static void setPlayerFireImmunity(EntityPlayer player, boolean value) {
        ReflectionHelper.setEntityFireImmunity((Entity)player, value);
    }

    public static void setPlayerWalkSpeed(EntityPlayer player, float value) {
        ReflectionHelper.setPlayerCapabilityWalkspeed(player.field_71075_bZ, value);
    }

    public static void swingItem(EntityPlayer player, EnumHand hand) {
        if (player.func_130014_f_() instanceof WorldServer) {
            ((WorldServer)player.func_130014_f_()).func_73039_n().func_151248_b((Entity)player, (Packet)new SPacketAnimation((Entity)player, hand == EnumHand.MAIN_HAND ? 0 : 3));
        }
    }

    public static void updateClientServerFlight(EntityPlayerMP player, boolean state) {
        PacketHandler.sendTo(new SetFlyPKT(state), player);
        player.field_71075_bZ.field_75101_c = state;
        if (!state) {
            player.field_71075_bZ.field_75100_b = false;
        }
    }

    public static void updateClientServerStepHeight(EntityPlayerMP player, float value) {
        player.field_70138_W = value;
        PacketHandler.sendTo(new StepHeightPKT(value), player);
    }

    public static void updateScore(EntityPlayerMP player, IScoreCriteria objective, int value) {
        ReflectionHelper.updateScore(player, objective, value);
    }
}

