/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.asm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import net.ilexiconn.llibrary.server.core.plugin.LLibraryPlugin;

public enum MappingHandler {
    INSTANCE;

    private Map<String, String> fields;
    private Map<String, String> methods;

    public void parseMappings(InputStream stream) throws IOException {
        String line;
        this.fields = new HashMap<String, String>();
        this.methods = new HashMap<String, String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        while ((line = reader.readLine()) != null) {
            String[] split = line.split("=");
            String key = split[0];
            String value = split[1];
            if (key.contains("(")) {
                this.methods.put(key, value);
                continue;
            }
            this.fields.put(key, value);
        }
        reader.close();
    }

    public String getClassMapping(String cls) {
        return cls.replace(".", "/");
    }

    public String getClassMapping(Object obj) {
        if (obj instanceof String) {
            return this.getClassMapping((String)obj);
        }
        if (obj instanceof Class) {
            return ((Class)obj).getName();
        }
        return "";
    }

    public String getMethodMapping(Object obj, String method, String desc) {
        if (LLibraryPlugin.inDevelopment) {
            return method;
        }
        String cls = this.getClassMapping(obj);
        String key = cls + "/" + method + desc;
        return this.methods.getOrDefault(key, method);
    }

    public String getFieldMapping(Object obj, String field) {
        if (LLibraryPlugin.inDevelopment) {
            return field;
        }
        String cls = this.getClassMapping(obj);
        String key = cls + "/" + field;
        return this.fields.getOrDefault(key, field);
    }
}

