/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.nbt;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.server.nbt.NBTMutatorProperty;
import net.ilexiconn.llibrary.server.nbt.NBTProperty;
import net.ilexiconn.llibrary.server.nbt.parser.INBTParser;
import net.ilexiconn.llibrary.server.nbt.parser.NBTParsers;
import net.minecraft.crash.CrashReport;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public enum NBTHandler {
    INSTANCE;

    private Map<Class<?>, INBTParser<?, ?>> nbtParserMap = new HashMap();

    public <V, T extends NBTBase> void registerNBTParser(Class<V> type, INBTParser<V, T> nbtParser) {
        this.nbtParserMap.put(type, nbtParser);
    }

    public void loadNBTData(Object object, NBTTagCompound compound) {
        Class<?> clazz = object.getClass();
        do {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (field.isAnnotationPresent(NBTProperty.class)) {
                    field.setAccessible(true);
                    String name = field.getAnnotation(NBTProperty.class).name();
                    if (name.isEmpty()) {
                        name = field.getName();
                    }
                    this.readFromNBTToField(object, field, name, compound);
                    continue;
                }
                if (!field.isAnnotationPresent(NBTMutatorProperty.class)) continue;
                NBTMutatorProperty mutatorProperty = field.getAnnotation(NBTMutatorProperty.class);
                String name = mutatorProperty.name();
                if (name.isEmpty()) {
                    name = field.getName();
                }
                Class<?> type = mutatorProperty.type();
                Method setter = this.getSetter(clazz, name, type, mutatorProperty.setter());
                this.readFromNBTToSetter(object, setter, name, compound);
            }
        } while ((clazz = clazz.getSuperclass()) != null);
    }

    public void saveNBTData(Object object, NBTTagCompound compound) {
        Class<?> clazz = object.getClass();
        do {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                Class<?> type;
                Method getter;
                Object tag;
                if (field.isAnnotationPresent(NBTProperty.class)) {
                    Object tag2;
                    field.setAccessible(true);
                    String name = field.getAnnotation(NBTProperty.class).name();
                    if (name.isEmpty()) {
                        name = field.getName();
                    }
                    if ((tag2 = this.writeFieldToNBT(object, field)) == null) continue;
                    compound.func_74782_a(name, tag2);
                    continue;
                }
                if (!field.isAnnotationPresent(NBTMutatorProperty.class)) continue;
                NBTMutatorProperty mutatorProperty = field.getAnnotation(NBTMutatorProperty.class);
                String name = mutatorProperty.name();
                if (name.isEmpty()) {
                    name = field.getName();
                }
                if ((tag = this.writeGetterValueToNBT(object, getter = this.getGetter(clazz, name, type = mutatorProperty.type(), mutatorProperty.getter()))) == null) continue;
                compound.func_74782_a(name, tag);
            }
        } while ((clazz = clazz.getSuperclass()) != null);
    }

    public <V, T extends NBTBase> INBTParser<V, T> getParserForType(Class<V> type) {
        INBTParser nbtParser = NBTParsers.getBuiltinParser(type);
        if (nbtParser != null) {
            return nbtParser;
        }
        if (this.nbtParserMap.containsKey(type)) {
            return this.nbtParserMap.get(type);
        }
        return null;
    }

    private <V, T extends NBTBase> T writeFieldToNBT(V object, Field field) {
        Object value;
        try {
            value = field.get(object);
        }
        catch (Exception e) {
            LLibrary.LOGGER.fatal(CrashReport.func_85055_a((Throwable)e.getCause(), (String)e.getCause().getLocalizedMessage()).func_71502_e());
            return null;
        }
        return this.writeToNBT(field.getType(), value);
    }

    private <V, T extends NBTBase> T writeGetterValueToNBT(V object, Method getter) {
        Object value;
        try {
            value = getter.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            LLibrary.LOGGER.fatal(CrashReport.func_85055_a((Throwable)e.getCause(), (String)e.getCause().getLocalizedMessage()).func_71502_e());
            return null;
        }
        return this.writeToNBT(getter.getReturnType(), value);
    }

    private <V, T extends NBTBase> T writeToNBT(Class<V> type, V value) {
        if (value == null) {
            return null;
        }
        INBTParser<V, T> nbtParser = this.getParserForType(type);
        if (nbtParser != null) {
            return nbtParser.parseValue(value);
        }
        NBTTagCompound compound = new NBTTagCompound();
        this.saveNBTData(value, compound);
        return (T)compound;
    }

    private void readFromNBTToField(Object object, Field field, String name, NBTTagCompound compound) {
        NBTBase valueNBT = compound.func_74781_a(name);
        if (valueNBT == null) {
            return;
        }
        Object value = this.readFromNBT(field.getType(), valueNBT);
        try {
            field.set(object, value);
        }
        catch (Exception e) {
            LLibrary.LOGGER.fatal(CrashReport.func_85055_a((Throwable)e.getCause(), (String)e.getCause().getLocalizedMessage()).func_71502_e());
        }
    }

    private void readFromNBTToSetter(Object object, Method setter, String name, NBTTagCompound compound) {
        NBTBase valueNBT = compound.func_74781_a(name);
        if (valueNBT == null) {
            return;
        }
        Object value = this.readFromNBT(setter.getParameters()[0].getType(), valueNBT);
        try {
            setter.invoke(object, value);
        }
        catch (Exception e) {
            LLibrary.LOGGER.fatal(CrashReport.func_85055_a((Throwable)e.getCause(), (String)e.getCause().getLocalizedMessage()).func_71502_e());
        }
    }

    private <V, T extends NBTBase> V readFromNBT(Class<V> type, T tag) {
        INBTParser<V, T> nbtParser = this.getParserForType(type);
        if (nbtParser != null) {
            return nbtParser.parseTag(tag);
        }
        return null;
    }

    private Method getSetter(Class<?> clazz, String name, Class<?> type, String setter) {
        String setterName = this.getConventionalSetterName(name, setter);
        return this.resolveMutator(clazz, setterName, type);
    }

    private Method getGetter(Class<?> clazz, String name, Class<?> type, String getter) {
        String getterName = this.getConventionalGetterName(name, type, getter);
        return this.resolveMutator(clazz, getterName, new Class[0]);
    }

    private Method resolveMutator(Class<?> clazz, String name, Class<?> ... param) {
        Method method = null;
        Class<?> methodClass = clazz;
        while (true) {
            try {
                method = methodClass.getDeclaredMethod(name, param);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if ((methodClass = methodClass.getSuperclass()) != null) continue;
            }
            break;
        }
        if (method == null) {
            String message = clazz.getName() + "." + name + "(" + (param.length == 0 ? "" : (param[0] == null ? "null" : param[0].getName())) + ")";
            LLibrary.LOGGER.fatal((Object)CrashReport.func_85055_a((Throwable)new RuntimeException(message), (String)message));
            return null;
        }
        method.setAccessible(true);
        return method;
    }

    private String getConventionalSetterName(String name, String setter) {
        return this.getConventionalMutatorName("set", name, setter);
    }

    private String getConventionalGetterName(String name, Class<?> type, String getter) {
        return this.getConventionalMutatorName(type == Boolean.class || type == Boolean.TYPE ? "is" : "get", name, getter);
    }

    private String getConventionalMutatorName(String verb, String name, String mutator) {
        if (mutator.isEmpty()) {
            return verb + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }
        return mutator;
    }
}

