/*
 * Decompiled with CFR 0.152.
 */
package elucent.roots.component.components;

import elucent.roots.PlayerManager;
import elucent.roots.RegistryManager;
import elucent.roots.Util;
import elucent.roots.component.ComponentBase;
import elucent.roots.component.EnumCastType;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ComponentLilac
extends ComponentBase {
    Random random = new Random();

    public ComponentLilac() {
        super("lilac", "Growth", (Block)Blocks.field_150398_cm, 1, 14);
    }

    public boolean growBlockSafe(World world, BlockPos pos, int potency) {
        if (world.func_180495_p(pos).func_177230_c() instanceof IGrowable && this.random.nextInt(5 - potency) < 2) {
            IBlockState prev = world.func_180495_p(pos);
            ((IGrowable)world.func_180495_p(pos).func_177230_c()).func_176474_b(world, this.random, pos, world.func_180495_p(pos));
            world.func_184138_a(pos, prev, world.func_180495_p(pos), 8);
            return true;
        }
        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150388_bm && this.random.nextInt(5 - potency) < 2) {
            BlockNetherWart wart = (BlockNetherWart)world.func_180495_p(pos).func_177230_c();
            IBlockState state = world.func_180495_p(pos);
            int age = (Integer)state.func_177229_b((IProperty)BlockNetherWart.field_176486_a);
            if (age < 3) {
                IBlockState newState = state.func_177226_a((IProperty)BlockNetherWart.field_176486_a, (Comparable)Integer.valueOf(age + 1));
                world.func_180501_a(pos, newState, 3);
                world.func_184138_a(pos, state, newState, 8);
                return true;
            }
        }
        return false;
    }

    @Override
    public void doEffect(World world, Entity caster, EnumCastType type, double x, double y, double z, double potency, double duration, double size) {
        if (type == EnumCastType.SPELL && !world.field_72995_K) {
            BlockPos pos = Util.getRayTraceNonFull(world, (EntityPlayer)caster, 6 + 2 * (int)size);
            for (int i = -((int)size) - 1; i < (int)size + 2; ++i) {
                for (int j = -((int)size) - 1; j < (int)size + 2; ++j) {
                    this.growBlockSafe(world, pos.func_177982_a(i, 0, j), (int)potency);
                }
            }
            boolean fullEfficiency = true;
            if (fullEfficiency && caster instanceof EntityPlayer && !((EntityPlayer)caster).func_189102_a(RegistryManager.achieveSpellGrowth)) {
                PlayerManager.addAchievement((EntityPlayer)caster, RegistryManager.achieveSpellGrowth);
            }
        }
    }

    @Override
    public void doEffect(World world, UUID casterId, Vec3d direction, EnumCastType type, double x, double y, double z, double potency, double duration, double size) {
        if (type == EnumCastType.SPELL && !world.field_72995_K) {
            EntityPlayer player;
            BlockPos pos = new BlockPos(x, y, z);
            for (int i = -((int)size) - 1; i < (int)size + 2; ++i) {
                for (int j = -((int)size) - 1; j < (int)size + 2; ++j) {
                    this.growBlockSafe(world, pos.func_177982_a(i, 0, j), (int)potency);
                }
            }
            boolean fullEfficiency = true;
            if (fullEfficiency && (player = world.func_152378_a(casterId)) != null && !player.func_189102_a(RegistryManager.achieveSpellGrowth)) {
                PlayerManager.addAchievement(player, RegistryManager.achieveSpellGrowth);
            }
        }
    }
}

