/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.blueprints;

import java.util.EnumSet;
import mod.chiselsandbits.blueprints.BlueprintData;
import mod.chiselsandbits.blueprints.BlueprintRenderWorld;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.client.RenderHelper;
import mod.chiselsandbits.core.Log;
import mod.chiselsandbits.render.chiseledblock.ChiselLayer;
import mod.chiselsandbits.render.chiseledblock.ChiseledBlockBaked;
import mod.chiselsandbits.render.chiseledblock.ChiseledBlockSmartModel;
import mod.chiselsandbits.render.chiseledblock.tesr.ChisledBlockRenderChunkTESR;
import mod.chiselsandbits.render.helpers.DeleteDisplayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.lwjgl.opengl.GL11;

public class BlueprintRenderData
implements Runnable {
    Tessellator t;
    int displayList = 0;
    BlueprintData data;

    public void render() {
        if (this.t != null) {
            this.displayList = GLAllocation.func_74526_a((int)1);
            try {
                GL11.glNewList((int)this.displayList, (int)4864);
                this.t.func_78381_a();
            }
            catch (IllegalStateException e) {
                Log.logError("Erratic Tessellator Behavior", e);
            }
            finally {
                GL11.glEndList();
                this.t = null;
            }
        }
        if (this.displayList != 0) {
            GL11.glCallList((int)this.displayList);
        }
    }

    public BlueprintRenderData(BlueprintData data) {
        if (data.getState() == BlueprintData.EnumLoadState.LOADED) {
            this.data = data;
            Thread t = new Thread(this);
            t.setName("Blueprint Model Generation Thread");
            t.start();
        }
    }

    @Override
    public void run() {
        Tessellator tessellator = new Tessellator(0);
        BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        VertexBuffer worldrenderer = tessellator.func_178180_c();
        BlockPos chunkOffset = BlockPos.field_177992_a;
        try {
            worldrenderer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            worldrenderer.func_178969_c((double)(-chunkOffset.func_177958_n()), (double)(-chunkOffset.func_177956_o()), (double)(-chunkOffset.func_177952_p()));
        }
        catch (IllegalStateException e) {
            Log.logError("Invalid Tessellator Behavior", e);
        }
        EnumSet<ChiselLayer> layers = EnumSet.allOf(ChiselLayer.class);
        BlueprintRenderWorld rw = new BlueprintRenderWorld(this.data);
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)BlockPos.field_177992_a, (BlockPos)new BlockPos(this.data.getXSize(), this.data.getYSize(), this.data.getZSize()))) {
            TileEntityBlockChiseled tx = rw.getChisledEntity(pos);
            worldrenderer.func_178969_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            if (tx != null) {
                IExtendedBlockState estate = tx.getRenderState();
                for (ChiselLayer lx : layers) {
                    ChiseledBlockBaked model = ChiseledBlockSmartModel.getCachedModel((TileEntityBlockChiseled)tx, (ChiselLayer)lx, (VertexFormat)DefaultVertexFormats.field_176599_b);
                    if (model.isEmpty()) continue;
                    RenderHelper.uploadBlockModel((VertexBuffer)worldrenderer, (IBakedModel)model, (IBlockAccess)rw, (BlockPos)pos, (int)200);
                }
                continue;
            }
            IBlockState state = rw.getBlockState(pos);
            if (state.func_177230_c() == Blocks.field_150350_a) continue;
            state = state.func_185899_b((IBlockAccess)rw, pos);
            IBakedModel model = blockRenderer.func_175023_a().func_178125_b(state);
            if (model == null) continue;
            RenderHelper.uploadBlockModel((VertexBuffer)worldrenderer, (IBakedModel)model, (IBlockAccess)rw, (BlockPos)pos, (int)200);
        }
        this.t = tessellator;
    }

    protected void finalize() throws Throwable {
        if (this.displayList != 0) {
            ChisledBlockRenderChunkTESR.addTask((Runnable)new DeleteDisplayList(this.displayList));
        }
    }
}

