/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock.data;

import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import net.minecraft.util.math.BlockPos;

public class BitIterator {
    private static final int zInc = 256;
    private static final int yInc = 16;
    private final int xMin;
    private final int yMin;
    private final int yMinOffset;
    private final int xMax;
    private final int yMax;
    private final int zMax;
    private int zOffset = 0;
    private int yOffset = 0;
    private int combined = 0;
    private int bit;
    public int x = -1;
    public int y;
    public int z;

    public BitIterator() {
        this.yMinOffset = 0;
        this.xMin = 0;
        this.yMin = 0;
        this.xMax = 16;
        this.yMax = 256;
        this.zMax = 4096;
    }

    public BitIterator(BlockPos a, BlockPos b) {
        this.x = this.clampToRange(Math.min(a.func_177958_n(), b.func_177958_n()));
        this.xMin = this.x--;
        this.yMin = this.y = this.clampToRange(Math.min(a.func_177956_o(), b.func_177956_o()));
        this.z = this.clampToRange(Math.min(a.func_177952_p(), b.func_177952_p()));
        this.yOffset = this.yMinOffset = 16 * this.y;
        this.zOffset = 256 * this.z;
        this.xMax = this.clampToRange(Math.max(a.func_177958_n(), b.func_177958_n())) + 1;
        this.yMax = 16 * (this.clampToRange(Math.max(a.func_177956_o(), b.func_177956_o())) + 1);
        this.zMax = 256 * (this.clampToRange(Math.max(a.func_177952_p(), b.func_177952_p())) + 1);
        this.combined = this.zOffset | this.yOffset;
    }

    public int clampToRange(int a) {
        return Math.max(0, Math.min(15, a));
    }

    protected void yPlus() {
        this.x = this.xMin;
        ++this.y;
        this.yOffset += 16;
    }

    protected void zPlus() {
        this.y = this.yMin;
        this.yOffset = this.yMinOffset;
        ++this.z;
        this.zOffset += 256;
    }

    public boolean hasNext() {
        ++this.x;
        if (this.x >= this.xMax) {
            this.yPlus();
            if (this.yOffset >= this.yMax) {
                this.zPlus();
                if (this.zOffset >= this.zMax) {
                    this.done();
                    return false;
                }
            }
            this.combined = this.zOffset | this.yOffset;
        }
        this.bit = this.combined | this.x;
        return true;
    }

    protected void done() {
    }

    public int getNext(VoxelBlob blob) {
        return blob.getBit(this.bit);
    }

    public void setNext(VoxelBlob blob, int value) {
        blob.putBit(this.bit, value);
    }
}

