/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.mrcrayfish.furniture.blocks.BlockFurniture;
import com.mrcrayfish.furniture.util.CollisionHelper;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFairyLight
extends BlockFurniture {
    public static final PropertyEnum TYPE = PropertyEnum.func_177709_a((String)"type", FairyLightType.class);
    private static final AxisAlignedBB BOUNDING_BOX_NORTH = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.375, 0.6875, 0.0, 0.6875, 1.0, 1.0);
    private static final AxisAlignedBB BOUNDING_BOX_EAST = CollisionHelper.getBlockBounds(EnumFacing.EAST, 0.375, 0.6875, 0.0, 0.6875, 1.0, 1.0);
    private static final AxisAlignedBB BOUNDING_BOX_SOUTH = CollisionHelper.getBlockBounds(EnumFacing.SOUTH, 0.375, 0.6875, 0.0, 0.6875, 1.0, 1.0);
    private static final AxisAlignedBB BOUNDING_BOX_WEST = CollisionHelper.getBlockBounds(EnumFacing.WEST, 0.375, 0.6875, 0.0, 0.6875, 1.0, 1.0);
    private static final AxisAlignedBB[] BOUNDING_BOX = new AxisAlignedBB[]{BOUNDING_BOX_SOUTH, BOUNDING_BOX_WEST, BOUNDING_BOX_NORTH, BOUNDING_BOX_EAST};

    public BlockFairyLight(Material materialIn) {
        super(materialIn);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)TYPE, (Comparable)((Object)FairyLightType.EVEN)));
        this.func_149715_a(0.5f);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185853_f);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (pos.func_177958_n() % 2 == pos.func_177952_p() % 2) {
            return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)FairyLightType.EVEN));
        }
        return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)FairyLightType.ODD));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return BOUNDING_BOX[facing.func_176736_b()];
    }

    public AxisAlignedBB func_180646_a(IBlockState worldIn, World pos, BlockPos state) {
        return field_185506_k;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TYPE});
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public static enum FairyLightType implements IStringSerializable
    {
        EVEN,
        ODD;


        public String func_176610_l() {
            return this.toString().toLowerCase();
        }
    }
}

