/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.mrcrayfish.furniture.MrCrayfishFurnitureMod;
import com.mrcrayfish.furniture.api.RecipeAPI;
import com.mrcrayfish.furniture.blocks.BlockFurnitureTile;
import com.mrcrayfish.furniture.init.FurnitureItems;
import com.mrcrayfish.furniture.tileentity.TileEntityGrill;
import com.mrcrayfish.furniture.util.ParticleHelper;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGrill
extends BlockFurnitureTile {
    public BlockGrill(Material material) {
        super(material);
        this.func_149711_c(1.5f);
        this.func_149647_a(MrCrayfishFurnitureMod.tabFurniture);
    }

    public void func_180655_c(IBlockState state, World worldIn, BlockPos pos, Random rand) {
        TileEntityGrill tileEntityGrill;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityGrill && (tileEntityGrill = (TileEntityGrill)tileEntity).isFireStarted()) {
            if (RANDOM.nextInt(2) == 0) {
                double posX = 0.2 + 0.6 * RANDOM.nextDouble();
                double posZ = 0.2 + 0.6 * RANDOM.nextDouble();
                worldIn.func_175688_a(EnumParticleTypes.FLAME, (double)pos.func_177958_n() + posX, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + posZ, 0.0, 0.0, 0.0, new int[0]);
            }
            if (tileEntityGrill.leftCooked && tileEntityGrill.getItem(0) != null && RecipeAPI.getGrillRecipeFromInput(tileEntityGrill.getItem(0)) != null) {
                int meta = this.func_176201_c(state);
                float[] leftFixed = ParticleHelper.fixRotation(meta, 0.5f, 0.25f);
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)pos.func_177958_n() + leftFixed[0]), (double)pos.func_177956_o() + 1.0, (double)((float)pos.func_177952_p() + leftFixed[1]), 0.0, 0.0, 0.0, new int[0]);
            }
            if (tileEntityGrill.rightCooked && tileEntityGrill.getItem(1) != null && RecipeAPI.getGrillRecipeFromInput(tileEntityGrill.getItem(1)) != null) {
                int meta = this.func_176201_c(state);
                float[] rightFixed = ParticleHelper.fixRotation(meta, 0.5f, 0.75f);
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)pos.func_177958_n() + rightFixed[0]), (double)pos.func_177956_o() + 1.0, (double)((float)pos.func_177952_p() + rightFixed[1]), 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        if (!worldIn.field_72995_K && (tileEntity = worldIn.func_175625_s(pos)) instanceof TileEntityGrill) {
            TileEntityGrill tileEntityGrill = (TileEntityGrill)tileEntity;
            if (heldItem != null) {
                if (heldItem.func_77973_b() == Items.field_151044_h && heldItem.func_77952_i() == 1) {
                    if (tileEntityGrill.addCoal()) {
                        --heldItem.field_77994_a;
                    }
                } else if (heldItem.func_77973_b() == Items.field_151033_d) {
                    tileEntityGrill.startFire();
                } else if (heldItem.func_77973_b() == FurnitureItems.itemSpatula && side == EnumFacing.UP) {
                    EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
                    tileEntityGrill.flipFood(this.getClickedSide(facing, hitX, hitZ));
                } else if (heldItem.func_77973_b() instanceof ItemFood && side == EnumFacing.UP) {
                    EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
                    if (tileEntityGrill.addFood(this.getClickedSide(facing, hitX, hitZ), heldItem)) {
                        --heldItem.field_77994_a;
                    }
                } else {
                    EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
                    tileEntityGrill.removeFood(this.getClickedSide(facing, hitX, hitZ));
                }
            } else {
                EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
                tileEntityGrill.removeFood(this.getClickedSide(facing, hitX, hitZ));
            }
        }
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityGrill();
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public ClickedSide getClickedSide(EnumFacing facing, float hitX, float hitZ) {
        switch (facing) {
            case NORTH: {
                if ((double)hitX <= 0.5) {
                    return ClickedSide.LEFT;
                }
                return ClickedSide.RIGHT;
            }
            case EAST: {
                if ((double)hitZ <= 0.5) {
                    return ClickedSide.LEFT;
                }
                return ClickedSide.RIGHT;
            }
            case SOUTH: {
                if ((double)hitX <= 0.5) {
                    return ClickedSide.RIGHT;
                }
                return ClickedSide.LEFT;
            }
            case WEST: {
                if ((double)hitZ <= 0.5) {
                    return ClickedSide.RIGHT;
                }
                return ClickedSide.LEFT;
            }
        }
        return ClickedSide.UNKNOWN;
    }

    public static enum ClickedSide {
        LEFT(0),
        RIGHT(1),
        UNKNOWN(2);

        public int id;

        private ClickedSide(int id) {
            this.id = id;
        }
    }
}

