/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.mrcrayfish.furniture.blocks.BlockFurniture;
import com.mrcrayfish.furniture.init.FurnitureAchievements;
import com.mrcrayfish.furniture.util.CollisionHelper;
import java.util.List;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockTap
extends BlockFurniture {
    private static final AxisAlignedBB BOUNDING_BOX_NORTH = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.125, 0.0, 0.4, 0.5625, 1.0, 0.6);
    private static final AxisAlignedBB BOUNDING_BOX_EAST = CollisionHelper.getBlockBounds(EnumFacing.EAST, 0.125, 0.0, 0.4, 0.5625, 1.0, 0.6);
    private static final AxisAlignedBB BOUNDING_BOX_SOUTH = CollisionHelper.getBlockBounds(EnumFacing.SOUTH, 0.125, 0.0, 0.4, 0.5625, 1.0, 0.6);
    private static final AxisAlignedBB BOUNDING_BOX_WEST = CollisionHelper.getBlockBounds(EnumFacing.WEST, 0.125, 0.0, 0.4, 0.5625, 1.0, 0.6);
    private static final AxisAlignedBB[] BOUNDING_BOX = new AxisAlignedBB[]{BOUNDING_BOX_SOUTH, BOUNDING_BOX_WEST, BOUNDING_BOX_NORTH, BOUNDING_BOX_EAST};

    public BlockTap(Material material) {
        super(material);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        ((EntityPlayer)placer).func_71029_a((StatBase)FurnitureAchievements.gardening);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (this.hasWaterSource(worldIn, pos)) {
                if (worldIn.func_175623_d(pos.func_177972_a(facing.func_176734_d()))) {
                    worldIn.func_175656_a(pos.func_177972_a(facing.func_176734_d()), Blocks.field_150355_j.func_176223_P());
                    worldIn.func_175698_g(pos.func_177979_c(2));
                    playerIn.func_71029_a((StatBase)FurnitureAchievements.tapped);
                } else {
                    playerIn.func_146105_b((ITextComponent)new TextComponentString("Something is blocking the tap."));
                }
            } else {
                playerIn.func_146105_b((ITextComponent)new TextComponentString("You need to have a water source under the block the tap is on to use it."));
            }
        }
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return BOUNDING_BOX[facing.func_176736_b()];
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB axisAligned, List<AxisAlignedBB> axisAlignedList, Entity collidingEntity) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        BlockFurniture.func_185492_a((BlockPos)pos, (AxisAlignedBB)axisAligned, axisAlignedList, (AxisAlignedBB)BOUNDING_BOX[facing.func_176736_b()]);
    }

    public boolean hasWaterSource(World world, BlockPos pos) {
        if (world.func_180495_p(pos.func_177979_c(2)).func_177230_c() == Blocks.field_150355_j) {
            if ((Integer)world.func_180495_p(pos.func_177979_c(2)).func_177229_b((IProperty)BlockStaticLiquid.field_176367_b) == 0) {
                return true;
            }
        }
        return false;
    }
}

