/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public interface IPerspectiveAwareModel
extends byl {
    public Pair<? extends byl, Matrix4f> handlePerspective(bpl.b var1);

    public static class MapWrapper
    implements IPerspectiveAwareModel {
        private final byl parent;
        private final ImmutableMap<bpl.b, TRSRTransformation> transforms;

        public MapWrapper(byl parent, ImmutableMap<bpl.b, TRSRTransformation> transforms) {
            this.parent = parent;
            this.transforms = transforms;
        }

        public MapWrapper(byl parent, IModelState state) {
            this(parent, MapWrapper.getTransforms(state));
        }

        public static ImmutableMap<bpl.b, TRSRTransformation> getTransforms(IModelState state) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (bpl.b type : bpl.b.values()) {
                Optional<TRSRTransformation> tr = state.apply((Optional<? extends IModelPart>)Optional.of((Object)type));
                if (!tr.isPresent()) continue;
                builder.put((Object)type, tr.get());
            }
            return builder.build();
        }

        public static ImmutableMap<bpl.b, TRSRTransformation> getTransforms(bpl transforms) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (bpl.b type : bpl.b.values()) {
                builder.put((Object)type, (Object)TRSRTransformation.blockCenterToCorner(new TRSRTransformation(transforms.b(type))));
            }
            return builder.build();
        }

        public static Pair<? extends byl, Matrix4f> handlePerspective(byl model, ImmutableMap<bpl.b, TRSRTransformation> transforms, bpl.b cameraTransformType) {
            TRSRTransformation tr = (TRSRTransformation)transforms.get((Object)cameraTransformType);
            Matrix4f mat = null;
            if (tr != null && !tr.equals(TRSRTransformation.identity())) {
                mat = TRSRTransformation.blockCornerToCenter(tr).getMatrix();
            }
            return Pair.of((Object)model, mat);
        }

        public static Pair<? extends byl, Matrix4f> handlePerspective(byl model, IModelState state, bpl.b cameraTransformType) {
            TRSRTransformation tr = (TRSRTransformation)state.apply((Optional<? extends IModelPart>)Optional.of((Object)cameraTransformType)).or((Object)TRSRTransformation.identity());
            if (tr != TRSRTransformation.identity()) {
                return Pair.of((Object)model, (Object)TRSRTransformation.blockCornerToCenter(tr).getMatrix());
            }
            return Pair.of((Object)model, null);
        }

        public boolean a() {
            return this.parent.a();
        }

        public boolean b() {
            return this.parent.b();
        }

        public boolean c() {
            return this.parent.c();
        }

        public bwe d() {
            return this.parent.d();
        }

        public bpl e() {
            return this.parent.e();
        }

        public List<boy> a(ars state, ct side, long rand) {
            return this.parent.a(state, side, rand);
        }

        public bpj f() {
            return this.parent.f();
        }

        @Override
        public Pair<? extends byl, Matrix4f> handlePerspective(bpl.b cameraTransformType) {
            return MapWrapper.handlePerspective((byl)this, this.transforms, cameraTransformType);
        }
    }
}

