/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.obj;

import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public enum OBJLoader implements ICustomModelLoader
{
    INSTANCE;

    private bxd manager;
    private final Set<String> enabledDomains = new HashSet<String>();
    private final Map<kn, OBJModel> cache = new HashMap<kn, OBJModel>();
    private final Map<kn, Exception> errors = new HashMap<kn, Exception>();

    public void addDomain(String domain) {
        this.enabledDomains.add(domain.toLowerCase());
        FMLLog.log(Level.INFO, "OBJLoader: Domain %s has been added.", domain.toLowerCase());
    }

    public void a(bxd resourceManager) {
        this.manager = resourceManager;
        this.cache.clear();
        this.errors.clear();
    }

    @Override
    public boolean accepts(kn modelLocation) {
        return this.enabledDomains.contains(modelLocation.b()) && modelLocation.a().endsWith(".obj");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IModel loadModel(kn modelLocation) throws Exception {
        OBJModel model;
        kn file = new kn(modelLocation.b(), modelLocation.a());
        if (!this.cache.containsKey(file)) {
            bxc resource = null;
            try {
                resource = this.manager.a(file);
            }
            catch (FileNotFoundException e) {
                if (modelLocation.a().startsWith("models/block/")) {
                    resource = this.manager.a(new kn(file.b(), "models/item/" + file.a().substring("models/block/".length())));
                }
                if (modelLocation.a().startsWith("models/item/")) {
                    resource = this.manager.a(new kn(file.b(), "models/block/" + file.a().substring("models/item/".length())));
                }
                throw e;
            }
            OBJModel.Parser parser = new OBJModel.Parser(resource, this.manager);
            OBJModel model2 = null;
            try {
                model2 = parser.parse();
            }
            catch (Exception e) {
                this.errors.put(modelLocation, e);
            }
            finally {
                this.cache.put(modelLocation, model2);
            }
        }
        if ((model = this.cache.get(file)) == null) {
            throw new ModelLoaderRegistry.LoaderException("Error loading model previously: " + file, this.errors.get(modelLocation));
        }
        return model;
    }
}

