/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.items;

import com.google.common.base.Objects;
import java.lang.ref.WeakReference;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class VanillaDoubleChestItemHandler
extends WeakReference<aqm>
implements IItemHandlerModifiable {
    public static final VanillaDoubleChestItemHandler NO_ADJACENT_CHESTS_INSTANCE = new VanillaDoubleChestItemHandler(null, null, false);
    private final boolean mainChestIsUpper;
    private final aqm mainChest;
    private final int hashCode;

    public VanillaDoubleChestItemHandler(aqm mainChest, aqm other, boolean mainChestIsUpper) {
        super(other);
        this.mainChest = mainChest;
        this.mainChestIsUpper = mainChestIsUpper;
        this.hashCode = Objects.hashCode((Object[])new Object[]{mainChestIsUpper ? mainChest : other}) * 31 + Objects.hashCode((Object[])new Object[]{!mainChestIsUpper ? mainChest : other});
    }

    public static VanillaDoubleChestItemHandler get(aqm chest) {
        aid world = chest.D();
        cm pos = chest.v();
        if (world == null || pos == null || !world.e(pos)) {
            return null;
        }
        akf blockType = chest.w();
        ct[] horizontals = ct.o;
        for (int i = horizontals.length - 1; i >= 0; --i) {
            aqk otherTE;
            ct enumfacing = horizontals[i];
            cm blockpos = pos.a(enumfacing);
            akf block = world.o(blockpos).t();
            if (block != blockType || !((otherTE = world.r(blockpos)) instanceof aqm)) continue;
            aqm otherChest = (aqm)otherTE;
            return new VanillaDoubleChestItemHandler(chest, otherChest, enumfacing != ct.e && enumfacing != ct.c);
        }
        return NO_ADJACENT_CHESTS_INSTANCE;
    }

    public aqm getChest(boolean accessingUpper) {
        if (accessingUpper == this.mainChestIsUpper) {
            return this.mainChest;
        }
        return this.getOtherChest();
    }

    private aqm getOtherChest() {
        aqm tileEntityChest = (aqm)this.get();
        return tileEntityChest != null && !tileEntityChest.x() ? tileEntityChest : null;
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public adz getStackInSlot(int slot) {
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        aqm chest = this.getChest(accessingUpperChest);
        return chest != null ? chest.a(targetSlot) : null;
    }

    @Override
    public void setStackInSlot(int slot, adz stack) {
        IItemHandler singleHandler;
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        aqm chest = this.getChest(accessingUpperChest);
        if (chest != null && (singleHandler = chest.getSingleChestHandler()) instanceof IItemHandlerModifiable) {
            ((IItemHandlerModifiable)singleHandler).setStackInSlot(targetSlot, stack);
        }
    }

    @Override
    public adz insertItem(int slot, adz stack, boolean simulate) {
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        aqm chest = this.getChest(accessingUpperChest);
        return chest != null ? chest.getSingleChestHandler().insertItem(targetSlot, stack, simulate) : stack;
    }

    @Override
    public adz extractItem(int slot, int amount, boolean simulate) {
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        aqm chest = this.getChest(accessingUpperChest);
        return chest != null ? chest.getSingleChestHandler().extractItem(targetSlot, amount, simulate) : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VanillaDoubleChestItemHandler that = (VanillaDoubleChestItemHandler)o;
        if (this.hashCode != that.hashCode) {
            return false;
        }
        aqm otherChest = this.getOtherChest();
        if (this.mainChestIsUpper == that.mainChestIsUpper) {
            return Objects.equal((Object)this.mainChest, (Object)that.mainChest) && Objects.equal((Object)otherChest, (Object)that.getOtherChest());
        }
        return Objects.equal((Object)this.mainChest, (Object)that.getOtherChest()) && Objects.equal((Object)otherChest, (Object)that.mainChest);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean needsRefresh() {
        if (this == NO_ADJACENT_CHESTS_INSTANCE) {
            return false;
        }
        aqm tileEntityChest = (aqm)this.get();
        return tileEntityChest == null || tileEntityChest.x();
    }
}

