/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.parser.variables;

import cofh.cofhworld.CoFHWorld;
import cofh.cofhworld.data.biome.BiomeInfo;
import cofh.cofhworld.data.biome.BiomeInfoRarity;
import cofh.cofhworld.data.biome.BiomeInfoSet;
import cofh.shade.com.typesafe.config.Config;
import cofh.shade.com.typesafe.config.ConfigList;
import cofh.shade.com.typesafe.config.ConfigObject;
import cofh.shade.com.typesafe.config.ConfigValue;
import cofh.shade.com.typesafe.config.ConfigValueType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeData {
    public static BiomeInfoSet parseBiomeRestrictions(Config biomeEntry) {
        BiomeInfoSet set;
        ConfigValue data = biomeEntry.getValue("value");
        if (data.valueType() == ConfigValueType.LIST) {
            ConfigList restrictionList = (ConfigList)data;
            set = new BiomeInfoSet(restrictionList.size());
            int e = restrictionList.size();
            for (int i = 0; i < e; ++i) {
                BiomeInfo info = BiomeData.parseBiomeEntry((ConfigValue)restrictionList.get(i));
                if (info == null) continue;
                set.add(info);
            }
        } else {
            set = new BiomeInfoSet(1);
            BiomeInfo info = BiomeData.parseBiomeEntry(data);
            if (info != null) {
                set.add(info);
            }
        }
        return set;
    }

    public static BiomeInfo parseBiomeEntry(ConfigValue biomeEntry) {
        BiomeInfo info = null;
        switch (biomeEntry.valueType()) {
            case NULL: {
                CoFHWorld.log.debug("Null biome entry. Ignoring.");
                break;
            }
            case OBJECT: {
                int t;
                Object data;
                int rarity;
                Config obj = ((ConfigObject)biomeEntry).toConfig();
                String type = obj.getString("type");
                boolean wl = !obj.hasPath("whitelist") || obj.getBoolean("whitelist");
                ConfigValue value = obj.getValue("entry");
                List<String> array = value.valueType() == ConfigValueType.LIST ? obj.getStringList("entry") : null;
                String entry = array != null ? null : (String)value.unwrapped();
                int n = rarity = obj.hasPath("rarity") ? obj.getInt("rarity") : -1;
                if (type.equalsIgnoreCase("name")) {
                    if (array != null) {
                        List<String> names = array;
                        if (rarity > 0) {
                            info = new BiomeInfoRarity(names, 4, true, rarity);
                            break;
                        }
                        info = new BiomeInfo(names, 4, true);
                        break;
                    }
                    if (rarity > 0) {
                        info = new BiomeInfoRarity(entry, rarity);
                        break;
                    }
                    info = new BiomeInfo(entry);
                    break;
                }
                if (type.equalsIgnoreCase("dictionary")) {
                    if (array != null) {
                        ArrayList<BiomeDictionary.Type> tags = new ArrayList<BiomeDictionary.Type>(array.size());
                        int j = array.size();
                        for (int k = 0; k < j; ++k) {
                            tags.add(BiomeDictionary.Type.getType((String)array.get(k), (BiomeDictionary.Type[])new BiomeDictionary.Type[0]));
                        }
                        data = tags.toArray(new BiomeDictionary.Type[tags.size()]);
                        t = 6;
                    } else {
                        data = BiomeDictionary.Type.getType((String)entry, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
                        t = 2;
                    }
                } else if (type.equalsIgnoreCase("id")) {
                    if (array != null) {
                        ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>(array.size());
                        int j = array.size();
                        for (int k = 0; k < j; ++k) {
                            ids.add(new ResourceLocation(array.get(k)));
                        }
                        data = ids;
                        t = 8;
                    } else {
                        data = new ResourceLocation(entry);
                        t = 7;
                    }
                } else if (type.equalsIgnoreCase("temperature")) {
                    if (array != null) {
                        ArrayList<Biome.TempCategory> temps = new ArrayList<Biome.TempCategory>(array.size());
                        int j = array.size();
                        for (int k = 0; k < j; ++k) {
                            temps.add(Biome.TempCategory.valueOf((String)array.get(k)));
                        }
                        data = EnumSet.copyOf(temps);
                        t = 5;
                    } else {
                        data = Biome.TempCategory.valueOf((String)entry);
                        t = 1;
                    }
                } else {
                    CoFHWorld.log.warn("Biome entry of unknown type");
                    break;
                }
                if (data == null) break;
                if (rarity > 0) {
                    info = new BiomeInfoRarity(data, t, wl, rarity);
                    break;
                }
                info = new BiomeInfo(data, t, wl);
                break;
            }
            case STRING: {
                info = new BiomeInfo((String)biomeEntry.unwrapped());
                break;
            }
            default: {
                CoFHWorld.log.error("Unknown biome type in at line {}", (Object)biomeEntry.origin().lineNumber());
            }
        }
        return info;
    }
}

