/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.recipes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.recipe.IIngredientType;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.collect.ListMultiMap;
import mezz.jei.collect.Table;
import mezz.jei.ingredients.IngredientInformation;
import mezz.jei.recipes.RecipeCategoryComparator;

public class RecipeMap {
    private final Table<IRecipeCategory, String, List<IRecipeWrapper>> recipeWrapperTable = Table.hashBasedTable();
    private final ListMultiMap<String, String> categoryUidMap = new ListMultiMap();
    private final Ordering<String> recipeCategoryOrdering;
    private final IIngredientRegistry ingredientRegistry;

    public RecipeMap(RecipeCategoryComparator recipeCategoryComparator, IIngredientRegistry ingredientRegistry) {
        this.recipeCategoryOrdering = Ordering.from((Comparator)recipeCategoryComparator);
        this.ingredientRegistry = ingredientRegistry;
    }

    public <V> List<String> getRecipeCategories(V ingredient) {
        IIngredientHelper<V> ingredientHelper = this.ingredientRegistry.getIngredientHelper(ingredient);
        HashSet recipeCategories = new HashSet();
        for (String key : IngredientInformation.getUniqueIdsWithWildcard(ingredientHelper, ingredient)) {
            recipeCategories.addAll(this.categoryUidMap.get(key));
        }
        return this.recipeCategoryOrdering.immutableSortedCopy(recipeCategories);
    }

    public <V> void addRecipeCategory(IRecipeCategory recipeCategory, V ingredient, IIngredientHelper<V> ingredientHelper) {
        String recipeCategoryUid;
        String key = ingredientHelper.getUniqueId(ingredient);
        List recipeCategories = (List)this.categoryUidMap.get(key);
        if (!recipeCategories.contains(recipeCategoryUid = recipeCategory.getUid())) {
            recipeCategories.add(recipeCategoryUid);
        }
    }

    public <T extends IRecipeWrapper, V> ImmutableList<T> getRecipeWrappers(IRecipeCategory<T> recipeCategory, V ingredient) {
        IIngredientHelper<V> ingredientHelper = this.ingredientRegistry.getIngredientHelper(ingredient);
        Map<String, List<IRecipeWrapper>> recipesForType = this.recipeWrapperTable.getRow(recipeCategory);
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (String key : IngredientInformation.getUniqueIdsWithWildcard(ingredientHelper, ingredient)) {
            List<IRecipeWrapper> recipes = recipesForType.get(key);
            if (recipes == null) continue;
            listBuilder.addAll(recipes);
        }
        return listBuilder.build();
    }

    public <T extends IRecipeWrapper> void addRecipe(T recipeWrapper, IRecipeCategory<T> recipeCategory, Map<IIngredientType, List> ingredientsByType) {
        for (Map.Entry<IIngredientType, List> entry : ingredientsByType.entrySet()) {
            if (entry == null) continue;
            this.addRecipe(recipeWrapper, recipeCategory, entry.getKey(), entry.getValue());
        }
    }

    private <T extends IRecipeWrapper, V> void addRecipe(T recipeWrapper, IRecipeCategory<T> recipeCategory, IIngredientType<V> ingredientType, List<V> ingredients) {
        IIngredientHelper<V> ingredientHelper = this.ingredientRegistry.getIngredientHelper(ingredientType);
        Map<String, List<IRecipeWrapper>> recipesWrappersForType = this.recipeWrapperTable.getRow(recipeCategory);
        HashSet<String> uniqueIds = new HashSet<String>();
        List<V> expandedIngredients = ingredientHelper.expandSubtypes(ingredients);
        for (V ingredient : expandedIngredients) {
            String key;
            if (ingredient == null || uniqueIds.contains(key = ingredientHelper.getUniqueId(ingredient))) continue;
            uniqueIds.add(key);
            List recipeWrappers = recipesWrappersForType.computeIfAbsent(key, k -> new ArrayList());
            recipeWrappers.add(recipeWrapper);
            this.addRecipeCategory(recipeCategory, ingredient, ingredientHelper);
        }
    }
}

