/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.client.gui.hud;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.hud.HudElementBase;
import flaxbeard.cyberware.api.hud.IHudElement;
import flaxbeard.cyberware.api.hud.INotification;
import flaxbeard.cyberware.api.hud.NotificationInstance;
import flaxbeard.cyberware.client.ClientUtils;
import flaxbeard.cyberware.common.ArmorClass;
import flaxbeard.cyberware.common.block.tile.TileEntityBeacon;
import flaxbeard.cyberware.common.handler.HudHandler;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NotificationDisplay
extends HudElementBase {
    private static int cache_tickExisted = -1;
    private static int cache_tierRadio = -1;
    private static boolean cache_isWearingLightArmor = false;
    private static final NotificationInstance[] examples = new NotificationInstance[]{new NotificationInstance(0.0f, new NotificationArmor(true)), new NotificationInstance(0.0f, new NotificationArmor(false)), new NotificationInstance(0.0f, new NotificationArmor(true)), new NotificationInstance(0.0f, new NotificationArmor(false))};

    public NotificationDisplay() {
        super("cyberware:notification");
        this.setDefaultX(5);
        this.setDefaultY(-15);
        this.setWidth(90);
        this.setHeight(38);
        this.setDefaultVerticalAnchor(IHudElement.EnumAnchorVertical.BOTTOM);
    }

    @Override
    public void renderElement(int x, int y, EntityPlayer entityPlayer, ScaledResolution resolution, boolean isHUDjackAvailable, boolean isConfigOpen, float partialTicks) {
        if (this.isHidden() || !isHUDjackAvailable) {
            return;
        }
        boolean isTopAnchored = this.getVerticalAnchor() == IHudElement.EnumAnchorVertical.TOP;
        boolean isRightAnchored = this.getHorizontalAnchor() == IHudElement.EnumAnchorHorizontal.RIGHT;
        float currTime = (float)entityPlayer.field_70173_aa + partialTicks;
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(HudHandler.HUD_TEXTURE);
        if (entityPlayer.field_70173_aa != cache_tickExisted) {
            cache_tickExisted = entityPlayer.field_70173_aa;
            boolean wasWearingLightArmor = cache_isWearingLightArmor;
            cache_isWearingLightArmor = ArmorClass.isWearingLightOrNone((EntityLivingBase)entityPlayer);
            if (cache_isWearingLightArmor != wasWearingLightArmor) {
                HudHandler.addNotification(new NotificationInstance(currTime, new NotificationArmor(cache_isWearingLightArmor)));
            }
            int tierRadioPrevious = cache_tierRadio;
            cache_tierRadio = TileEntityBeacon.isInRange(entityPlayer.field_70170_p, entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v);
            if (cache_tierRadio != tierRadioPrevious) {
                HudHandler.addNotification(new NotificationInstance(currTime, new NotificationRadio(cache_tierRadio)));
            }
        }
        if (isConfigOpen) {
            for (int indexNotification = 0; indexNotification < examples.length; ++indexNotification) {
                NotificationInstance notificationInstance = examples[indexNotification];
                INotification notification = notificationInstance.getNotification();
                double percentVisible = 0.0;
                if (indexNotification == 0) {
                    percentVisible = (float)entityPlayer.field_70173_aa % 40.0f / 40.0f;
                }
                float yOffset = (float)(20.0 * Math.sin(percentVisible * Math.PI / 2.0));
                GlStateManager.func_179094_E();
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)(isTopAnchored ? -yOffset : yOffset), (float)0.0f);
                int index = examples.length - 1 - indexNotification;
                int xPos = isRightAnchored ? x + this.getWidth() - (index + 1) * 18 : x + index * 18;
                notification.render(xPos, y + (isTopAnchored ? 20 : 0));
                GlStateManager.func_179121_F();
            }
        } else {
            ArrayList<NotificationInstance> notificationsElapsed = new ArrayList<NotificationInstance>();
            for (int indexNotification = 0; indexNotification < HudHandler.notifications.size(); ++indexNotification) {
                NotificationInstance notificationInstance = (NotificationInstance)HudHandler.notifications.get(indexNotification);
                INotification notification = notificationInstance.getNotification();
                if (currTime - notificationInstance.getCreatedTime() < (float)(notification.getDuration() + 25)) {
                    double percentVisible = Math.max(0.0f, (currTime - notificationInstance.getCreatedTime() - (float)notification.getDuration()) / 30.0f);
                    float yOffset = (float)(20.0 * Math.sin(percentVisible * Math.PI / 2.0));
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179109_b((float)0.0f, (float)(isTopAnchored ? -yOffset : yOffset), (float)0.0f);
                    int index = HudHandler.notifications.size() - 1 - indexNotification;
                    int xPos = isRightAnchored ? x + this.getWidth() - (index + 1) * 18 : x + index * 18;
                    notification.render(xPos, y + (isTopAnchored ? 20 : 0));
                    GlStateManager.func_179121_F();
                    continue;
                }
                notificationsElapsed.add(notificationInstance);
            }
            for (NotificationInstance notificationInstance : notificationsElapsed) {
                HudHandler.notifications.remove(notificationInstance);
            }
        }
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    private static class NotificationRadio
    implements INotification {
        private int tier;

        private NotificationRadio(int tier) {
            this.tier = tier;
        }

        @Override
        public void render(int x, int y) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(HudHandler.HUD_TEXTURE);
            if (this.tier > 0) {
                GlStateManager.func_179094_E();
                float[] color = CyberwareAPI.getHUDColor();
                GlStateManager.func_179124_c((float)color[0], (float)color[1], (float)color[2]);
                ClientUtils.drawTexturedModalRect(x, y + 1, 13, 39, 15, 14);
                GlStateManager.func_179121_F();
                String textRadioTier = this.tier == 1 ? I18n.func_135052_a((String)"cyberware.gui.radio_internal", (Object[])new Object[0]) : Integer.toString(this.tier - 1);
                FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
                fontRenderer.func_175063_a(textRadioTier, (float)(x + 15 - fontRenderer.func_78256_a(textRadioTier)), (float)(y + 9), 0xFFFFFF);
            } else {
                float[] color = CyberwareAPI.getHUDColor();
                GlStateManager.func_179124_c((float)color[0], (float)color[1], (float)color[2]);
                ClientUtils.drawTexturedModalRect(x, y + 1, 28, 39, 15, 14);
            }
        }

        @Override
        public int getDuration() {
            return 40;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class NotificationArmor
    implements INotification {
        private boolean light;

        private NotificationArmor(boolean light) {
            this.light = light;
        }

        @Override
        public void render(int x, int y) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(HudHandler.HUD_TEXTURE);
            GlStateManager.func_179094_E();
            float[] color = CyberwareAPI.getHUDColor();
            GlStateManager.func_179124_c((float)color[0], (float)color[1], (float)color[2]);
            ClientUtils.drawTexturedModalRect(x, y + 1, 0, 25, 15, 14);
            GlStateManager.func_179121_F();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            if (this.light) {
                ClientUtils.drawTexturedModalRect(x + 9, y + 1 + 7, 15, 25, 7, 9);
            } else {
                ClientUtils.drawTexturedModalRect(x + 8, y + 1 + 7, 22, 25, 8, 9);
            }
        }

        @Override
        public int getDuration() {
            return 20;
        }
    }
}

