/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.block.tile;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.EnableDisableHelper;
import flaxbeard.cyberware.common.CyberwareContent;
import flaxbeard.cyberware.common.block.BlockBeaconLarge;
import flaxbeard.cyberware.common.item.ItemBrainUpgrade;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityBeacon
extends TileEntity
implements ITickable {
    private static List<Integer> tiers = new CopyOnWriteArrayList<Integer>();
    private static Map<Integer, Map<Integer, Map<BlockPos, Integer>>> mapBeaconPositionByTierDimension = new HashMap<Integer, Map<Integer, Map<BlockPos, Integer>>>();
    private boolean wasWorking = false;
    private int count = 0;
    private static int TIER = 2;

    private static Map<Integer, Map<BlockPos, Integer>> getBeaconPositionsForTier(int tier) {
        Map<Integer, Map<BlockPos, Integer>> mapBeaconPositionByDimension = mapBeaconPositionByTierDimension.get(tier);
        if (mapBeaconPositionByDimension == null) {
            mapBeaconPositionByDimension = new HashMap<Integer, Map<BlockPos, Integer>>();
            mapBeaconPositionByTierDimension.put(tier, mapBeaconPositionByDimension);
            if (!tiers.contains(tier)) {
                tiers.add(tier);
                Collections.sort(tiers);
                Collections.reverse(tiers);
            }
        }
        return mapBeaconPositionByDimension;
    }

    public static Map<BlockPos, Integer> getBeaconPositionsForTierAndDimension(int tier, @Nonnull World world) {
        Map<Integer, Map<BlockPos, Integer>> mapBeaconPositionByDimension = TileEntityBeacon.getBeaconPositionsForTier(tier);
        int idDimension = world.field_73011_w.getDimension();
        return mapBeaconPositionByDimension.computeIfAbsent(idDimension, k -> new HashMap());
    }

    public void func_73660_a() {
        boolean working;
        boolean bl = working = !this.field_145850_b.func_175640_z(this.field_174879_c);
        if (!this.wasWorking && working) {
            this.enable();
        }
        if (this.wasWorking && !working) {
            this.disable();
        }
        this.wasWorking = working;
        if (this.field_145850_b.field_72995_K && working) {
            IBlockState state;
            this.count = (this.count + 1) % 20;
            if (this.count == 0 && (state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() == CyberwareContent.radio) {
                boolean ns = state.func_177229_b((IProperty)BlockBeaconLarge.FACING) == EnumFacing.NORTH || state.func_177229_b((IProperty)BlockBeaconLarge.FACING) == EnumFacing.SOUTH;
                boolean backwards = state.func_177229_b((IProperty)BlockBeaconLarge.FACING) == EnumFacing.SOUTH || state.func_177229_b((IProperty)BlockBeaconLarge.FACING) == EnumFacing.EAST;
                float dist = 0.2f;
                float speedMod = 0.08f;
                int degrees = 45;
                for (int index = 0; index < 5; ++index) {
                    float sin = (float)Math.sin(Math.toRadians(degrees));
                    float cos = (float)Math.cos(Math.toRadians(degrees));
                    float xOffset = dist * sin;
                    float yOffset = 0.2f + dist * cos;
                    float xSpeed = speedMod * sin;
                    float ySpeed = speedMod * cos;
                    float backOffsetX = backwards ^ ns ? -0.3f : 0.3f;
                    float backOffsetZ = backwards ? 0.4f : -0.4f;
                    this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)this.field_174879_c.func_177958_n() + 0.5f + (ns ? xOffset + backOffsetX : backOffsetZ)), (double)((float)this.field_174879_c.func_177956_o() + 0.5f + yOffset), (double)((float)this.field_174879_c.func_177952_p() + 0.5f + (ns ? backOffsetZ : xOffset + backOffsetX)), ns ? (double)xSpeed : 0.0, (double)ySpeed, ns ? 0.0 : (double)xSpeed, new int[]{255, 255, 255});
                    this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)this.field_174879_c.func_177958_n() + 0.5f + (ns ? -xOffset + backOffsetX : backOffsetZ)), (double)((float)this.field_174879_c.func_177956_o() + 0.5f + yOffset), (double)((float)this.field_174879_c.func_177952_p() + 0.5f + (ns ? backOffsetZ : -xOffset + backOffsetX)), ns ? (double)(-xSpeed) : 0.0, (double)ySpeed, ns ? 0.0 : (double)(-xSpeed), new int[]{255, 255, 255});
                    degrees += 18;
                }
            }
        }
    }

    private void disable() {
        Map<BlockPos, Integer> mapBeaconPosition = TileEntityBeacon.getBeaconPositionsForTierAndDimension(TIER, this.field_145850_b);
        mapBeaconPosition.remove(this.func_174877_v());
    }

    private void enable() {
        Map<BlockPos, Integer> mapBeaconPosition = TileEntityBeacon.getBeaconPositionsForTierAndDimension(TIER, this.field_145850_b);
        if (!mapBeaconPosition.containsKey(this.func_174877_v())) {
            mapBeaconPosition.put(this.func_174877_v(), 64);
        }
    }

    public void func_145843_s() {
        this.disable();
        super.func_145843_s();
    }

    public static int isInRange(World world, double posX, double posY, double posZ) {
        for (int tier : tiers) {
            Map<BlockPos, Integer> mapBeaconPosition = TileEntityBeacon.getBeaconPositionsForTierAndDimension(tier, world);
            for (Map.Entry<BlockPos, Integer> entry : mapBeaconPosition.entrySet()) {
                double squareDistance = (posX - (double)entry.getKey().func_177958_n()) * (posX - (double)entry.getKey().func_177958_n()) + (posZ - (double)entry.getKey().func_177952_p()) * (posZ - (double)entry.getKey().func_177952_p());
                if (!(squareDistance < (double)(entry.getValue() * entry.getValue()))) continue;
                return tier;
            }
        }
        List entitiesInRange = world.func_72872_a(EntityPlayer.class, new AxisAlignedBB(posX - 32.0, 0.0, posZ - 32.0, posX + 32.0, 255.0, posZ + 32.0));
        ItemStack itemStackRadioRaw = CyberwareContent.brainUpgrades.getCachedStack(5);
        for (EntityLivingBase entityInRange : entitiesInRange) {
            ItemStack itemStackRadio;
            ICyberwareUserData cyberwareUserData;
            if (!ItemBrainUpgrade.isRadioWorking(entityInRange) || (cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityInRange)) == null || (itemStackRadio = cyberwareUserData.getCyberware(itemStackRadioRaw)).func_190926_b() || !EnableDisableHelper.isEnabled(itemStackRadio)) continue;
            return 1;
        }
        return -1;
    }
}

