/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.block.tile;

import flaxbeard.cyberware.api.item.IBlueprint;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityBlueprintArchive
extends TileEntity {
    public ItemStackHandler slots = new ItemStackHandlerBlueprint(18);
    public String customName = null;

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.slots;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.slots.deserializeNBT(tagCompound.func_74775_l("inv"));
        if (tagCompound.func_74764_b("CustomName")) {
            this.customName = tagCompound.func_74779_i("CustomName");
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        tagCompound.func_74782_a("inv", (NBTBase)this.slots.serializeNBT());
        if (this.hasCustomName()) {
            tagCompound.func_74778_a("CustomName", this.customName);
        }
        return tagCompound;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound data = pkt.func_148857_g();
        this.func_145839_a(data);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound data = new NBTTagCompound();
        this.func_189515_b(data);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, data);
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public boolean isUsableByPlayer(EntityPlayer entityPlayer) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && entityPlayer.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public String getName() {
        return this.hasCustomName() ? this.customName : "cyberware.container.blueprint_archive";
    }

    public boolean hasCustomName() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomInventoryName(String name) {
        this.customName = name;
    }

    public ITextComponent func_145748_c_() {
        return this.hasCustomName() ? new TextComponentString(this.getName()) : new TextComponentTranslation(this.getName(), new Object[0]);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public class ItemStackHandlerBlueprint
    extends ItemStackHandler {
        public ItemStackHandlerBlueprint(int i) {
            super(i);
        }

        @Nonnull
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!this.isItemValidForSlot(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public boolean isItemValidForSlot(int slot, ItemStack stack) {
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof IBlueprint) {
                return true;
            }
            int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
            int paperId = OreDictionary.getOreID((String)"paper");
            for (int id : ids) {
                if (id != paperId) continue;
                return true;
            }
            return stack.func_190926_b();
        }
    }
}

