/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.item;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.CyberwareUpdateEvent;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.EnableDisableHelper;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.api.item.IHudjack;
import flaxbeard.cyberware.api.item.IMenuItem;
import flaxbeard.cyberware.common.CyberwareContent;
import flaxbeard.cyberware.common.item.ItemCyberware;
import flaxbeard.cyberware.common.misc.NNLUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCybereyeUpgrade
extends ItemCyberware
implements IMenuItem,
IHudjack {
    public static final int META_NIGHT_VISION = 0;
    public static final int META_UNDERWATER_VISION = 1;
    public static final int META_HUDJACK = 2;
    public static final int META_TARGETING = 3;
    public static final int META_ZOOM = 4;
    private static int cache_tickExisted = -1;
    private static boolean cache_isHighlighting = false;
    private static AxisAlignedBB cache_aabbHighlight = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static List<EntityLivingBase> entitiesInRange = new ArrayList<EntityLivingBase>(16);
    private static final float HIGHLIGHT_RANGE = 25.0f;
    private static boolean inUse = false;
    private static boolean wasInUse = false;
    private static int zoomSettingOn = 0;
    private static float fov = 0.0f;
    private static float sensitivity = 0.0f;
    private static EntityPlayer player = null;
    private static final float[] f = new float[]{1.0f, 0.0f, 0.0f};

    public ItemCybereyeUpgrade(String name, ICyberware.EnumSlot slot, String[] subnames) {
        super(name, slot, subnames);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public NonNullList<NonNullList<ItemStack>> required(ItemStack stack) {
        if (stack.func_77952_i() == 3) {
            return NNLUtil.fromArray(new ItemStack[][]{{CyberwareContent.cybereyes.getCachedStack(0)}, {this.getCachedStack(2)}});
        }
        return NNLUtil.fromArray(new ItemStack[][]{{CyberwareContent.cybereyes.getCachedStack(0)}});
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void handleHighlight(TickEvent.RenderTickEvent event) {
        EntityPlayerSP entityPlayer = Minecraft.func_71410_x().field_71439_g;
        if (entityPlayer == null) {
            return;
        }
        if (entityPlayer.field_70173_aa != cache_tickExisted) {
            cache_tickExisted = entityPlayer.field_70173_aa;
            ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityPlayer);
            if (cyberwareUserData == null) {
                return;
            }
            ItemStack itemStackTargeting = cyberwareUserData.getCyberware(this.getCachedStack(3));
            boolean bl = cache_isHighlighting = !itemStackTargeting.func_190926_b() && EnableDisableHelper.isEnabled(itemStackTargeting);
            if (cache_isHighlighting) {
                cache_aabbHighlight = new AxisAlignedBB(entityPlayer.field_70165_t - 25.0, entityPlayer.field_70163_u - 25.0, entityPlayer.field_70161_v - 25.0, entityPlayer.field_70165_t + (double)entityPlayer.field_70130_N + 25.0, entityPlayer.field_70163_u + (double)entityPlayer.field_70131_O + 25.0, entityPlayer.field_70161_v + (double)entityPlayer.field_70130_N + 25.0);
            }
        }
        if (cache_isHighlighting) {
            if (event.phase == TickEvent.Phase.START) {
                entitiesInRange.clear();
                List entityLivingBases = entityPlayer.field_70170_p.func_72872_a(EntityLivingBase.class, cache_aabbHighlight);
                double rangeSq = 625.0;
                for (EntityLivingBase entityLivingBase : entityLivingBases) {
                    if (!(entityPlayer.func_70068_e((Entity)entityLivingBase) <= rangeSq) || entityLivingBase == entityPlayer || entityLivingBase.func_184202_aL()) continue;
                    entityLivingBase.func_184195_f(true);
                    entitiesInRange.add(entityLivingBase);
                }
            } else if (event.phase == TickEvent.Phase.END) {
                for (EntityLivingBase entityLivingBase : entitiesInRange) {
                    entityLivingBase.func_184195_f(false);
                }
                entitiesInRange.clear();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void handleFog(EntityViewRenderEvent.FogDensity event) {
        EntityPlayerSP entityPlayer = Minecraft.func_71410_x().field_71439_g;
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityPlayer);
        if (cyberwareUserData == null) {
            return;
        }
        if (cyberwareUserData.isCyberwareInstalled(this.getCachedStack(1))) {
            if (entityPlayer.func_70055_a(Material.field_151586_h)) {
                event.setDensity(0.01f);
                event.setCanceled(true);
            } else if (entityPlayer.func_70055_a(Material.field_151587_i)) {
                event.setDensity(0.7f);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void handleNightVision(CyberwareUpdateEvent event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        ICyberwareUserData cyberwareUserData = event.getCyberwareUserData();
        ItemStack itemStackNightVision = cyberwareUserData.getCyberware(this.getCachedStack(0));
        if (!itemStackNightVision.func_190926_b() && EnableDisableHelper.isEnabled(itemStackNightVision)) {
            entityLivingBase.func_70690_d(new PotionEffect(MobEffects.field_76439_r, Integer.MAX_VALUE, 53, true, false));
        } else {
            PotionEffect effect = entityLivingBase.func_70660_b(MobEffects.field_76439_r);
            if (effect != null && effect.func_76458_c() == 53) {
                entityLivingBase.func_184589_d(MobEffects.field_76439_r);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void handleWaterVision(RenderBlockOverlayEvent event) {
        EntityPlayer entityPlayer = event.getPlayer();
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityPlayer);
        if (cyberwareUserData == null) {
            return;
        }
        ItemStack itemStackUnderwaterVision = cyberwareUserData.getCyberware(this.getCachedStack(1));
        if (!(itemStackUnderwaterVision.func_190926_b() || event.getBlockForOverlay().func_185904_a() != Material.field_151586_h && event.getBlockForOverlay().func_185904_a() != Material.field_151587_i)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void tickStart(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.START) {
            ICyberwareUserData cyberwareUserData;
            wasInUse = inUse;
            EntityPlayerSP entityPlayer = mc.field_71439_g;
            if (!inUse && !wasInUse) {
                fov = mc.field_71474_y.field_74334_X;
                sensitivity = mc.field_71474_y.field_74341_c;
            }
            if ((cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityPlayer)) != null && cyberwareUserData.isCyberwareInstalled(this.getCachedStack(4))) {
                player = entityPlayer;
                if (mc.field_71474_y.field_74320_O == 0) {
                    switch (zoomSettingOn) {
                        case 0: {
                            mc.field_71474_y.field_74334_X = fov;
                            mc.field_71474_y.field_74341_c = sensitivity;
                            break;
                        }
                        case 1: {
                            mc.field_71474_y.field_74334_X = fov;
                            mc.field_71474_y.field_74341_c = sensitivity;
                            for (int i = 0; Math.abs(mc.field_71474_y.field_74334_X - (fov + 5.0f) / 2.0f) > 2.5f && i < 200; ++i) {
                                mc.field_71474_y.field_74334_X -= 2.5f;
                                mc.field_71474_y.field_74341_c -= 0.01f;
                            }
                            break;
                        }
                        case 2: {
                            mc.field_71474_y.field_74334_X = fov;
                            mc.field_71474_y.field_74341_c = sensitivity;
                            for (int i = 0; Math.abs(mc.field_71474_y.field_74334_X - (fov + 5.0f) / 5.0f) > 2.5f && i < 200; ++i) {
                                mc.field_71474_y.field_74334_X -= 2.5f;
                                mc.field_71474_y.field_74341_c -= 0.01f;
                            }
                            break;
                        }
                        case 3: {
                            mc.field_71474_y.field_74334_X = fov;
                            mc.field_71474_y.field_74341_c = sensitivity;
                            for (int i = 0; Math.abs(mc.field_71474_y.field_74334_X - (fov + 5.0f) / 12.0f) > 2.5f && i < 200; ++i) {
                                mc.field_71474_y.field_74334_X -= 2.5f;
                                mc.field_71474_y.field_74341_c -= 0.01f;
                            }
                            break;
                        }
                    }
                }
            } else {
                zoomSettingOn = 0;
            }
            boolean bl = inUse = zoomSettingOn != 0;
            if (!inUse && wasInUse) {
                mc.field_71474_y.field_74334_X = fov;
                mc.field_71474_y.field_74341_c = sensitivity;
            }
        }
    }

    @Override
    public boolean hasMenu(ItemStack stack) {
        return stack.func_77952_i() == 0 || stack.func_77952_i() == 2 || stack.func_77952_i() == 3 || stack.func_77952_i() == 4;
    }

    @Override
    public void use(Entity entity, ItemStack stack) {
        if (stack.func_77952_i() == 4) {
            if (entity == player) {
                zoomSettingOn = entity.func_70093_af() ? (zoomSettingOn + 4 - 1) % 4 : (zoomSettingOn + 1) % 4;
            }
            return;
        }
        EnableDisableHelper.toggle(stack);
    }

    @Override
    public String getUnlocalizedLabel(ItemStack stack) {
        if (stack.func_77952_i() == 4) {
            return "cyberware.gui.active.zoom";
        }
        return EnableDisableHelper.getUnlocalizedLabel(stack);
    }

    @Override
    public float[] getColor(ItemStack stack) {
        if (stack.func_77952_i() == 4) {
            return null;
        }
        return (float[])(EnableDisableHelper.isEnabled(stack) ? f : null);
    }

    @Override
    public boolean isActive(ItemStack stack) {
        return stack.func_77952_i() == 2 && EnableDisableHelper.isEnabled(stack);
    }
}

