/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.item;

import flaxbeard.cyberware.Cyberware;
import flaxbeard.cyberware.common.CyberwareContent;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemCyberwareBase
extends Item {
    public String[] subnames;
    private ItemStack[] itemStackCache;

    public ItemCyberwareBase(String name, String ... subnames) {
        this.setRegistryName(name);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this);
        this.func_77655_b("cyberware." + name);
        this.func_77637_a(Cyberware.creativeTab);
        this.subnames = subnames;
        this.itemStackCache = new ItemStack[Math.max(subnames.length, 1)];
        this.func_77627_a(this.subnames.length > 0);
        this.func_77656_e(0);
        CyberwareContent.items.add(this);
    }

    @Nonnull
    public String func_77667_c(ItemStack itemstack) {
        int damage = itemstack.func_77952_i();
        if (damage >= this.subnames.length) {
            return super.func_77658_a();
        }
        return super.func_77667_c(itemstack) + "." + this.subnames[damage];
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            if (this.subnames.length == 0) {
                list.add((Object)new ItemStack((Item)this));
            }
            for (int metadata = 0; metadata < this.subnames.length; ++metadata) {
                list.add((Object)new ItemStack((Item)this, 1, metadata));
            }
        }
    }

    public ItemStack getCachedStack(int damage) {
        ItemStack itemStack = this.itemStackCache[damage];
        if (itemStack != null && (itemStack.func_77973_b() != this || itemStack.func_190916_E() != 1 || this.getDamage(itemStack) != damage)) {
            Cyberware.logger.error(String.format("Corrupted item stack cache: found %s as %s:%d, expected %s:%d", new Object[]{itemStack, itemStack.func_77973_b(), itemStack.func_77952_i(), this, damage}));
            itemStack = null;
        }
        if (itemStack == null) {
            this.itemStackCache[damage] = itemStack = new ItemStack((Item)this, 1, damage);
        }
        return itemStack;
    }
}

