/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.item;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.CyberwareUpdateEvent;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.common.CyberwareContent;
import flaxbeard.cyberware.common.item.ItemCyberware;
import flaxbeard.cyberware.common.network.CyberwarePacketHandler;
import flaxbeard.cyberware.common.network.ParticlePacket;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ItemHeartUpgrade
extends ItemCyberware {
    public static final int META_INTERNAL_DEFIBRILLATOR = 0;
    public static final int META_PLATELET_DISPATCHER = 1;
    public static final int META_STEM_CELL_SYNTHESIZER = 2;
    public static final int META_CARDIOVASCULAR_COUPLER = 3;
    private static final Map<UUID, Integer> timesPlatelets = new HashMap<UUID, Integer>();
    private static final Map<UUID, Boolean> isPlateletWorking = new HashMap<UUID, Boolean>();
    private static final Map<UUID, Boolean> isStemWorking = new HashMap<UUID, Boolean>();
    private static final Map<UUID, Integer> timesMedkit = new HashMap<UUID, Integer>();
    private static final Map<UUID, Float> damageMedkit = new HashMap<UUID, Float>();

    public ItemHeartUpgrade(String name, ICyberware.EnumSlot slot, String[] subnames) {
        super(name, slot, subnames);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isIncompatible(ItemStack stack, ItemStack other) {
        return other.func_77973_b() == CyberwareContent.cyberheart && (stack.func_77952_i() == 0 || stack.func_77952_i() == 3);
    }

    @SubscribeEvent
    public void handleDeath(LivingDeathEvent event) {
        if (event.isCanceled()) {
            return;
        }
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityLivingBase);
        if (cyberwareUserData == null) {
            return;
        }
        ItemStack itemStackInternalDefibrillator = cyberwareUserData.getCyberware(this.getCachedStack(0));
        if (!itemStackInternalDefibrillator.func_190926_b() && !CyberwareAPI.getCyberwareNBT(itemStackInternalDefibrillator).func_74764_b("used") && cyberwareUserData.usePower(itemStackInternalDefibrillator, this.getPowerConsumption(itemStackInternalDefibrillator), false)) {
            if (entityLivingBase instanceof EntityPlayer) {
                NonNullList<ItemStack> items = cyberwareUserData.getInstalledCyberware(ICyberware.EnumSlot.HEART);
                NonNullList itemsNew = NonNullList.func_191196_a();
                itemsNew.addAll(items);
                for (int index = 0; index < items.size(); ++index) {
                    ItemStack item = (ItemStack)items.get(index);
                    if (item.func_190926_b() || item.func_77973_b() != this || item.func_77952_i() != 0) continue;
                    itemsNew.set(index, (Object)ItemStack.field_190927_a);
                    break;
                }
                cyberwareUserData.setInstalledCyberware(entityLivingBase, ICyberware.EnumSlot.HEART, (NonNullList<ItemStack>)itemsNew);
                cyberwareUserData.updateCapacity();
                if (!entityLivingBase.field_70170_p.field_72995_K) {
                    CyberwareAPI.updateData((Entity)entityLivingBase);
                }
            } else {
                itemStackInternalDefibrillator = cyberwareUserData.getCyberware(itemStackInternalDefibrillator);
                NBTTagCompound tagCompoundCyberware = CyberwareAPI.getCyberwareNBT(itemStackInternalDefibrillator);
                tagCompoundCyberware.func_74757_a("used", true);
                CyberwareAPI.updateData((Entity)entityLivingBase);
            }
            entityLivingBase.func_70606_j(entityLivingBase.func_110138_aP() / 3.0f);
            CyberwarePacketHandler.INSTANCE.sendToAllAround((IMessage)new ParticlePacket(1, (float)entityLivingBase.field_70165_t, (float)entityLivingBase.field_70163_u + entityLivingBase.field_70131_O / 2.0f, (float)entityLivingBase.field_70161_v), new NetworkRegistry.TargetPoint(entityLivingBase.field_70170_p.field_73011_w.getDimension(), entityLivingBase.field_70165_t, entityLivingBase.field_70163_u, entityLivingBase.field_70161_v, 20.0));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void handleLivingUpdate(CyberwareUpdateEvent event) {
        int t;
        ItemStack itemStackCardiovascularCoupler;
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        ICyberwareUserData cyberwareUserData = event.getCyberwareUserData();
        if (entityLivingBase.field_70173_aa % 20 == 0 && !(itemStackCardiovascularCoupler = cyberwareUserData.getCyberware(this.getCachedStack(3))).func_190926_b()) {
            cyberwareUserData.addPower(this.getPowerProduction(itemStackCardiovascularCoupler), itemStackCardiovascularCoupler);
        }
        ItemStack itemStackStemCellSynthesizer = cyberwareUserData.getCyberware(this.getCachedStack(2));
        if (entityLivingBase.field_70173_aa % 20 == 0 && !itemStackStemCellSynthesizer.func_190926_b()) {
            isStemWorking.put(entityLivingBase.func_110124_au(), cyberwareUserData.usePower(itemStackStemCellSynthesizer, this.getPowerConsumption(itemStackStemCellSynthesizer)));
        }
        ItemStack itemStackPlateletDispatcher = cyberwareUserData.getCyberware(this.getCachedStack(1));
        if (entityLivingBase.field_70173_aa % 20 == 0 && !itemStackPlateletDispatcher.func_190926_b()) {
            isPlateletWorking.put(entityLivingBase.func_110124_au(), cyberwareUserData.usePower(itemStackPlateletDispatcher, this.getPowerConsumption(itemStackPlateletDispatcher)));
        }
        if (this.isPlateletWorking(entityLivingBase) && !itemStackPlateletDispatcher.func_190926_b()) {
            if (entityLivingBase.func_110143_aJ() >= entityLivingBase.func_110138_aP() * 0.8f && entityLivingBase.func_110143_aJ() != entityLivingBase.func_110138_aP()) {
                t = this.getPlateletTime(entityLivingBase);
                if (t >= 40) {
                    timesPlatelets.put(entityLivingBase.func_110124_au(), entityLivingBase.field_70173_aa);
                    entityLivingBase.func_70691_i(1.0f);
                }
            } else {
                timesPlatelets.put(entityLivingBase.func_110124_au(), entityLivingBase.field_70173_aa);
            }
        } else {
            timesPlatelets.remove(entityLivingBase.func_110124_au());
        }
        if (!itemStackStemCellSynthesizer.func_190926_b() && this.isStemWorking(entityLivingBase) && (t = this.getMedkitTime(entityLivingBase)) >= 100 && damageMedkit.get(entityLivingBase.func_110124_au()).floatValue() > 0.0f) {
            CyberwarePacketHandler.INSTANCE.sendToAllAround((IMessage)new ParticlePacket(0, (float)entityLivingBase.field_70165_t, (float)entityLivingBase.field_70163_u + entityLivingBase.field_70131_O / 2.0f, (float)entityLivingBase.field_70161_v), new NetworkRegistry.TargetPoint(entityLivingBase.field_70170_p.field_73011_w.getDimension(), entityLivingBase.field_70165_t, entityLivingBase.field_70163_u, entityLivingBase.field_70161_v, 20.0));
            entityLivingBase.func_70691_i(damageMedkit.get(entityLivingBase.func_110124_au()).floatValue());
            timesMedkit.put(entityLivingBase.func_110124_au(), 0);
            damageMedkit.put(entityLivingBase.func_110124_au(), Float.valueOf(0.0f));
        }
    }

    private boolean isPlateletWorking(EntityLivingBase entityLivingBase) {
        if (!isPlateletWorking.containsKey(entityLivingBase.func_110124_au())) {
            isPlateletWorking.put(entityLivingBase.func_110124_au(), false);
            return false;
        }
        return isPlateletWorking.get(entityLivingBase.func_110124_au());
    }

    private boolean isStemWorking(EntityLivingBase entityLivingBase) {
        if (!isStemWorking.containsKey(entityLivingBase.func_110124_au())) {
            isStemWorking.put(entityLivingBase.func_110124_au(), false);
            return false;
        }
        return isStemWorking.get(entityLivingBase.func_110124_au());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleHurt(LivingHurtEvent event) {
        if (event.isCanceled()) {
            return;
        }
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityLivingBase);
        if (cyberwareUserData == null) {
            return;
        }
        ItemStack itemStackStemCellSynthesizer = cyberwareUserData.getCyberware(this.getCachedStack(2));
        if (!itemStackStemCellSynthesizer.func_190926_b()) {
            float damageAmount = event.getAmount();
            DamageSource damageSrc = event.getSource();
            damageAmount = this.applyArmorCalculations(entityLivingBase, damageSrc, damageAmount);
            damageAmount = this.applyPotionDamageCalculations(entityLivingBase, damageSrc, damageAmount);
            damageAmount = Math.max(damageAmount - entityLivingBase.func_110139_bj(), 0.0f);
            damageMedkit.put(entityLivingBase.func_110124_au(), Float.valueOf(damageAmount));
            timesMedkit.put(entityLivingBase.func_110124_au(), entityLivingBase.field_70173_aa);
        }
    }

    protected float applyArmorCalculations(EntityLivingBase entityLivingBase, DamageSource source, float damage) {
        if (!source.func_76363_c()) {
            damage = CombatRules.func_189427_a((float)damage, (float)entityLivingBase.func_70658_aO(), (float)((float)entityLivingBase.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e()));
        }
        return damage;
    }

    protected float applyPotionDamageCalculations(EntityLivingBase entityLivingBase, DamageSource source, float damage) {
        if (source.func_151517_h()) {
            return damage;
        }
        if (entityLivingBase.func_70644_a(MobEffects.field_76429_m) && source != DamageSource.field_76380_i) {
            int i = (entityLivingBase.func_70660_b(MobEffects.field_76429_m).func_76458_c() + 1) * 5;
            int j = 25 - i;
            float f = damage * (float)j;
            damage = f / 25.0f;
        }
        if (damage <= 0.0f) {
            return 0.0f;
        }
        int k = EnchantmentHelper.func_77508_a((Iterable)entityLivingBase.func_184193_aE(), (DamageSource)source);
        if (k > 0) {
            damage = CombatRules.func_188401_b((float)damage, (float)k);
        }
        return damage;
    }

    private int getPlateletTime(EntityLivingBase entityLivingBase) {
        if (entityLivingBase != null) {
            if (!timesPlatelets.containsKey(entityLivingBase.func_110124_au())) {
                timesPlatelets.put(entityLivingBase.func_110124_au(), entityLivingBase.field_70173_aa);
                return 0;
            }
            return entityLivingBase.field_70173_aa - timesPlatelets.get(entityLivingBase.func_110124_au());
        }
        return 0;
    }

    private int getMedkitTime(EntityLivingBase entityLivingBase) {
        if (entityLivingBase != null) {
            if (!timesMedkit.containsKey(entityLivingBase.func_110124_au())) {
                timesMedkit.put(entityLivingBase.func_110124_au(), entityLivingBase.field_70173_aa);
                damageMedkit.put(entityLivingBase.func_110124_au(), Float.valueOf(0.0f));
                return 0;
            }
            return entityLivingBase.field_70173_aa - timesMedkit.get(entityLivingBase.func_110124_au());
        }
        return 0;
    }

    @Override
    public int getPowerConsumption(ItemStack stack) {
        return stack.func_77952_i() == 0 ? 500 : (stack.func_77952_i() == 1 ? 3 : (stack.func_77952_i() == 2 ? 7 : 0));
    }

    @Override
    public int getCapacity(ItemStack stack) {
        return stack.func_77952_i() == 0 ? 500 : 0;
    }

    @Override
    public boolean hasCustomPowerMessage(ItemStack stack) {
        return stack.func_77952_i() == 0;
    }

    @Override
    public int getPowerProduction(ItemStack stack) {
        return stack.func_77952_i() == 3 ? 6 : 0;
    }
}

