/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.item;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.CyberwareUpdateEvent;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.common.ArmorClass;
import flaxbeard.cyberware.common.CyberwareContent;
import flaxbeard.cyberware.common.handler.EssentialsMissingHandler;
import flaxbeard.cyberware.common.item.ItemCyberware;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.EnchantmentThorns;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ItemSkinUpgrade
extends ItemCyberware {
    public static final int META_SOLARSKIN = 0;
    public static final int META_SUBDERMAL_SPIKES = 1;
    public static final int META_SYNTHETIC_SKIN = 2;
    public static final int META_IMMUNOSUPPRESSANT = 3;
    private static Map<UUID, Collection<LastPotionEffect>> mapEntityLastPotionEffects = new HashMap<UUID, Collection<LastPotionEffect>>();

    public ItemSkinUpgrade(String name, ICyberware.EnumSlot slot, String[] subnames) {
        super(name, slot, subnames);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void handleLivingUpdate(CyberwareUpdateEvent event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        if (entityLivingBase.field_70173_aa % 20 != 0) {
            return;
        }
        float lightFactor = this.getLightFactor(entityLivingBase);
        if (lightFactor <= 0.0f) {
            return;
        }
        ICyberwareUserData cyberwareUserData = event.getCyberwareUserData();
        ItemStack itemStackSolarskin = cyberwareUserData.getCyberware(this.getCachedStack(0));
        if (!itemStackSolarskin.func_190926_b()) {
            int power = Math.max(0, Math.round((float)this.getPowerProduction(itemStackSolarskin) * lightFactor));
            cyberwareUserData.addPower(power, itemStackSolarskin);
        }
    }

    private float getLightFactor(EntityLivingBase entityLivingBase) {
        World world = entityLivingBase.field_70170_p;
        if (!entityLivingBase.field_70170_p.field_73011_w.func_191066_m()) {
            return 0.0f;
        }
        BlockPos pos = new BlockPos(entityLivingBase.field_70165_t, entityLivingBase.field_70163_u + (double)entityLivingBase.field_70131_O, entityLivingBase.field_70161_v);
        if (!entityLivingBase.field_70170_p.func_175710_j(pos)) {
            return 0.0f;
        }
        int lightSky = world.func_175642_b(EnumSkyBlock.SKY, pos);
        if (lightSky < 15) {
            return 0.0f;
        }
        float celestialAngleRadians = world.func_72929_e(1.0f);
        float offsetRadians = celestialAngleRadians < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
        float celestialAngleRadians2 = celestialAngleRadians + (offsetRadians - celestialAngleRadians) * 0.2f;
        return MathHelper.func_76134_b((float)celestialAngleRadians2);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void handleMissingEssentials(CyberwareUpdateEvent event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        ICyberwareUserData cyberwareUserData = event.getCyberwareUserData();
        ItemStack itemStackImmunosuppressant = cyberwareUserData.getCyberware(this.getCachedStack(3));
        if (!itemStackImmunosuppressant.func_190926_b()) {
            boolean isPowered;
            if (entityLivingBase instanceof EntityPlayer && entityLivingBase.field_70173_aa % 20 == 0 && !(isPowered = cyberwareUserData.usePower(itemStackImmunosuppressant, this.getPowerConsumption(itemStackImmunosuppressant))) && entityLivingBase.field_70173_aa % 100 == 0 && !entityLivingBase.func_70644_a(CyberwareContent.neuropozyneEffect)) {
                entityLivingBase.func_70097_a(EssentialsMissingHandler.lowessence, 2.0f);
            }
            if (!entityLivingBase.func_130014_f_().field_72995_K) {
                Collection<LastPotionEffect> lastPotionEffects = mapEntityLastPotionEffects.get(entityLivingBase.func_110124_au());
                if (lastPotionEffects == null) {
                    lastPotionEffects = new ArrayList<LastPotionEffect>(2);
                    Collection currentEffects = entityLivingBase.func_70651_bq();
                    for (PotionEffect potionEffectCurrent : currentEffects) {
                        if (potionEffectCurrent.func_188419_a() != MobEffects.field_76436_u && potionEffectCurrent.func_188419_a() != MobEffects.field_76438_s) continue;
                        lastPotionEffects.add(new LastPotionEffect(potionEffectCurrent));
                    }
                    mapEntityLastPotionEffects.put(entityLivingBase.func_110124_au(), lastPotionEffects);
                } else {
                    lastPotionEffects.forEach(lastPotionEffect -> {
                        lastPotionEffect.isFound = false;
                    });
                    Collection currentEffects = entityLivingBase.func_70651_bq();
                    for (PotionEffect potionEffectCurrent : currentEffects) {
                        if (potionEffectCurrent.func_188419_a() != MobEffects.field_76436_u && potionEffectCurrent.func_188419_a() != MobEffects.field_76438_s) continue;
                        boolean found = false;
                        for (LastPotionEffect lastPotionEffect2 : lastPotionEffects) {
                            if (lastPotionEffect2.potion != potionEffectCurrent.func_188419_a() || lastPotionEffect2.amplifier != potionEffectCurrent.func_76458_c() || lastPotionEffect2.duration < potionEffectCurrent.func_76459_b()) continue;
                            lastPotionEffect2.isFound = true;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        PotionEffect potionEffectAugmented = new PotionEffect(potionEffectCurrent.func_188419_a(), (int)((float)potionEffectCurrent.func_76459_b() * 1.8f), potionEffectCurrent.func_76458_c(), potionEffectCurrent.func_82720_e(), potionEffectCurrent.func_188418_e());
                        entityLivingBase.func_70690_d(potionEffectAugmented);
                        LastPotionEffect lastPotionEffectAugmented = new LastPotionEffect(potionEffectAugmented);
                        lastPotionEffectAugmented.isFound = true;
                        lastPotionEffects.add(lastPotionEffectAugmented);
                    }
                    lastPotionEffects.forEach(lastPotionEffect -> --lastPotionEffect.duration);
                    lastPotionEffects.removeIf(lastPotionEffect -> lastPotionEffect.duration < 0 || !lastPotionEffect.isFound);
                }
            }
        } else if (entityLivingBase.field_70173_aa % 20 == 0) {
            mapEntityLastPotionEffects.remove(entityLivingBase.func_110124_au());
        }
    }

    @Override
    public int getPowerConsumption(ItemStack stack) {
        return stack.func_77952_i() == 3 ? 10 : 0;
    }

    @SubscribeEvent
    public void handleHurt(LivingHurtEvent event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityLivingBase);
        if (cyberwareUserData == null) {
            return;
        }
        if (cyberwareUserData.isCyberwareInstalled(this.getCachedStack(1)) && event.getSource() instanceof EntityDamageSource && !(event.getSource() instanceof EntityDamageSourceIndirect)) {
            ArmorClass armorClass = ArmorClass.get(entityLivingBase);
            if (armorClass == ArmorClass.HEAVY) {
                return;
            }
            Random random = entityLivingBase.func_70681_au();
            Entity attacker = event.getSource().func_76346_g();
            if (EnchantmentThorns.func_92094_a((int)3, (Random)random) && attacker != null) {
                attacker.func_70097_a(DamageSource.func_92087_a((Entity)entityLivingBase), (float)EnchantmentThorns.func_92095_b((int)2, (Random)random));
            }
        }
    }

    @Override
    public int getPowerProduction(ItemStack stack) {
        return stack.func_77952_i() == 0 ? 4 : 0;
    }

    private static class LastPotionEffect {
        public final Potion potion;
        public final int amplifier;
        public int duration;
        public boolean isFound;

        LastPotionEffect(@Nonnull PotionEffect potionEffect) {
            this.potion = potionEffect.func_188419_a();
            this.amplifier = potionEffect.func_76458_c();
            this.duration = potionEffect.func_76459_b();
            this.isFound = false;
        }

        public String toString() {
            return String.format("%s x %d, Duration:  %d", this.potion.func_76393_a(), this.amplifier + 1, this.duration);
        }
    }
}

