/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.network;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.hud.CyberwareHudDataEvent;
import flaxbeard.cyberware.api.hud.IHudElement;
import flaxbeard.cyberware.client.gui.hud.HudNBTData;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.concurrent.Callable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class CyberwareSyncPacket
implements IMessage {
    private NBTTagCompound data;
    private int entityId;

    public CyberwareSyncPacket() {
    }

    public CyberwareSyncPacket(NBTTagCompound data, int entityId) {
        this.data = data;
        this.entityId = entityId;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.data);
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.data = ByteBufUtils.readTag((ByteBuf)buf);
    }

    private static class DoSync
    implements Callable<Void> {
        private int entityId;
        private NBTTagCompound data;

        public DoSync(int entityId, NBTTagCompound data) {
            this.entityId = entityId;
            this.data = data;
        }

        @Override
        public Void call() {
            Entity targetEntity = Minecraft.func_71410_x().field_71441_e.func_73045_a(this.entityId);
            ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull(targetEntity);
            if (cyberwareUserData != null) {
                cyberwareUserData.deserializeNBT(this.data);
                if (targetEntity == Minecraft.func_71410_x().field_71439_g) {
                    NBTTagCompound tagCompound = cyberwareUserData.getHudData();
                    CyberwareHudDataEvent hudEvent = new CyberwareHudDataEvent();
                    MinecraftForge.EVENT_BUS.post((Event)hudEvent);
                    List<IHudElement> elements = hudEvent.getElements();
                    for (IHudElement element : elements) {
                        if (!tagCompound.func_74764_b(element.getUniqueName())) continue;
                        element.load(new HudNBTData((NBTTagCompound)tagCompound.func_74781_a(element.getUniqueName())));
                    }
                }
            }
            return null;
        }
    }

    public static class CyberwareSyncPacketHandler
    implements IMessageHandler<CyberwareSyncPacket, IMessage> {
        public IMessage onMessage(CyberwareSyncPacket message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152343_a((Callable)new DoSync(message.entityId, message.data));
            return null;
        }
    }
}

