/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.gui.misc;

import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.SimpleTextButton;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiButtonListBase;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GuiSelectFluid
extends GuiButtonListBase {
    private final IOpenableGui callbackGui;
    private final Supplier<Fluid> defaultFluid;
    private final Consumer<Fluid> callback;

    public GuiSelectFluid(IOpenableGui g, Supplier<Fluid> def, Consumer<Fluid> c) {
        this.setTitle(I18n.func_135052_a((String)"ftblib.select_fluid.gui", (Object[])new Object[0]));
        this.setHasSearchBox(true);
        this.callbackGui = g;
        this.defaultFluid = def;
        this.callback = c;
    }

    @Override
    public void addButtons(Panel panel) {
        if (this.defaultFluid.get() == null) {
            panel.add(new SimpleTextButton(panel, I18n.func_135052_a((String)"ftblib.select_fluid.none", (Object[])new Object[0]), GuiIcons.BARRIER){

                @Override
                public void onClicked(MouseButton button) {
                    GuiHelper.playClickSound();
                    GuiSelectFluid.this.callbackGui.openGui();
                    GuiSelectFluid.this.callback.accept(null);
                }
            });
        }
        for (final Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            FluidStack fluidStack = new FluidStack(fluid, 1000);
            panel.add(new SimpleTextButton(panel, fluid.getLocalizedName(fluidStack), Icon.getIcon(fluid.getStill(fluidStack).toString()).withTint(Color4I.rgb(fluid.getColor(fluidStack)))){

                @Override
                public void onClicked(MouseButton button) {
                    GuiHelper.playClickSound();
                    GuiSelectFluid.this.callbackGui.openGui();
                    GuiSelectFluid.this.callback.accept(fluid);
                }

                @Override
                public Object getIngredientUnderMouse() {
                    return new FluidStack(fluid, 1000);
                }
            });
        }
    }
}

