/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.helper;

import hellfirepvp.modularmachinery.common.crafting.helper.ComponentOutputRestrictor;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentSelectorTag;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.ProcessingComponent;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementType;
import hellfirepvp.modularmachinery.common.integration.recipe.RecipeLayoutPart;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import java.awt.Point;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ComponentRequirement<T, V extends RequirementType<T, ? extends ComponentRequirement<T, V>>> {
    public static final int PRIORITY_WEIGHT_ENERGY = 50000000;
    public static final int PRIORITY_WEIGHT_FLUID = 100;
    public static final int PRIORITY_WEIGHT_ITEM = 50000;
    private final IOType actionType;
    private final V requirementType;
    private ComponentSelectorTag tag = null;

    public ComponentRequirement(V requirementType, IOType actionType) {
        this.requirementType = requirementType;
        this.actionType = actionType;
    }

    public final V getRequirementType() {
        return this.requirementType;
    }

    public final IOType getActionType() {
        return this.actionType;
    }

    public final void setTag(ComponentSelectorTag tag) {
        this.tag = tag;
    }

    public final ComponentSelectorTag getTag() {
        return this.tag;
    }

    public int getSortingWeight() {
        return 0;
    }

    public abstract boolean isValidComponent(ProcessingComponent<?> var1, RecipeCraftingContext var2);

    public abstract boolean startCrafting(ProcessingComponent<?> var1, RecipeCraftingContext var2, ResultChance var3);

    @Nonnull
    public abstract CraftCheck finishCrafting(ProcessingComponent<?> var1, RecipeCraftingContext var2, ResultChance var3);

    @Nonnull
    public abstract CraftCheck canStartCrafting(ProcessingComponent<?> var1, RecipeCraftingContext var2, List<ComponentOutputRestrictor> var3);

    public abstract ComponentRequirement<T, V> deepCopy();

    public abstract ComponentRequirement<T, V> deepCopyModified(List<RecipeModifier> var1);

    public abstract void startRequirementCheck(ResultChance var1, RecipeCraftingContext var2);

    public abstract void endRequirementCheck();

    @Nonnull
    public abstract String getMissingComponentErrorMessage(IOType var1);

    public abstract JEIComponent<T> provideJEIComponent();

    public static interface ChancedRequirement {
        public void setChance(float var1);
    }

    public static abstract class PerTick<T, V extends RequirementType<T, ? extends PerTick<T, V>>>
    extends ComponentRequirement<T, V> {
        public PerTick(V requirementType, IOType actionType) {
            super(requirementType, actionType);
        }

        public abstract void startIOTick(RecipeCraftingContext var1, float var2);

        @Nonnull
        public abstract CraftCheck resetIOTick(RecipeCraftingContext var1);

        @Nonnull
        public abstract CraftCheck doIOTick(ProcessingComponent<?> var1, RecipeCraftingContext var2);
    }

    public static abstract class JEIComponent<T> {
        public abstract Class<T> getJEIRequirementClass();

        public abstract List<T> getJEIIORequirements();

        @SideOnly(value=Side.CLIENT)
        public abstract RecipeLayoutPart<T> getLayoutPart(Point var1);

        @SideOnly(value=Side.CLIENT)
        public RecipeLayoutPart<T> getTemplateLayout() {
            return this.getLayoutPart(new Point(0, 0));
        }

        @SideOnly(value=Side.CLIENT)
        public abstract void onJEIHoverTooltip(int var1, boolean var2, T var3, List<String> var4);
    }
}

