/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.requirement;

import hellfirepvp.modularmachinery.common.base.Mods;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentOutputRestrictor;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.ProcessingComponent;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.crafting.requirement.jei.JEIComponentHybridFluid;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementTypeFluid;
import hellfirepvp.modularmachinery.common.integration.ingredient.HybridFluid;
import hellfirepvp.modularmachinery.common.integration.ingredient.HybridFluidGas;
import hellfirepvp.modularmachinery.common.lib.ComponentTypesMM;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.CopyHandlerHelper;
import hellfirepvp.modularmachinery.common.util.HybridGasTank;
import hellfirepvp.modularmachinery.common.util.HybridTank;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import hellfirepvp.modularmachinery.common.util.nbt.NBTMatchingHelper;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.gas.GasStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;

public class RequirementFluid
extends ComponentRequirement<HybridFluid, RequirementTypeFluid>
implements ComponentRequirement.ChancedRequirement {
    public final HybridFluid required;
    public float chance = 1.0f;
    private HybridFluid requirementCheck;
    private boolean doesntConsumeInput;
    private NBTTagCompound tagMatch = null;
    private NBTTagCompound tagDisplay = null;

    public RequirementFluid(IOType ioType, FluidStack fluid) {
        this(RequirementTypesMM.REQUIREMENT_FLUID, ioType, new HybridFluid(fluid));
    }

    private RequirementFluid(RequirementTypeFluid type, IOType ioType, HybridFluid required) {
        super(type, ioType);
        this.required = required.copy();
        this.requirementCheck = this.required.copy();
    }

    @Optional.Method(modid="mekanism")
    public static RequirementFluid createMekanismGasRequirement(RequirementTypeFluid type, IOType ioType, GasStack gasStack) {
        return new RequirementFluid(type, ioType, new HybridFluidGas(gasStack));
    }

    @Override
    public int getSortingWeight() {
        return 100;
    }

    @Override
    public ComponentRequirement<HybridFluid, RequirementTypeFluid> deepCopy() {
        RequirementFluid fluid = new RequirementFluid((RequirementTypeFluid)((Object)this.getRequirementType()), this.getActionType(), this.required.copy());
        fluid.chance = this.chance;
        fluid.tagMatch = this.getTagMatch();
        fluid.tagDisplay = this.getTagDisplay();
        return fluid;
    }

    @Override
    public ComponentRequirement<HybridFluid, RequirementTypeFluid> deepCopyModified(List<RecipeModifier> modifiers) {
        HybridFluid hybrid = this.required.copy();
        hybrid.setAmount(Math.round(RecipeModifier.applyModifiers(modifiers, this, (float)hybrid.getAmount(), false)));
        RequirementFluid fluid = new RequirementFluid((RequirementTypeFluid)((Object)this.getRequirementType()), this.getActionType(), hybrid);
        fluid.chance = RecipeModifier.applyModifiers(modifiers, this, this.chance, true);
        fluid.tagMatch = this.getTagMatch();
        fluid.tagDisplay = this.getTagDisplay();
        return fluid;
    }

    @Override
    public ComponentRequirement.JEIComponent<HybridFluid> provideJEIComponent() {
        return new JEIComponentHybridFluid(this);
    }

    public void setMatchNBTTag(@Nullable NBTTagCompound tag) {
        this.tagMatch = tag;
    }

    @Nullable
    public NBTTagCompound getTagMatch() {
        if (this.tagMatch == null) {
            return null;
        }
        return this.tagMatch.func_74737_b();
    }

    public void setDisplayNBTTag(@Nullable NBTTagCompound tag) {
        this.tagDisplay = tag;
    }

    @Nullable
    public NBTTagCompound getTagDisplay() {
        if (this.tagDisplay == null) {
            return null;
        }
        return this.tagDisplay.func_74737_b();
    }

    @Override
    public void setChance(float chance) {
        this.chance = chance;
    }

    @Override
    public void startRequirementCheck(ResultChance contextChance, RecipeCraftingContext context) {
        this.requirementCheck = this.required.copy();
        this.requirementCheck.setAmount(Math.round(RecipeModifier.applyModifiers(context, this, (float)this.requirementCheck.getAmount(), false)));
        this.doesntConsumeInput = contextChance.canProduce(RecipeModifier.applyModifiers(context, this, this.chance, true));
    }

    @Override
    public void endRequirementCheck() {
        this.requirementCheck = this.required.copy();
        this.doesntConsumeInput = true;
    }

    @Override
    @Nonnull
    public String getMissingComponentErrorMessage(IOType ioType) {
        ResourceLocation compKey = ((RequirementTypeFluid)((Object)this.getRequirementType())).getRegistryName();
        return String.format("component.missing.%s.%s.%s", compKey.func_110624_b(), compKey.func_110623_a(), ioType.name().toLowerCase());
    }

    @Override
    public boolean isValidComponent(ProcessingComponent<?> component, RecipeCraftingContext ctx) {
        MachineComponent<?> cmp = component.getComponent();
        return (cmp.getComponentType().equals((Object)ComponentTypesMM.COMPONENT_FLUID) || cmp.getComponentType().equals((Object)ComponentTypesMM.COMPONENT_GAS)) && cmp instanceof MachineComponent.FluidHatch && cmp.getIOType() == this.getActionType();
    }

    @Override
    @Nonnull
    public CraftCheck canStartCrafting(ProcessingComponent<?> component, RecipeCraftingContext context, List<ComponentOutputRestrictor> restrictions) {
        Optional<CraftCheck> check;
        HybridTank handler = (HybridTank)((Object)component.getProvidedComponent());
        if (Mods.MEKANISM.isPresent() && (check = this.checkStartCraftingWithMekanism(component, context, handler, restrictions)).isPresent()) {
            return check.get();
        }
        switch (this.getActionType()) {
            case INPUT: {
                FluidStack drained = handler.drainInternal(this.requirementCheck.copy().asFluidStack(), false);
                if (drained == null) {
                    return CraftCheck.failure("craftcheck.failure.fluid.input");
                }
                if (!NBTMatchingHelper.matchNBTCompound(this.tagMatch, drained.tag)) {
                    return CraftCheck.failure("craftcheck.failure.fluid.input");
                }
                this.requirementCheck.setAmount(Math.max(this.requirementCheck.getAmount() - drained.amount, 0));
                if (this.requirementCheck.getAmount() <= 0) {
                    return CraftCheck.success();
                }
                return CraftCheck.failure("craftcheck.failure.fluid.input");
            }
            case OUTPUT: {
                boolean didFill;
                handler = CopyHandlerHelper.copyTank(handler);
                for (ComponentOutputRestrictor restrictor : restrictions) {
                    if (!(restrictor instanceof ComponentOutputRestrictor.RestrictionTank)) continue;
                    ComponentOutputRestrictor.RestrictionTank tank = (ComponentOutputRestrictor.RestrictionTank)restrictor;
                    if (!tank.exactComponent.equals(component)) continue;
                    handler.fillInternal(tank.inserted == null ? null : tank.inserted.copy().asFluidStack(), true);
                }
                int filled = handler.fillInternal(this.requirementCheck.copy().asFluidStack(), false);
                boolean bl = didFill = filled >= this.requirementCheck.getAmount();
                if (didFill) {
                    context.addRestriction(new ComponentOutputRestrictor.RestrictionTank(this.requirementCheck.copy(), component));
                }
                if (didFill) {
                    return CraftCheck.success();
                }
                return CraftCheck.failure("craftcheck.failure.fluid.output.space");
            }
        }
        return CraftCheck.skipComponent();
    }

    @Optional.Method(modid="mekanism")
    private Optional<CraftCheck> checkStartCraftingWithMekanism(ProcessingComponent<?> component, RecipeCraftingContext context, HybridTank handler, List<ComponentOutputRestrictor> restrictions) {
        if (handler instanceof HybridGasTank) {
            HybridGasTank gasTank = (HybridGasTank)handler;
            switch (this.getActionType()) {
                case INPUT: {
                    if (!(this.requirementCheck instanceof HybridFluidGas)) break;
                    GasStack drained = gasTank.drawGas(EnumFacing.UP, this.requirementCheck.getAmount(), false);
                    if (drained == null) {
                        return Optional.of(CraftCheck.failure("craftcheck.failure.gas.input"));
                    }
                    if (drained.getGas() != ((HybridFluidGas)this.requirementCheck).asGasStack().getGas()) {
                        return Optional.of(CraftCheck.failure("craftcheck.failure.gas.input"));
                    }
                    this.requirementCheck.setAmount(Math.max(this.requirementCheck.getAmount() - drained.amount, 0));
                    if (this.requirementCheck.getAmount() <= 0) {
                        return Optional.of(CraftCheck.success());
                    }
                    return Optional.of(CraftCheck.failure("craftcheck.failure.gas.input"));
                }
                case OUTPUT: {
                    boolean didFill;
                    if (!(this.requirementCheck instanceof HybridFluidGas)) break;
                    gasTank = (HybridGasTank)CopyHandlerHelper.copyTank(gasTank);
                    for (ComponentOutputRestrictor restrictor : restrictions) {
                        if (!(restrictor instanceof ComponentOutputRestrictor.RestrictionTank)) continue;
                        ComponentOutputRestrictor.RestrictionTank tank = (ComponentOutputRestrictor.RestrictionTank)restrictor;
                        if (!tank.exactComponent.equals(component) || !(tank.inserted instanceof HybridFluidGas)) continue;
                        gasTank.receiveGas(EnumFacing.UP, ((HybridFluidGas)this.requirementCheck).asGasStack(), true);
                    }
                    int gasFilled = gasTank.receiveGas(EnumFacing.UP, ((HybridFluidGas)this.requirementCheck).asGasStack(), false);
                    boolean bl = didFill = gasFilled >= this.requirementCheck.getAmount();
                    if (didFill) {
                        context.addRestriction(new ComponentOutputRestrictor.RestrictionTank(this.requirementCheck.copy(), component));
                    }
                    if (didFill) {
                        return Optional.of(CraftCheck.success());
                    }
                    return Optional.of(CraftCheck.failure("craftcheck.failure.gas.output.space"));
                }
            }
        }
        return Optional.empty();
    }

    @Override
    public boolean startCrafting(ProcessingComponent<?> component, RecipeCraftingContext context, ResultChance chance) {
        HybridTank handler = (HybridTank)((Object)component.getProvidedComponent());
        switch (this.getActionType()) {
            case INPUT: {
                if (Mods.MEKANISM.isPresent()) {
                    return this.startCraftingWithMekanismHandling(handler, chance);
                }
                FluidStack drainedSimulated = handler.drainInternal(this.requirementCheck.copy().asFluidStack(), false);
                if (drainedSimulated == null) {
                    return false;
                }
                if (!NBTMatchingHelper.matchNBTCompound(this.tagMatch, drainedSimulated.tag)) {
                    return false;
                }
                if (this.doesntConsumeInput) {
                    this.requirementCheck.setAmount(Math.max(this.requirementCheck.getAmount() - drainedSimulated.amount, 0));
                    return this.requirementCheck.getAmount() <= 0;
                }
                FluidStack actualDrained = handler.drainInternal(this.requirementCheck.copy().asFluidStack(), true);
                if (actualDrained == null) {
                    return false;
                }
                if (!NBTMatchingHelper.matchNBTCompound(this.tagMatch, actualDrained.tag)) {
                    return false;
                }
                this.requirementCheck.setAmount(Math.max(this.requirementCheck.getAmount() - actualDrained.amount, 0));
                return this.requirementCheck.getAmount() <= 0;
            }
        }
        return false;
    }

    @Optional.Method(modid="mekanism")
    private boolean startCraftingWithMekanismHandling(HybridTank handler, ResultChance chance) {
        if (this.requirementCheck instanceof HybridFluidGas && handler instanceof HybridGasTank) {
            HybridGasTank gasHandler = (HybridGasTank)handler;
            GasStack drainSimulated = gasHandler.drawGas(EnumFacing.UP, this.requirementCheck.getAmount(), false);
            if (drainSimulated == null) {
                return false;
            }
            if (drainSimulated.getGas() != ((HybridFluidGas)this.requirementCheck).asGasStack().getGas()) {
                return false;
            }
            if (this.doesntConsumeInput) {
                this.requirementCheck.setAmount(Math.max(this.requirementCheck.getAmount() - drainSimulated.amount, 0));
                return this.requirementCheck.getAmount() <= 0;
            }
            GasStack actualDrain = gasHandler.drawGas(EnumFacing.UP, this.requirementCheck.getAmount(), true);
            if (actualDrain == null) {
                return false;
            }
            if (actualDrain.getGas() != ((HybridFluidGas)this.requirementCheck).asGasStack().getGas()) {
                return false;
            }
            this.requirementCheck.setAmount(Math.max(this.requirementCheck.getAmount() - actualDrain.amount, 0));
            return this.requirementCheck.getAmount() <= 0;
        }
        FluidStack drainedSimulated = handler.drainInternal(this.requirementCheck.copy().asFluidStack(), false);
        if (drainedSimulated == null) {
            return false;
        }
        if (!NBTMatchingHelper.matchNBTCompound(this.tagMatch, drainedSimulated.tag)) {
            return false;
        }
        if (this.doesntConsumeInput) {
            this.requirementCheck.setAmount(Math.max(this.requirementCheck.getAmount() - drainedSimulated.amount, 0));
            return this.requirementCheck.getAmount() <= 0;
        }
        FluidStack actualDrained = handler.drainInternal(this.requirementCheck.copy().asFluidStack(), true);
        if (actualDrained == null) {
            return false;
        }
        if (!NBTMatchingHelper.matchNBTCompound(this.tagMatch, actualDrained.tag)) {
            return false;
        }
        this.requirementCheck.setAmount(Math.max(this.requirementCheck.getAmount() - actualDrained.amount, 0));
        return this.requirementCheck.getAmount() <= 0;
    }

    @Override
    @Nonnull
    public CraftCheck finishCrafting(ProcessingComponent<?> component, RecipeCraftingContext context, ResultChance chance) {
        HybridTank handler = (HybridTank)((Object)component.getProvidedComponent());
        switch (this.getActionType()) {
            case OUTPUT: {
                if (Mods.MEKANISM.isPresent()) {
                    return this.finishWithMekanismHandling(handler, context, chance);
                }
                FluidStack outStack = this.requirementCheck.asFluidStack();
                if (outStack == null) break;
                int fillableAmount = handler.fillInternal(outStack.copy(), false);
                if (chance.canProduce(RecipeModifier.applyModifiers(context, this, this.chance, true))) {
                    if (fillableAmount >= outStack.amount) {
                        return CraftCheck.success();
                    }
                    return CraftCheck.failure("craftcheck.failure.fluid.output.space");
                }
                FluidStack copyOut = outStack.copy();
                if (this.tagDisplay != null) {
                    copyOut.tag = this.tagDisplay.func_74737_b();
                }
                if (fillableAmount >= outStack.amount && handler.fillInternal(copyOut.copy(), true) >= copyOut.amount) {
                    return CraftCheck.success();
                }
                return CraftCheck.failure("craftcheck.failure.fluid.output.space");
            }
        }
        return CraftCheck.skipComponent();
    }

    @Optional.Method(modid="mekanism")
    @Nonnull
    private CraftCheck finishWithMekanismHandling(HybridTank handler, RecipeCraftingContext context, ResultChance chance) {
        if (this.requirementCheck instanceof HybridFluidGas && handler instanceof HybridGasTank) {
            HybridGasTank gasTankHandler = (HybridGasTank)handler;
            GasStack gasOut = ((HybridFluidGas)this.requirementCheck).asGasStack();
            int fillableGas = gasTankHandler.receiveGas(EnumFacing.UP, gasOut, false);
            if (fillableGas < gasOut.amount) {
                return CraftCheck.failure("craftcheck.failure.gas.output.space");
            }
            if (chance.canProduce(RecipeModifier.applyModifiers(context, this, this.chance, true))) {
                return CraftCheck.success();
            }
            if (gasTankHandler.receiveGas(EnumFacing.UP, gasOut, true) >= gasOut.amount) {
                return CraftCheck.success();
            }
            return CraftCheck.failure("craftcheck.failure.gas.output.space");
        }
        FluidStack outStack = this.requirementCheck.asFluidStack();
        if (outStack != null) {
            int fillableAmount = handler.fillInternal(outStack.copy(), false);
            if (fillableAmount < outStack.amount) {
                return CraftCheck.failure("craftcheck.failure.gas.output.space");
            }
            if (chance.canProduce(RecipeModifier.applyModifiers(context, this, this.chance, true))) {
                return CraftCheck.success();
            }
            FluidStack copyOut = outStack.copy();
            if (this.tagDisplay != null) {
                copyOut.tag = this.tagDisplay.func_74737_b();
            }
            if (handler.fillInternal(copyOut.copy(), true) >= copyOut.amount) {
                return CraftCheck.success();
            }
            return CraftCheck.failure("craftcheck.failure.gas.output.space");
        }
        return CraftCheck.skipComponent();
    }
}

