/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.integration;

import com.google.common.collect.Lists;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.base.Mods;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.RecipeRegistry;
import hellfirepvp.modularmachinery.common.integration.ingredient.HybridFluid;
import hellfirepvp.modularmachinery.common.integration.ingredient.HybridFluidGas;
import hellfirepvp.modularmachinery.common.integration.ingredient.HybridFluidRenderer;
import hellfirepvp.modularmachinery.common.integration.ingredient.HybridStackHelper;
import hellfirepvp.modularmachinery.common.integration.preview.CategoryStructurePreview;
import hellfirepvp.modularmachinery.common.integration.preview.StructurePreviewWrapper;
import hellfirepvp.modularmachinery.common.integration.recipe.CategoryDynamicRecipe;
import hellfirepvp.modularmachinery.common.integration.recipe.DynamicRecipeWrapper;
import hellfirepvp.modularmachinery.common.integration.recipe.RecipeLayoutHelper;
import hellfirepvp.modularmachinery.common.item.ItemBlueprint;
import hellfirepvp.modularmachinery.common.lib.BlocksMM;
import hellfirepvp.modularmachinery.common.lib.ItemsMM;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.MachineRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IStackHelper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Optional;

@JEIPlugin
public class ModIntegrationJEI
implements IModPlugin {
    public static final String CATEGORY_PREVIEW = "modularmachinery.preview";
    private static Map<DynamicMachine, CategoryDynamicRecipe> recipeCategories = new HashMap<DynamicMachine, CategoryDynamicRecipe>();
    public static IStackHelper stackHelper;
    public static IJeiHelpers jeiHelpers;
    public static IIngredientRegistry ingredientRegistry;
    public static IRecipeRegistry recipeRegistry;

    public static String getCategoryStringFor(DynamicMachine machine) {
        return "modularmachinery.recipes." + machine.getRegistryName().func_110623_a();
    }

    public static CategoryDynamicRecipe getCategory(DynamicMachine machine) {
        return recipeCategories.get(machine);
    }

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        subtypeRegistry.registerSubtypeInterpreter((Item)ItemsMM.blueprint, s -> {
            DynamicMachine machine = ItemBlueprint.getAssociatedMachine(s);
            if (machine == null) {
                return "";
            }
            return machine.getRegistryName().toString();
        });
    }

    public void registerIngredients(IModIngredientRegistration registry) {
        try {
            registry.register(() -> HybridFluid.class, (Collection)Lists.newArrayList(), new HybridStackHelper(), new HybridFluidRenderer());
            if (Mods.MEKANISM.isPresent()) {
                this.registerHybridGas(registry);
            }
        }
        catch (Exception exc) {
            ModularMachinery.log.warn("Error setting up HybridFluid JEI registration! Check the log after this for more details! Report this error!");
            exc.printStackTrace();
            throw exc;
        }
    }

    @Optional.Method(modid="mekanism")
    private void registerHybridGas(IModIngredientRegistration registry) {
        registry.register(() -> HybridFluidGas.class, (Collection)Lists.newArrayList(), new HybridStackHelper(), new HybridFluidRenderer());
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        jeiHelpers = registry.getJeiHelpers();
        RecipeLayoutHelper.init();
        registry.addRecipeCategories(new IRecipeCategory[]{new CategoryStructurePreview()});
        for (DynamicMachine machine : MachineRegistry.getRegistry()) {
            CategoryDynamicRecipe recipe = new CategoryDynamicRecipe(machine);
            recipeCategories.put(machine, recipe);
            registry.addRecipeCategories(new IRecipeCategory[]{recipe});
        }
    }

    public void register(IModRegistry registry) {
        jeiHelpers = registry.getJeiHelpers();
        ingredientRegistry = registry.getIngredientRegistry();
        RecipeLayoutHelper.init();
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlocksMM.blockController), new String[]{CATEGORY_PREVIEW});
        for (DynamicMachine machine : MachineRegistry.getRegistry()) {
            ItemStack stack = new ItemStack((Item)ItemsMM.blueprint);
            ItemBlueprint.setAssociatedMachine(stack, machine);
            registry.addRecipeCatalyst((Object)stack, new String[]{ModIntegrationJEI.getCategoryStringFor(machine)});
        }
        ArrayList previews = Lists.newArrayList();
        for (DynamicMachine machine : MachineRegistry.getRegistry()) {
            previews.add(new StructurePreviewWrapper(machine));
        }
        registry.addRecipes((Collection)previews, CATEGORY_PREVIEW);
        for (DynamicMachine machine : MachineRegistry.getRegistry()) {
            Iterable<MachineRecipe> recipes = RecipeRegistry.getRegistry().getRecipesFor(machine);
            ArrayList<DynamicRecipeWrapper> recipeWrappers = new ArrayList<DynamicRecipeWrapper>();
            for (MachineRecipe recipe : recipes) {
                recipeWrappers.add(new DynamicRecipeWrapper(recipe));
            }
            registry.addRecipes(recipeWrappers, ModIntegrationJEI.getCategoryStringFor(machine));
        }
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        recipeRegistry = jeiRuntime.getRecipeRegistry();
    }
}

