/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.integration.recipe;

import com.google.common.collect.Lists;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.RecipeRegistry;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.tooltip.RequirementTip;
import hellfirepvp.modularmachinery.common.integration.ModIntegrationJEI;
import hellfirepvp.modularmachinery.common.integration.recipe.DynamicRecipeWrapper;
import hellfirepvp.modularmachinery.common.integration.recipe.RecipeLayoutHelper;
import hellfirepvp.modularmachinery.common.integration.recipe.RecipeLayoutPart;
import hellfirepvp.modularmachinery.common.lib.RegistriesMM;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.IOType;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class CategoryDynamicRecipe
implements IRecipeCategory<DynamicRecipeWrapper> {
    private final DynamicMachine machine;
    private final String category;
    private final String title;
    private final IDrawable sizeEmptyDrawable;
    final int realHeight;
    LinkedList<RecipeLayoutPart<?>> inputComponents = Lists.newLinkedList();
    LinkedList<RecipeLayoutPart<?>> outputComponents = Lists.newLinkedList();
    private Point offsetProcessArrow;
    Rectangle rectangleProcessArrow;

    public CategoryDynamicRecipe(DynamicMachine machine) {
        this.machine = machine;
        this.category = ModIntegrationJEI.getCategoryStringFor(machine);
        this.title = machine.getLocalizedName();
        Point maxPoint = this.buildRecipeComponents();
        this.realHeight = maxPoint.y;
        this.sizeEmptyDrawable = ModIntegrationJEI.jeiHelpers.getGuiHelper().createBlankDrawable(maxPoint.x, this.realHeight);
    }

    /*
     * Could not resolve type clashes
     */
    private Point buildRecipeComponents() {
        Iterable<MachineRecipe> recipes = RecipeRegistry.getRegistry().getRecipesFor(this.machine);
        HashMap<IOType, Map> componentCounts = new HashMap<IOType, Map>();
        HashMap componentsFound = new HashMap();
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int offsetX = 8;
        int offsetY = 0;
        int highestY = 0;
        int longestTooltip = 0;
        int widestTooltip = 0;
        for (Object recipe : recipes) {
            Object cmpEntry2;
            HashMap<IOType, Map> tempComp = new HashMap<IOType, Map>();
            for (ComponentRequirement<?, ?> req : ((MachineRecipe)recipe).getCraftingRequirements()) {
                ComponentRequirement.JEIComponent<?> jeiComp = req.provideJEIComponent();
                int amt = tempComp.computeIfAbsent(req.getActionType(), ioType -> new HashMap()).computeIfAbsent(jeiComp.getJEIRequirementClass(), clazz -> 0);
                ((Map)tempComp.get((Object)req.getActionType())).put(jeiComp.getJEIRequirementClass(), ++amt);
                if (componentsFound.containsKey(jeiComp.getJEIRequirementClass())) continue;
                componentsFound.put(jeiComp.getJEIRequirementClass(), jeiComp);
            }
            for (Object cmpEntry2 : tempComp.entrySet()) {
                for (Map.Entry cntEntry : ((Map)cmpEntry2.getValue()).entrySet()) {
                    int current = componentCounts.computeIfAbsent((IOType)((Object)cmpEntry2.getKey()), ioType -> new HashMap()).computeIfAbsent(cntEntry.getKey(), clazz -> 0);
                    if ((Integer)cntEntry.getValue() <= current) continue;
                    ((Map)componentCounts.get(cmpEntry2.getKey())).put(cntEntry.getKey(), cntEntry.getValue());
                }
            }
            int tipLength = 0;
            cmpEntry2 = RegistriesMM.REQUIREMENT_TIPS_REGISTRY.iterator();
            while (cmpEntry2.hasNext()) {
                List<String> tooltip;
                RequirementTip tip = (RequirementTip)((Object)cmpEntry2.next());
                Collection<ComponentRequirement<?, ?>> requirements = tip.filterRequirements((MachineRecipe)recipe, ((MachineRecipe)recipe).getCraftingRequirements());
                if (requirements.isEmpty() || (tooltip = tip.buildTooltip((MachineRecipe)recipe, requirements)).isEmpty()) continue;
                for (String tipString : tooltip) {
                    int length = fr.func_78256_a(tipString);
                    if (length <= widestTooltip) continue;
                    widestTooltip = length;
                }
                tipLength += 9 * tooltip.size();
                tipLength += 2;
            }
            if (tipLength <= longestTooltip) continue;
            longestTooltip = tipLength;
        }
        LinkedList classes = Lists.newLinkedList(componentsFound.keySet());
        classes.sort((o1, o2) -> {
            RecipeLayoutPart part1 = ((ComponentRequirement.JEIComponent)componentsFound.get(o1)).getTemplateLayout();
            RecipeLayoutPart part2 = ((ComponentRequirement.JEIComponent)componentsFound.get(o2)).getTemplateLayout();
            return part2.getComponentHorizontalSortingOrder() - part1.getComponentHorizontalSortingOrder();
        });
        for (Object clazz2 : classes) {
            Map compMap = (Map)componentCounts.get((Object)IOType.INPUT);
            if (compMap == null || !compMap.containsKey(clazz2)) continue;
            ComponentRequirement.JEIComponent component = (ComponentRequirement.JEIComponent)componentsFound.get(clazz2);
            RecipeLayoutPart layoutHelper = component.getTemplateLayout();
            int amt = (Integer)compMap.get(clazz2);
            int partOffsetX = offsetX;
            int originalOffsetX = offsetX;
            int partOffsetY = offsetY;
            for (int i = 0; i < amt; ++i) {
                if (i > 0 && i % layoutHelper.getMaxHorizontalCount() == 0) {
                    partOffsetY += layoutHelper.getComponentHeight() + layoutHelper.getComponentVerticalGap();
                    partOffsetX = originalOffsetX;
                }
                this.inputComponents.add(component.getLayoutPart(new Point(partOffsetX, partOffsetY)));
                if ((partOffsetX += layoutHelper.getComponentWidth() + layoutHelper.getComponentHorizontalGap()) > offsetX) {
                    offsetX = partOffsetX;
                }
                if (partOffsetY + layoutHelper.getComponentHeight() <= highestY) continue;
                highestY = partOffsetY + layoutHelper.getComponentHeight();
            }
        }
        int tempArrowOffsetX = offsetX += 4;
        offsetX += RecipeLayoutHelper.PART_PROCESS_ARROW.xSize;
        offsetX += 4;
        classes = Lists.newLinkedList(componentsFound.keySet());
        classes.sort((o1, o2) -> {
            RecipeLayoutPart part1 = ((ComponentRequirement.JEIComponent)componentsFound.get(o1)).getTemplateLayout();
            RecipeLayoutPart part2 = ((ComponentRequirement.JEIComponent)componentsFound.get(o2)).getTemplateLayout();
            return part1.getComponentHorizontalSortingOrder() - part2.getComponentHorizontalSortingOrder();
        });
        for (Class clazz3 : classes) {
            Map compMap = (Map)componentCounts.get((Object)IOType.OUTPUT);
            if (compMap == null || !compMap.containsKey(clazz3)) continue;
            ComponentRequirement.JEIComponent component = (ComponentRequirement.JEIComponent)componentsFound.get(clazz3);
            RecipeLayoutPart layoutHelper = component.getTemplateLayout();
            int amt = (Integer)compMap.get(clazz3);
            int partOffsetX = offsetX;
            int originalOffsetX = offsetX;
            int partOffsetY = offsetY;
            for (int i = 0; i < amt; ++i) {
                if (i > 0 && i % layoutHelper.getMaxHorizontalCount() == 0) {
                    partOffsetY += layoutHelper.getComponentHeight() + layoutHelper.getComponentVerticalGap();
                    partOffsetX = originalOffsetX;
                }
                this.outputComponents.add(component.getLayoutPart(new Point(partOffsetX, partOffsetY)));
                if ((partOffsetX += layoutHelper.getComponentWidth() + layoutHelper.getComponentHorizontalGap()) > offsetX) {
                    offsetX = partOffsetX;
                }
                if (partOffsetY + layoutHelper.getComponentHeight() <= highestY) continue;
                highestY = partOffsetY + layoutHelper.getComponentHeight();
            }
        }
        int halfY = highestY / 2;
        this.offsetProcessArrow = new Point(tempArrowOffsetX, halfY / 2);
        this.rectangleProcessArrow = new Rectangle(this.offsetProcessArrow.x, this.offsetProcessArrow.y, RecipeLayoutHelper.PART_PROCESS_ARROW.xSize, RecipeLayoutHelper.PART_PROCESS_ARROW.zSize);
        highestY += longestTooltip;
        if ((widestTooltip += 8) > offsetX) {
            offsetX = widestTooltip;
        }
        return new Point(offsetX, highestY);
    }

    public String getUid() {
        return this.category;
    }

    public String getTitle() {
        return this.title;
    }

    public String getModName() {
        return "Modular Machinery";
    }

    public IDrawable getBackground() {
        return this.sizeEmptyDrawable;
    }

    public void drawExtras(Minecraft minecraft) {
        RecipeLayoutHelper.PART_PROCESS_ARROW.drawable.draw(minecraft, this.offsetProcessArrow.x, this.offsetProcessArrow.y);
        for (RecipeLayoutPart recipeLayoutPart : this.inputComponents) {
            recipeLayoutPart.drawBackground(minecraft);
        }
        for (RecipeLayoutPart recipeLayoutPart : this.outputComponents) {
            recipeLayoutPart.drawBackground(minecraft);
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, DynamicRecipeWrapper recipeWrapper, IIngredients ingredients) {
        LinkedList foundClasses = new LinkedList();
        for (IOType type : IOType.values()) {
            for (Class<?> clazz : recipeWrapper.finalOrderedComponents.get((Object)type).keySet()) {
                if (clazz.equals(Long.class) || foundClasses.contains(clazz)) continue;
                foundClasses.add(clazz);
            }
        }
        for (Class clazz : foundClasses) {
            int amtCompInputs = 0;
            IGuiIngredientGroup clazzGroup = recipeLayout.getIngredientsGroup(clazz);
            int compSlotIndex = 0;
            for (RecipeLayoutPart slot : this.inputComponents.stream().filter(c -> clazz.isAssignableFrom(c.getLayoutTypeClass())).collect(Collectors.toList())) {
                clazzGroup.init(compSlotIndex, true, slot.provideIngredientRenderer(), slot.getOffset().x, slot.getOffset().y, slot.getComponentWidth(), slot.getComponentHeight(), slot.getRendererPaddingX(), slot.getRendererPaddingY());
                ++compSlotIndex;
                ++amtCompInputs;
            }
            for (RecipeLayoutPart slot : this.outputComponents.stream().filter(c -> clazz.isAssignableFrom(c.getLayoutTypeClass())).collect(Collectors.toList())) {
                clazzGroup.init(compSlotIndex, false, slot.provideIngredientRenderer(), slot.getOffset().x, slot.getOffset().y, slot.getComponentWidth(), slot.getComponentHeight(), slot.getRendererPaddingX(), slot.getRendererPaddingY());
                ++compSlotIndex;
            }
            clazzGroup.set(ingredients);
            int finalAmtInputs = amtCompInputs;
            clazzGroup.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
                Map<Class<?>, List<ComponentRequirement<?, ?>>> components = recipeWrapper.finalOrderedComponents.get((Object)(input ? IOType.INPUT : IOType.OUTPUT));
                if (components != null) {
                    int index;
                    List<ComponentRequirement<?, ?>> compList = components.get(clazz);
                    int n = index = input ? slotIndex : slotIndex - finalAmtInputs;
                    if (index < 0 || index >= compList.size()) {
                        return;
                    }
                    ComponentRequirement.JEIComponent<?> jeiComp = compList.get(index).provideJEIComponent();
                    jeiComp.onJEIHoverTooltip(index, input, ingredient, tooltip);
                }
            });
        }
    }
}

