/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.enchantment;

import cofh.core.item.IEnchantableItem;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.StringHelper;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class EnchantmentSmashing
extends Enchantment {
    public static boolean enable = true;
    public static final int ORE_MULTIPLIER = 2;
    public static final int ORE_MULTIPLIER_SPECIAL = 3;
    public static Map<String, SmashConversion> smashList = new Object2ObjectOpenHashMap();

    public EnchantmentSmashing(String id) {
        super(Enchantment.Rarity.RARE, EnumEnchantmentType.DIGGER, EntityEquipmentSlot.values());
        this.setRegistryName(id);
    }

    public int func_77321_a(int level) {
        return 15;
    }

    public int func_77317_b(int level) {
        return this.func_77321_a(level) + 50;
    }

    public int func_77325_b() {
        return 1;
    }

    public String func_77320_a() {
        return "enchantment.cofhcore.smashing";
    }

    public boolean func_92089_a(ItemStack stack) {
        Item item = stack.func_77973_b();
        return enable && (item.getToolClasses(stack).contains("pickaxe") || item instanceof IEnchantableItem && ((IEnchantableItem)item).canEnchant(stack, this));
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.func_92089_a(stack);
    }

    public boolean func_77326_a(Enchantment ench) {
        return super.func_77326_a(ench) && ench != Enchantments.field_185306_r;
    }

    public boolean isAllowedOnBooks() {
        return enable;
    }

    public static ItemStack getItemStack(ItemStack stack) {
        SmashConversion result = smashList.get(ItemHelper.getOreName(stack));
        if (result == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack ret = result.toItemStack();
        return ret.func_190926_b() ? ItemStack.field_190927_a : ItemHelper.cloneStack(ret, ret.func_190916_E() * stack.func_190916_E());
    }

    public static void initialize() {
        for (String oreName : OreDictionary.getOreNames()) {
            String oreType;
            if (oreName.startsWith("ore") || oreName.startsWith("gem")) {
                oreType = oreName.substring(3, oreName.length());
                EnchantmentSmashing.addConversions(oreType);
                continue;
            }
            if (!oreName.startsWith("dust")) continue;
            oreType = oreName.substring(4, oreName.length());
            EnchantmentSmashing.addConversions(oreType);
        }
    }

    private static void addConversions(String oreType) {
        if (oreType == null || oreType.isEmpty()) {
            return;
        }
        String suffix = StringHelper.titleCase(oreType);
        String oreName = "ore" + suffix;
        String gemName = "gem" + suffix;
        String dustName = "dust" + suffix;
        String oreNetherName = "oreNether" + suffix;
        String oreEndName = "oreEnd" + suffix;
        if (ItemHelper.oreNameExists(gemName)) {
            EnchantmentSmashing.addConversion(oreName, gemName, 2);
            EnchantmentSmashing.addConversion(oreNetherName, gemName, 3);
            EnchantmentSmashing.addConversion(oreEndName, gemName, 3);
        } else if (ItemHelper.oreNameExists(dustName)) {
            EnchantmentSmashing.addConversion(oreName, dustName, 2);
            EnchantmentSmashing.addConversion(oreNetherName, dustName, 3);
            EnchantmentSmashing.addConversion(oreEndName, dustName, 3);
        }
    }

    private static boolean addConversion(String oreName, String resultName, int count) {
        if (oreName.isEmpty() || resultName.isEmpty() || count <= 0 || smashList.containsKey(oreName)) {
            return false;
        }
        smashList.put(oreName, new SmashConversion(resultName, count));
        return true;
    }

    public static class SmashConversion {
        final String ore;
        final int count;

        SmashConversion(String ore, int count) {
            this.ore = ore;
            this.count = count;
        }

        ItemStack toItemStack() {
            return ItemHelper.getOre(this.ore, this.count);
        }
    }
}

