/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.explosive;

import icbm.classic.ICBMClassic;
import icbm.classic.content.explosive.Explosive;
import icbm.classic.content.explosive.blast.Blast;
import icbm.classic.content.explosive.blast.BlastShrapnel;
import icbm.classic.content.explosive.blast.BlastTNT;
import icbm.classic.content.explosive.blast.threaded.BlastNuclear;
import icbm.classic.content.explosive.handlers.ExAntiGravitational;
import icbm.classic.content.explosive.handlers.ExAntimatter;
import icbm.classic.content.explosive.handlers.ExBreaching;
import icbm.classic.content.explosive.handlers.ExChemical;
import icbm.classic.content.explosive.handlers.ExDebilitation;
import icbm.classic.content.explosive.handlers.ExEMP;
import icbm.classic.content.explosive.handlers.ExEnder;
import icbm.classic.content.explosive.handlers.ExEndothermic;
import icbm.classic.content.explosive.handlers.ExExothermic;
import icbm.classic.content.explosive.handlers.ExIncendiary;
import icbm.classic.content.explosive.handlers.ExRedMatter;
import icbm.classic.content.explosive.handlers.ExRejuvenation;
import icbm.classic.content.explosive.handlers.ExRepulsive;
import icbm.classic.content.explosive.handlers.ExSMine;
import icbm.classic.content.explosive.handlers.ExSonic;
import icbm.classic.content.explosive.handlers.ExXMAS;
import icbm.classic.content.explosive.handlers.Explosion;
import icbm.classic.content.explosive.handlers.missiles.Missile;
import icbm.classic.content.explosive.handlers.missiles.MissileAnti;
import icbm.classic.content.explosive.handlers.missiles.MissileCluster;
import icbm.classic.content.explosive.handlers.missiles.MissileHoming;
import icbm.classic.content.explosive.handlers.missiles.MissileModule;
import icbm.classic.content.explosive.handlers.missiles.MissileNuclearCluster;
import icbm.classic.prefab.tile.EnumTier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;

public enum Explosives implements IStringSerializable
{
    CONDENSED(new Explosion("condensed", EnumTier.ONE, () -> new BlastTNT().setPower(6.0f)).setFuseTime(1)),
    SHRAPNEL("shrapnel", EnumTier.ONE, () -> new BlastShrapnel().setFlaming().setPower(30.0f)),
    INCENDIARY(new ExIncendiary("incendiary", EnumTier.ONE)),
    DEBLITATION(new ExDebilitation("debilitation", EnumTier.ONE)),
    CHEMICAL(new ExChemical("chemical", EnumTier.ONE)),
    ANVIL("anvil", EnumTier.ONE, () -> new BlastShrapnel().setAnvil().setPower(25.0f)),
    REPLUSIVE(new ExRepulsive("repulsive", EnumTier.ONE)),
    ATTRACTIVE(new ExRepulsive("attractive", EnumTier.ONE)),
    FRAGMENTATION("fragmentation", EnumTier.TWO, () -> new BlastShrapnel().setFlaming().setExplosive().setPower(15.0f)),
    CONTAGIOUS(new ExChemical("contagious", EnumTier.TWO)),
    SONIC(new ExSonic("sonic", EnumTier.TWO)),
    BREACHING(new ExBreaching()),
    REJUVENATION(new ExRejuvenation()),
    THERMOBARIC("thermobaric", EnumTier.TWO, () -> new BlastNuclear().setEnergy(45.0f).setPower(30.0f)),
    SMINE(new ExSMine("sMine", EnumTier.TWO)),
    NUCLEAR("nuclear", EnumTier.THREE, () -> new BlastNuclear().setNuclear().setEnergy(80.0f).setPower(50.0f)),
    EMP(new ExEMP()),
    EXOTHERMIC(new ExExothermic()),
    ENDOTHERMIC(new ExEndothermic()),
    ANTI_GRAV(new ExAntiGravitational()),
    ENDER(new ExEnder()),
    HYPERSONIC(new ExSonic("hypersonic", EnumTier.THREE)),
    ANTIMATTER(new ExAntimatter()),
    REDMATTER(new ExRedMatter()),
    MISSILE(new MissileModule()),
    MISSILE_HOMING(new MissileHoming()),
    MISSILE_ANTI(new MissileAnti()),
    MISSILE_CLUSTER(new MissileCluster("cluster", EnumTier.TWO)),
    MISSILE_CLUSTER_NUKE(new MissileNuclearCluster()),
    XMAS_ZOMBIE(new ExXMAS(true)),
    XMAS_SKELETON(new ExXMAS(false));

    public final Explosive handler;

    private Explosives(Explosive handler) {
        this.handler = handler;
    }

    private Explosives(String name, EnumTier tier, Supplier<Blast> factory) {
        this(new Explosion(name, tier, factory));
    }

    public ItemStack getItemStack() {
        return this.getItemStack(1);
    }

    public ItemStack getItemStack(int amount) {
        if (this.handler instanceof Missile) {
            return new ItemStack(ICBMClassic.itemMissile, amount, this.ordinal());
        }
        return new ItemStack(ICBMClassic.blockExplosive, amount, this.ordinal());
    }

    public static Explosives get(int itemDamage) {
        if (itemDamage >= 0 && itemDamage < Explosives.values().length) {
            return Explosives.values()[itemDamage];
        }
        return CONDENSED;
    }

    public String func_176610_l() {
        return super.name().toLowerCase();
    }

    public static List<Explosives> getBlocksOnly() {
        ArrayList<Explosives> list = new ArrayList<Explosives>();
        for (Explosives ex : Explosives.values()) {
            if (!ex.handler.hasBlockForm()) continue;
            list.add(ex);
        }
        return list;
    }
}

