/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.items;

import icbm.classic.config.ConfigBattery;
import icbm.classic.lib.energy.storage.EnergyBufferLimited;
import icbm.classic.prefab.item.ItemICBMBase;
import icbm.classic.prefab.item.ItemStackCapProvider;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBattery
extends ItemICBMBase {
    public ItemBattery() {
        super("battery");
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        ItemStackCapProvider provider = new ItemStackCapProvider(stack);
        provider.add("battery", CapabilityEnergy.ENERGY, new EnergyBufferLimited(ConfigBattery.BATTERY_CAPACITY, ConfigBattery.BATTERY_INPUT_LIMIT, ConfigBattery.BATTERY_OUTPUT_LIMIT));
        return provider;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag flag) {
        IEnergyStorage energyStorage;
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null) && (energyStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
            double p = this.getDurabilityForDisplay(stack) * 100.0;
            list.add("L: " + (int)p + "%");
            list.add("E: " + energyStorage.getEnergyStored() + "/" + energyStorage.getMaxEnergyStored() + " FE");
        }
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        IEnergyStorage energyStorage;
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null) && (energyStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
            return (double)energyStorage.getEnergyStored() / (double)energyStorage.getMaxEnergyStored();
        }
        return 1.0;
    }
}

