/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.machines.battery;

import java.util.Iterator;
import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;

public class InventoryEnergyStorage
implements IEnergyStorage,
Iterable<IEnergyStorage> {
    public final IItemHandler inventory;

    public InventoryEnergyStorage(IItemHandler inventory) {
        this.inventory = inventory;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energy = 0;
        int energyLeft = maxReceive;
        for (IEnergyStorage storage : this) {
            int added = storage.receiveEnergy(energyLeft, simulate);
            energy += added;
            energyLeft -= added;
        }
        return energy;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int energy = 0;
        int energyToRemove = maxExtract;
        for (IEnergyStorage storage : this) {
            int added = storage.extractEnergy(energyToRemove, simulate);
            energy += added;
            energyToRemove -= added;
        }
        return energy;
    }

    public int getEnergyStored() {
        int energy = 0;
        for (IEnergyStorage storage : this) {
            energy += storage.getEnergyStored();
        }
        return energy;
    }

    public int getMaxEnergyStored() {
        int energy = 0;
        for (IEnergyStorage storage : this) {
            energy += storage.getMaxEnergyStored();
        }
        return energy;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    @Override
    public Iterator<IEnergyStorage> iterator() {
        return new IESIterator(this.inventory);
    }

    public static class IESIterator
    implements Iterator<IEnergyStorage> {
        private final IItemHandler inventory;
        int currentSlot = -1;
        int nextSlot = 0;

        public IESIterator(IItemHandler inventory) {
            this.inventory = inventory;
        }

        @Override
        public boolean hasNext() {
            while (this.get(this.nextSlot) == null && this.insideLimits()) {
                ++this.nextSlot;
            }
            return this.isNextValid();
        }

        private boolean insideLimits() {
            return this.nextSlot >= 0 && this.nextSlot < this.inventory.getSlots();
        }

        private boolean isNextValid() {
            return this.insideLimits() && this.get(this.nextSlot) != null;
        }

        @Override
        public IEnergyStorage next() {
            this.currentSlot = this.nextSlot++;
            return this.get(this.currentSlot);
        }

        public IEnergyStorage get(int index) {
            ItemStack itemStack = this.inventory.getStackInSlot(index);
            if (!itemStack.func_190926_b() && itemStack.hasCapability(CapabilityEnergy.ENERGY, null)) {
                return (IEnergyStorage)itemStack.getCapability(CapabilityEnergy.ENERGY, null);
            }
            return null;
        }
    }
}

