/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client;

import com.flansmod.client.model.GunAnimations;
import com.flansmod.client.teams.ClientTeamsData;
import com.flansmod.client.util.WorldRenderer;
import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.mechas.EntityMecha;
import com.flansmod.common.guns.AttachmentType;
import com.flansmod.common.guns.EntityBullet;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.IScope;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.network.PacketTeamInfo;
import com.flansmod.common.teams.Team;
import com.flansmod.common.types.InfoType;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import scala.actors.threadpool.Arrays;

@SideOnly(value=Side.CLIENT)
public class FlansModClient
extends FlansMod {
    public static boolean doneTutorial = false;
    public static boolean controlModeMouse = true;
    public static int controlModeSwitchTimer = 20;
    public static float playerRecoil;
    public static float antiRecoil;
    public static HashMap<EntityLivingBase, GunAnimations> gunAnimationsRight;
    public static HashMap<EntityLivingBase, GunAnimations> gunAnimationsLeft;
    public static int scopeTime;
    public static IScope currentScope;
    public static float zoomProgress;
    public static float lastZoomProgress;
    public static float lastZoomLevel;
    public static float lastFOVZoomLevel;
    public static float originalMouseSensitivity;
    public static float originalFOV;
    public static int originalThirdPerson;
    public static boolean inPlane;
    public static int numVehicleExceptions;
    public static PacketTeamInfo teamInfo;
    public static int hitMarkerTime;
    public static List<BlockPos> blockLightOverrides;
    public static int lightOverrideRefreshRate;
    private static WorldRenderer wr;
    public static Minecraft minecraft;

    public static WorldRenderer getWorldRenderer() {
        return wr;
    }

    public void load() {
        log.info("Loading Flan's mod client side.");
        wr = new WorldRenderer();
    }

    private static void DoTextureTrim() {
        for (File contentPack : FlansMod.contentManager.GetFolderContentPacks()) {
            File skinFolder = new File(contentPack, "assets/flansmod/skins");
            if (!skinFolder.exists() || !skinFolder.isDirectory()) continue;
            List skins = Arrays.asList((Object[])skinFolder.listFiles());
            HashMap skinGroups = new HashMap();
            for (File file : skins) {
                String skinName = file.getName().split("\\.")[0];
                boolean foundParent = false;
                for (File other : skins) {
                    String otherName = other.getName().split("\\.")[0];
                    if (!skinName.startsWith(otherName)) continue;
                    if (!skinGroups.containsKey(otherName)) {
                        skinGroups.put(otherName, new ArrayList(8));
                    }
                    ((List)skinGroups.get(otherName)).add(file);
                    foundParent = true;
                    break;
                }
                if (foundParent) continue;
                if (!skinGroups.containsKey(skinName)) {
                    skinGroups.put(skinName, new ArrayList(8));
                }
                ((List)skinGroups.get(skinName)).add(file);
            }
            for (Map.Entry entry : skinGroups.entrySet()) {
                String key = (String)entry.getKey();
                int x = 1;
                int y = 1;
                for (File skin : (List)entry.getValue()) {
                    try {
                        BufferedImage img = ImageIO.read(skin);
                        WritableRaster alpha = img.getAlphaRaster();
                        if (alpha == null) continue;
                        for (int i = 0; i < alpha.getWidth(); ++i) {
                            for (int j = 0; j < alpha.getHeight(); ++j) {
                                if (i < x && j < y || !((float)alpha.getSample(i, j, 0) > 0.0f)) continue;
                                if (i >= x && x < alpha.getWidth()) {
                                    x *= 2;
                                }
                                if (j < y || y >= alpha.getHeight()) continue;
                                y *= 2;
                            }
                        }
                    }
                    catch (Exception img) {
                    }
                }
                boolean anyResizeApplied = false;
                for (File skin : (List)entry.getValue()) {
                    try {
                        BufferedImage img = ImageIO.read(skin);
                        if (x >= img.getWidth() && y >= img.getHeight()) continue;
                        Raster subImg = img.getData(new Rectangle(0, 0, x, y));
                        BufferedImage cropped = new BufferedImage(x, y, 2);
                        cropped.setData(subImg);
                        ImageIO.write((RenderedImage)cropped, "PNG", skin);
                        anyResizeApplied = true;
                    }
                    catch (Exception exception) {}
                }
                if (!anyResizeApplied) continue;
                FlansMod.log.info(key + " was resized to " + x + ", " + y);
            }
        }
    }

    public static void tick() {
        if (FlansModClient.minecraft.field_71439_g == null || FlansModClient.minecraft.field_71441_e == null) {
            return;
        }
        if (teamInfo != null && FlansModClient.teamInfo.timeLeft > 0) {
            --FlansModClient.teamInfo.timeLeft;
        }
        ClientTeamsData.Tick();
        if (numVehicleExceptions > 2) {
            log.error("Too many vehicle exceptions, shutting down.");
            minecraft.func_71400_g();
        }
        if (scopeTime > 0) {
            --scopeTime;
        }
        if (playerRecoil > 0.0f) {
            playerRecoil *= 0.8f;
        }
        if (hitMarkerTime > 0) {
            --hitMarkerTime;
        }
        FlansModClient.minecraft.field_71439_g.field_70125_A -= playerRecoil;
        FlansModClient.minecraft.field_71439_g.field_70125_A += (antiRecoil += playerRecoil) * 0.2f;
        antiRecoil *= 0.8f;
        for (GunAnimations g : gunAnimationsRight.values()) {
            g.update();
        }
        for (GunAnimations g : gunAnimationsLeft.values()) {
            g.update();
        }
        ItemStack itemstackInHand = FlansModClient.minecraft.field_71439_g.field_71071_by.func_70448_g();
        Item itemInHand = itemstackInHand.func_77973_b();
        if (!(currentScope == null || FMLClientHandler.instance().getClient().field_71462_r == null && itemInHand instanceof ItemGun && ((ItemGun)itemInHand).GetType().getCurrentScope(itemstackInHand) == currentScope)) {
            currentScope = null;
            FlansModClient.minecraft.field_71474_y.field_74334_X = originalFOV;
            FlansModClient.minecraft.field_71474_y.field_74341_c = originalMouseSensitivity;
            FlansModClient.minecraft.field_71474_y.field_74320_O = originalThirdPerson;
        }
        lastZoomProgress = zoomProgress;
        zoomProgress = currentScope == null ? (zoomProgress *= 0.66f) : 1.0f - (1.0f - zoomProgress) * 0.66f;
        if (controlModeSwitchTimer > 0) {
            --controlModeSwitchTimer;
        }
        if (minecraft.func_175606_aa() == null || FlansModClient.minecraft.func_175606_aa().field_70128_L) {
            minecraft.func_175607_a((Entity)FlansModClient.minecraft.field_71439_g);
        }
    }

    public static void setScope(IScope scope) {
        GameSettings gameSettings = FMLClientHandler.instance().getClient().field_71474_y;
        if (scopeTime <= 0 && FMLClientHandler.instance().getClient().field_71462_r == null) {
            if (currentScope == null) {
                currentScope = scope;
                lastZoomLevel = scope.getZoomFactor();
                lastFOVZoomLevel = scope.getFOVFactor();
                float f = originalMouseSensitivity = gameSettings.field_74341_c;
                gameSettings.field_74341_c = f / (float)Math.sqrt(scope.getZoomFactor());
                originalThirdPerson = gameSettings.field_74320_O;
                gameSettings.field_74320_O = 0;
                originalFOV = gameSettings.field_74334_X;
            } else {
                currentScope = null;
                gameSettings.field_74341_c = originalMouseSensitivity;
                gameSettings.field_74320_O = originalThirdPerson;
                gameSettings.field_74334_X = originalFOV;
            }
            scopeTime = 10;
        }
    }

    public static void updateCameraZoom(float smoothing) {
        if (Math.abs(zoomProgress - lastZoomProgress) > 1.0E-4f) {
            float actualZoomProgress = lastZoomProgress + (zoomProgress - lastZoomProgress) * smoothing;
            float botchedZoomProgress = zoomProgress > 0.8f ? 1.0f : 0.0f;
            double zoomLevel = botchedZoomProgress * lastZoomLevel + (1.0f - botchedZoomProgress);
            float FOVZoomLevel = actualZoomProgress * lastFOVZoomLevel + (1.0f - actualZoomProgress);
            if (Math.abs(zoomLevel - 1.0) < (double)0.01f) {
                zoomLevel = 1.0;
            }
            float zoomToApply = Math.max(FOVZoomLevel, (float)zoomLevel);
            FlansModClient.minecraft.field_71474_y.field_74334_X = ((originalFOV * 40.0f + 70.0f) / zoomToApply - 70.0f) / 40.0f;
        }
    }

    public static boolean flipControlMode() {
        if (controlModeSwitchTimer > 0) {
            return false;
        }
        controlModeMouse = !controlModeMouse;
        controlModeSwitchTimer = 40;
        return true;
    }

    public static void reloadModels(boolean reloadSkins) {
        for (InfoType type : InfoType.infoTypes.values()) {
            type.reloadModel();
        }
        if (reloadSkins) {
            proxy.forceReload();
        }
    }

    public static Team getTeam(int spawnerTeamID) {
        if (teamInfo == null) {
            return null;
        }
        return teamInfo.getTeam(spawnerTeamID);
    }

    public static boolean isCurrentMap(String map) {
        return teamInfo != null && FlansModClient.teamInfo.mapShortName != null && FlansModClient.teamInfo.mapShortName.equals(map);
    }

    @SideOnly(value=Side.CLIENT)
    public static Particle getParticle(String s, World w, double x, double y, double z) {
        Minecraft mc = Minecraft.func_71410_x();
        int particleID = 0;
        int[] data = new int[]{};
        if (s.equals("hugeexplosion")) {
            particleID = EnumParticleTypes.EXPLOSION_HUGE.func_179348_c();
        } else if (s.equals("largeexplode")) {
            particleID = EnumParticleTypes.EXPLOSION_LARGE.func_179348_c();
        } else if (s.equals("explode")) {
            particleID = EnumParticleTypes.EXPLOSION_NORMAL.func_179348_c();
        } else if (s.equals("fireworksSpark")) {
            particleID = EnumParticleTypes.FIREWORKS_SPARK.func_179348_c();
        } else if (s.equals("bubble")) {
            particleID = EnumParticleTypes.WATER_BUBBLE.func_179348_c();
        } else if (s.equals("splash")) {
            particleID = EnumParticleTypes.WATER_SPLASH.func_179348_c();
        } else if (s.equals("wake")) {
            particleID = EnumParticleTypes.WATER_WAKE.func_179348_c();
        } else if (s.equals("drop")) {
            particleID = EnumParticleTypes.WATER_DROP.func_179348_c();
        } else if (s.equals("suspended")) {
            particleID = EnumParticleTypes.SUSPENDED.func_179348_c();
        } else if (s.equals("depthsuspend")) {
            particleID = EnumParticleTypes.SUSPENDED_DEPTH.func_179348_c();
        } else if (s.equals("townaura")) {
            particleID = EnumParticleTypes.TOWN_AURA.func_179348_c();
        } else if (s.equals("crit")) {
            particleID = EnumParticleTypes.CRIT.func_179348_c();
        } else if (s.equals("magicCrit")) {
            particleID = EnumParticleTypes.CRIT_MAGIC.func_179348_c();
        } else if (s.equals("smoke")) {
            particleID = EnumParticleTypes.SMOKE_NORMAL.func_179348_c();
        } else if (s.equals("largesmoke")) {
            particleID = EnumParticleTypes.SMOKE_LARGE.func_179348_c();
        } else if (s.equals("spell")) {
            particleID = EnumParticleTypes.SPELL.func_179348_c();
        } else if (s.equals("instantSpell")) {
            particleID = EnumParticleTypes.SPELL_INSTANT.func_179348_c();
        } else if (s.equals("mobSpell")) {
            particleID = EnumParticleTypes.SPELL_MOB.func_179348_c();
        } else if (s.equals("mobSpellAmbient")) {
            particleID = EnumParticleTypes.SPELL_MOB_AMBIENT.func_179348_c();
        } else if (s.equals("witchMagic")) {
            particleID = EnumParticleTypes.SPELL_WITCH.func_179348_c();
        } else if (s.equals("dripWater")) {
            particleID = EnumParticleTypes.DRIP_WATER.func_179348_c();
        } else if (s.equals("dripLava")) {
            particleID = EnumParticleTypes.DRIP_LAVA.func_179348_c();
        } else if (s.equals("angryVillager")) {
            particleID = EnumParticleTypes.VILLAGER_ANGRY.func_179348_c();
        } else if (s.equals("happyVillager")) {
            particleID = EnumParticleTypes.VILLAGER_HAPPY.func_179348_c();
        } else if (s.equals("note")) {
            particleID = EnumParticleTypes.NOTE.func_179348_c();
        } else if (s.equals("portal")) {
            particleID = EnumParticleTypes.PORTAL.func_179348_c();
        } else if (s.equals("enchantmenttable")) {
            particleID = EnumParticleTypes.ENCHANTMENT_TABLE.func_179348_c();
        } else if (s.equals("flame")) {
            particleID = EnumParticleTypes.FLAME.func_179348_c();
        } else if (s.equals("lava")) {
            particleID = EnumParticleTypes.LAVA.func_179348_c();
        } else if (s.equals("footstep")) {
            particleID = EnumParticleTypes.FOOTSTEP.func_179348_c();
        } else if (s.equals("cloud")) {
            particleID = EnumParticleTypes.CLOUD.func_179348_c();
        } else if (s.equals("reddust")) {
            particleID = EnumParticleTypes.REDSTONE.func_179348_c();
        } else if (s.equals("snowballpoof")) {
            particleID = EnumParticleTypes.SNOWBALL.func_179348_c();
        } else if (s.equals("snowshovel")) {
            particleID = EnumParticleTypes.SNOW_SHOVEL.func_179348_c();
        } else if (s.equals("slime")) {
            particleID = EnumParticleTypes.SLIME.func_179348_c();
        } else if (s.equals("heart")) {
            particleID = EnumParticleTypes.HEART.func_179348_c();
        } else if (s.equals("barrier")) {
            particleID = EnumParticleTypes.BARRIER.func_179348_c();
        } else if (s.contains("_")) {
            String[] split = s.split("_", 3);
            if (split[0].equals("iconcrack")) {
                data = new int[]{Item.func_150891_b((Item)InfoType.getRecipeElement(split[1], 1, 0).func_77973_b())};
                particleID = EnumParticleTypes.ITEM_CRACK.func_179348_c();
            } else {
                data = new int[]{Block.func_149682_b((Block)Block.func_149634_a((Item)InfoType.getRecipeElement(split[1], 1, 0).func_77973_b()))};
                if (split[0].equals("blockcrack")) {
                    particleID = EnumParticleTypes.BLOCK_CRACK.func_179348_c();
                } else if (split[0].equals("blockdust")) {
                    particleID = EnumParticleTypes.BLOCK_DUST.func_179348_c();
                }
            }
        }
        return mc.field_71452_i.func_178927_a(particleID, x, y, z, 0.0, 0.0, 0.0, data);
    }

    public static GunAnimations getGunAnimations(EntityLivingBase living, EnumHand hand) {
        GunAnimations animations;
        if (hand == EnumHand.OFF_HAND) {
            if (gunAnimationsLeft.containsKey(living)) {
                animations = gunAnimationsLeft.get(living);
            } else {
                animations = new GunAnimations();
                gunAnimationsLeft.put(living, animations);
            }
        } else if (gunAnimationsRight.containsKey(living)) {
            animations = gunAnimationsRight.get(living);
        } else {
            animations = new GunAnimations();
            gunAnimationsRight.put(living, animations);
        }
        return animations;
    }

    public static void addHitMarker() {
        hitMarkerTime = 20;
    }

    public static void updateFlashlights(Minecraft mc) {
        if (FlansMod.ticker % lightOverrideRefreshRate == 0 && mc.field_71441_e != null) {
            lightOverrideRefreshRate = mc.field_71474_y.field_74347_j ? 10 : 20;
            blockLightOverrides.forEach(blockPos -> mc.field_71441_e.func_180500_c(EnumSkyBlock.BLOCK, blockPos));
            blockLightOverrides.clear();
            for (EntityPlayer player : mc.field_71441_e.field_73010_i) {
                GunType type;
                AttachmentType grip;
                ItemStack currentHeldItem = player.func_184614_ca();
                if (!(currentHeldItem.func_77973_b() instanceof ItemGun) || (grip = (type = ((ItemGun)currentHeldItem.func_77973_b()).GetType()).getGrip(currentHeldItem)) == null || !grip.flashlight) continue;
                for (int i = 0; i < 2; ++i) {
                    RayTraceResult ray = player.func_174822_a((double)(grip.flashlightRange / 2.0f * (float)(i + 1)), 1.0f);
                    if (ray == null) continue;
                    int x = ray.func_178782_a().func_177958_n();
                    int y = ray.func_178782_a().func_177956_o();
                    int z = ray.func_178782_a().func_177952_p();
                    EnumFacing side = ray.field_178784_b;
                    switch (side) {
                        case DOWN: {
                            --y;
                            break;
                        }
                        case UP: {
                            ++y;
                            break;
                        }
                        case NORTH: {
                            --z;
                            break;
                        }
                        case SOUTH: {
                            ++z;
                            break;
                        }
                        case WEST: {
                            --x;
                            break;
                        }
                        case EAST: {
                            ++x;
                        }
                    }
                    BlockPos blockPos2 = new BlockPos(x, y, z);
                    blockLightOverrides.add(blockPos2);
                    FlansModClient.lightBlock(mc, blockPos2, 12);
                }
            }
            for (Entity entity : mc.field_71441_e.field_72996_f) {
                int z;
                int y;
                int x;
                if (entity instanceof EntityBullet) {
                    EntityBullet bullet = (EntityBullet)entity;
                    if (bullet.field_70128_L || !bullet.getFiredShot().getBulletType().hasLight) continue;
                    x = MathHelper.func_76128_c((double)bullet.field_70165_t);
                    y = MathHelper.func_76128_c((double)bullet.field_70163_u);
                    z = MathHelper.func_76128_c((double)bullet.field_70161_v);
                    BlockPos blockPos3 = new BlockPos(x, y, z);
                    blockLightOverrides.add(blockPos3);
                    FlansModClient.lightBlock(mc, blockPos3, 15);
                    continue;
                }
                if (!(entity instanceof EntityMecha)) continue;
                EntityMecha mecha = (EntityMecha)entity;
                x = MathHelper.func_76128_c((double)mecha.field_70165_t);
                y = MathHelper.func_76128_c((double)mecha.field_70163_u);
                z = MathHelper.func_76128_c((double)mecha.field_70161_v);
                if (mecha.lightLevel() > 0) {
                    BlockPos blockPos4 = new BlockPos(x, y, z);
                    int lightLevel = Math.max(mc.field_71441_e.func_175642_b(EnumSkyBlock.BLOCK, blockPos4), mecha.lightLevel());
                    blockLightOverrides.add(blockPos4);
                    FlansModClient.lightBlock(mc, blockPos4, lightLevel);
                }
                if (!mecha.forceDark()) continue;
                for (int i = -3; i <= 3; ++i) {
                    for (int j = -3; j <= 3; ++j) {
                        for (int k = -3; k <= 3; ++k) {
                            int xd = i + x;
                            int yd = j + y;
                            int zd = k + z;
                            BlockPos blockPos5 = new BlockPos(xd, yd, zd);
                            blockLightOverrides.add(blockPos5);
                            mc.field_71441_e.func_175653_a(EnumSkyBlock.SKY, blockPos5, Math.abs(i) + Math.abs(j) + Math.abs(k));
                        }
                    }
                }
            }
        }
    }

    private static void lightBlock(Minecraft mc, BlockPos blockPos, int lightValue) {
        mc.field_71441_e.func_175653_a(EnumSkyBlock.BLOCK, blockPos, lightValue);
        Vec3i diffVec = new Vec3i(1, 1, 1);
        BlockPos.func_177980_a((BlockPos)blockPos.func_177973_b(diffVec), (BlockPos)blockPos.func_177971_a(diffVec)).forEach(posToUpdate -> {
            if (!posToUpdate.equals((Object)blockPos)) {
                mc.field_71441_e.func_180500_c(EnumSkyBlock.BLOCK, posToUpdate);
            }
        });
    }

    static {
        gunAnimationsRight = new HashMap();
        gunAnimationsLeft = new HashMap();
        currentScope = null;
        zoomProgress = 0.0f;
        lastZoomProgress = 0.0f;
        lastZoomLevel = 1.0f;
        lastFOVZoomLevel = 1.0f;
        originalMouseSensitivity = 0.5f;
        originalFOV = 90.0f;
        originalThirdPerson = 0;
        inPlane = false;
        numVehicleExceptions = 0;
        hitMarkerTime = 0;
        blockLightOverrides = new ArrayList<BlockPos>();
        lightOverrideRefreshRate = 5;
        minecraft = FMLClientHandler.instance().getClient();
    }
}

