/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.gui.teams;

import com.flansmod.client.FlansModClient;
import com.flansmod.client.gui.teams.GuiTeamScores;
import com.flansmod.client.gui.teams.GuiTeamsBase;
import com.flansmod.client.teams.ClientTeamsData;
import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.network.PacketTeamInfo;
import com.flansmod.common.teams.LoadoutPool;
import com.flansmod.common.teams.PlayerRankData;
import com.flansmod.common.teams.RewardBox;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.FMLClientHandler;

public class GuiMissionResults
extends GuiTeamsBase {
    private static final ResourceLocation texture = new ResourceLocation("flansmod", "gui/MissionResults.png");
    private static final int WIDTH = 256;
    private static final int HEIGHT = 256;
    private static final int[] stateTimes = new int[]{0, 4, 4, 4, 4, 4, 20, 20, 5, 5, 5, 25, 0};
    private int timeInState = 0;
    private int displayRank;
    private int displayXP;
    private int earnedXP;
    private int targetRank;
    private int targetXP;
    private int lastXP;
    private boolean hasLevelledUp = false;
    private boolean hasDoneFinalLevelUp = false;
    private EnumResultsState state = EnumResultsState.IDLE;
    private MissionResultsUnlock[] unlocks = new MissionResultsUnlock[4];

    public GuiMissionResults() {
        PlayerRankData data = ClientTeamsData.theRankData;
        LoadoutPool pool = ClientTeamsData.currentPool;
        if (data == null || pool == null) {
            FlansMod.log.warn("Problem in mission results!");
            return;
        }
        this.state = EnumResultsState.SHOW_LINE_1_XP;
        this.displayRank = data.currentLevel;
        this.lastXP = this.displayXP = data.currentXP;
        this.earnedXP = data.pendingXP;
        this.targetXP = data.currentXP + data.pendingXP;
        this.targetRank = data.currentLevel;
        int XPForNextLevel = pool.GetXPForLevel(this.targetRank + 1);
        while (XPForNextLevel > 0 && this.targetXP >= XPForNextLevel) {
            this.targetXP -= XPForNextLevel;
            ++this.targetRank;
            XPForNextLevel = pool.GetXPForLevel(this.targetRank + 1);
        }
        this.hasLevelledUp = false;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        ScaledResolution scaledresolution = new ScaledResolution(this.field_146297_k);
        int w = scaledresolution.func_78326_a();
        int h = scaledresolution.func_78328_b();
        this.guiOriginX = w / 2 - 128;
        this.guiOriginY = h / 2 - 128;
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 - 128 + 214, this.field_146295_m / 2 - 128 + 6, 36, 20, "Done"));
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiTeamScores());
        }
    }

    public void func_73876_c() {
        PlayerRankData data = ClientTeamsData.theRankData;
        LoadoutPool pool = ClientTeamsData.currentPool;
        if (data == null || pool == null) {
            FlansMod.log.warn("Problem in mission results!");
            return;
        }
        ++this.timeInState;
        switch (this.state) {
            case IDLE: {
                break;
            }
            case SHOW_LINE_1_XP: 
            case SHOW_LINE_2_VICTORY_BONUS: 
            case SHOW_LINE_3: 
            case SHOW_LINE_4: 
            case SHOW_LINE_5_TOTAL: {
                if (this.timeInState <= stateTimes[this.state.ordinal()]) break;
                this.EnterState(EnumResultsState.values()[this.state.ordinal() + 1]);
                break;
            }
            case INCREASE_XP_BAR: {
                int currentTarget = this.targetXP;
                if (this.targetRank > this.displayRank) {
                    currentTarget = pool.GetXPForLevel(this.displayRank + 1);
                }
                this.displayXP = MathHelper.func_76141_d((float)((float)this.lastXP + (float)(currentTarget - this.lastXP) * (float)(this.timeInState - 1) / (float)stateTimes[this.state.ordinal()]));
                if (this.timeInState <= stateTimes[this.state.ordinal()]) break;
                if (this.targetRank > this.displayRank) {
                    this.EnterState(EnumResultsState.LEVEL_UP);
                    break;
                }
                this.EnterState(EnumResultsState.DONE);
                break;
            }
            case LEVEL_UP: 
            case REVEAL_UNLOCK1: 
            case REVEAL_UNLOCK2: 
            case REVEAL_UNLOCK3: {
                if (this.timeInState <= stateTimes[this.state.ordinal()]) break;
                this.EnterState(EnumResultsState.values()[this.state.ordinal() + 1]);
                break;
            }
            case REVEAL_UNLOCK4: {
                if (this.timeInState <= stateTimes[this.state.ordinal()]) break;
                this.EnterState(EnumResultsState.INCREASE_XP_BAR);
                break;
            }
            case DONE: {
                break;
            }
        }
    }

    private void EnterState(EnumResultsState newState) {
        PlayerRankData data = ClientTeamsData.theRankData;
        LoadoutPool pool = ClientTeamsData.currentPool;
        if (data == null || pool == null) {
            FlansMod.log.warn("Problem in mission results!");
            return;
        }
        this.state = newState;
        this.timeInState = 0;
        switch (this.state) {
            case INCREASE_XP_BAR: {
                this.lastXP = this.displayXP;
                break;
            }
            case LEVEL_UP: {
                ++this.displayRank;
                this.displayXP = 0;
                this.hasLevelledUp = true;
                for (int i = 0; i < 4; ++i) {
                    this.unlocks[i] = null;
                }
                int index = 0;
                for (ArrayList<LoadoutPool.LoadoutEntryInfoType> list : pool.unlocks) {
                    for (LoadoutPool.LoadoutEntryInfoType entry : list) {
                        if (index >= 4) continue;
                        boolean conflict = false;
                        for (int i = 0; i < index; ++i) {
                            if (!this.unlocks[i].isWeapon || this.unlocks[i].loadoutEntry == null || !this.unlocks[i].loadoutEntry.type.shortName.equals(entry.type.shortName)) continue;
                            conflict = true;
                        }
                        if (conflict || entry.unlockLevel != this.displayRank) continue;
                        this.unlocks[index] = new MissionResultsUnlock();
                        this.unlocks[index].isWeapon = true;
                        this.unlocks[index].loadoutEntry = entry;
                        ++index;
                    }
                }
                for (RewardBox box : pool.rewardsPerLevel[this.displayRank - 1]) {
                    this.unlocks[index] = new MissionResultsUnlock();
                    this.unlocks[index].isWeapon = false;
                    this.unlocks[index].rewardBox = box;
                    ++index;
                }
                break;
            }
            case REVEAL_UNLOCK4: {
                if (this.displayRank != this.targetRank) break;
                this.hasDoneFinalLevelUp = true;
                break;
            }
        }
    }

    @Override
    public void func_73863_a(int i, int j, float f) {
        PacketTeamInfo teamInfo = FlansModClient.teamInfo;
        if (teamInfo == null || teamInfo.gametype == null || teamInfo.gametype.equals("") || teamInfo.teamData == null || teamInfo.teamData.length < 1 || !teamInfo.roundOver()) {
            this.field_146297_k.func_147108_a(null);
            return;
        }
        ScaledResolution scaledresolution = new ScaledResolution(this.field_146297_k);
        int w = scaledresolution.func_78326_a();
        int h = scaledresolution.func_78328_b();
        this.func_146276_q_();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.guiOriginX = w / 2 - 128;
        this.guiOriginY = h / 2 - 128;
        this.field_146297_k.field_71446_o.func_110577_a(texture);
        int textureX = 512;
        int textureY = 256;
        PlayerRankData data = ClientTeamsData.theRankData;
        LoadoutPool pool = ClientTeamsData.currentPool;
        if (data == null || pool == null) {
            FlansMod.log.warn("Problem in mission results!");
            return;
        }
        GuiMissionResults.func_146110_a((int)this.guiOriginX, (int)this.guiOriginY, (float)0.0f, (float)0.0f, (int)256, (int)256, (float)textureX, (float)textureY);
        int XPForNextLevel = pool.GetXPForLevel(this.displayRank + 1);
        float XPProgress = 0.0f;
        XPProgress = XPForNextLevel > 0 ? (float)this.displayXP / (float)XPForNextLevel : 1.0f;
        XPProgress = MathHelper.func_76131_a((float)XPProgress, (float)0.0f, (float)1.0f);
        GuiMissionResults.func_146110_a((int)(this.guiOriginX + 7), (int)(this.guiOriginY + 109), (float)259.0f, (float)109.0f, (int)((int)(242.0f * XPProgress)), (int)10, (float)textureX, (float)textureY);
        if (this.state.ordinal() >= EnumResultsState.LEVEL_UP.ordinal() && this.state.ordinal() <= EnumResultsState.REVEAL_UNLOCK4.ordinal()) {
            GuiMissionResults.func_146110_a((int)(this.guiOriginX + 5), (int)(this.guiOriginY + 120), (float)266.0f, (float)120.0f, (int)246, (int)38, (float)textureX, (float)textureY);
        }
        if (XPForNextLevel > 0) {
            this.func_73732_a(this.field_146289_q, this.displayXP + " / " + XPForNextLevel, this.guiOriginX + 128, this.guiOriginY + 110, 0xFFFFFF);
        } else {
            this.func_73732_a(this.field_146289_q, "" + this.displayXP, this.guiOriginX + 128, this.guiOriginY + 110, 0xFFFFFF);
        }
        this.func_73731_b(this.field_146289_q, ClientTeamsData.timeLeftInStage / 20 + "", this.guiOriginX + 12, this.guiOriginY + 12, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, "ROUND OVER", this.guiOriginX + 128, this.guiOriginY + 12, 0xFFFFFF);
        if (this.state.ordinal() >= EnumResultsState.LEVEL_UP.ordinal() && this.state.ordinal() <= EnumResultsState.REVEAL_UNLOCK4.ordinal()) {
            this.func_73732_a(this.field_146289_q, "RANK INCREASED", this.guiOriginX + 128, this.guiOriginY + 135, 0xFFFFFF);
        } else {
            this.func_73731_b(this.field_146289_q, "Rank " + this.displayRank, this.guiOriginX + 44, this.guiOriginY + 135, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, "Next Rank", this.guiOriginX + 163, this.guiOriginY + 135, 0xFFFFFF);
        }
        if (this.state.ordinal() >= EnumResultsState.SHOW_LINE_1_XP.ordinal()) {
            this.func_73731_b(this.field_146289_q, "XP Earned: ", this.guiOriginX + 11, this.guiOriginY + 31, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, "" + this.earnedXP, this.guiOriginX + 244 - this.field_146289_q.func_78256_a("" + this.earnedXP), this.guiOriginY + 31, 0xFFFFFF);
        }
        if (this.state.ordinal() >= EnumResultsState.SHOW_LINE_2_VICTORY_BONUS.ordinal()) {
            this.func_73731_b(this.field_146289_q, "", this.guiOriginX + 11, this.guiOriginY + 41, 0xFFFFFF);
        }
        if (this.state.ordinal() >= EnumResultsState.SHOW_LINE_3.ordinal()) {
            this.func_73731_b(this.field_146289_q, "", this.guiOriginX + 11, this.guiOriginY + 51, 0xFFFFFF);
        }
        if (this.state.ordinal() >= EnumResultsState.SHOW_LINE_4.ordinal()) {
            this.func_73731_b(this.field_146289_q, "", this.guiOriginX + 11, this.guiOriginY + 61, 0xFFFFFF);
        }
        if (this.state.ordinal() >= EnumResultsState.SHOW_LINE_5_TOTAL.ordinal()) {
            this.func_73731_b(this.field_146289_q, "Total: ", this.guiOriginX + 11, this.guiOriginY + 91, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, "" + this.earnedXP, this.guiOriginX + 244 - this.field_146289_q.func_78256_a("" + this.earnedXP), this.guiOriginY + 91, 0xFFFFFF);
        }
        this.DrawRankIcon(this.displayRank, 0, 8, 123, true);
        if (this.displayRank < pool.maxLevel) {
            this.DrawRankIcon(this.displayRank + 1, 0, 216, 123, true);
        }
        boolean hasDoneFinalLevel = this.hasDoneFinalLevelUp;
        if (this.state.ordinal() >= EnumResultsState.REVEAL_UNLOCK1.ordinal() || hasDoneFinalLevel) {
            this.DrawUnlock(this.unlocks[0], this.guiOriginX + 8, this.guiOriginY + 160);
        }
        if (this.state.ordinal() >= EnumResultsState.REVEAL_UNLOCK2.ordinal() || hasDoneFinalLevel) {
            this.DrawUnlock(this.unlocks[1], this.guiOriginX + 131, this.guiOriginY + 160);
        }
        if (this.state.ordinal() >= EnumResultsState.REVEAL_UNLOCK3.ordinal() || hasDoneFinalLevel) {
            this.DrawUnlock(this.unlocks[2], this.guiOriginX + 8, this.guiOriginY + 207);
        }
        if (this.state.ordinal() >= EnumResultsState.REVEAL_UNLOCK4.ordinal() || hasDoneFinalLevel) {
            this.DrawUnlock(this.unlocks[3], this.guiOriginX + 131, this.guiOriginY + 207);
        }
        super.func_73863_a(i, j, f);
    }

    private void DrawUnlock(MissionResultsUnlock entry, int i, int j) {
        if (entry == null) {
            return;
        }
        if (entry.isWeapon) {
            this.func_73732_a(this.field_146289_q, "New item unlocked", i + 58, j + 2, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, entry.loadoutEntry.type.name, i + 58, j + 31, 0xFFFFFF);
            if (entry.loadoutEntry.type instanceof GunType) {
                this.DrawGun(new ItemStack(entry.loadoutEntry.type.getItem()), i + 50, j + 24, 25.0f);
            } else {
                this.drawSlotInventory(new ItemStack(entry.loadoutEntry.type.getItem()), i + 49, j + 12);
            }
        } else {
            this.func_73732_a(this.field_146289_q, "Reward obtained", i + 58, j + 2, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, entry.rewardBox.name, i + 58, j + 31, 0xFFFFFF);
            this.drawSlotInventory(new ItemStack(entry.rewardBox.getItem()), i + 49, j + 12);
        }
    }

    @Override
    public boolean func_73868_f() {
        return false;
    }

    private static class MissionResultsUnlock {
        public boolean isWeapon = true;
        public LoadoutPool.LoadoutEntryInfoType loadoutEntry = null;
        public RewardBox rewardBox = null;

        private MissionResultsUnlock() {
        }
    }

    private static enum EnumResultsState {
        IDLE,
        SHOW_LINE_1_XP,
        SHOW_LINE_2_VICTORY_BONUS,
        SHOW_LINE_3,
        SHOW_LINE_4,
        SHOW_LINE_5_TOTAL,
        INCREASE_XP_BAR,
        LEVEL_UP,
        REVEAL_UNLOCK1,
        REVEAL_UNLOCK2,
        REVEAL_UNLOCK3,
        REVEAL_UNLOCK4,
        DONE;

    }
}

