/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables;

import com.flansmod.client.model.ModelVehicle;
import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.DriveableData;
import com.flansmod.common.driveables.DriveablePart;
import com.flansmod.common.driveables.DriveablePosition;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EntityVehicle;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.parts.PartType;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.TypeFile;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class VehicleType
extends DriveableType {
    public float turnLeftModifier = 1.0f;
    public float turnRightModifier = 1.0f;
    public boolean squashMobs = false;
    public boolean fourWheelDrive = false;
    public boolean rotateWheels = false;
    public boolean tank = false;
    public boolean hasDoor = false;
    public int trackLinkFix = 5;
    public boolean flipLinkFix = false;
    public static ArrayList<VehicleType> types = new ArrayList();
    private static HashMap<String, InfoType.ParseFunc<VehicleType>> parsers = new HashMap();

    public VehicleType(TypeFile file) {
        super(file);
        types.add(this);
    }

    @Override
    public void preRead(TypeFile file) {
        super.preRead(file);
        this.wheelPositions = new DriveablePosition[4];
    }

    @Override
    protected void read(String[] split, TypeFile file) {
        try {
            InfoType.ParseFunc<VehicleType> parser = parsers.get(split[0]);
            if (parser != null) {
                parser.Parse(split, this);
            } else {
                super.read(split, file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public ArrayList<ItemStack> getItemsRequired(DriveablePart part, PartType engine) {
        ArrayList<ItemStack> stacks = super.getItemsRequired(part, engine);
        if (EnumDriveablePart.core == part.type) {
            stacks.add(new ItemStack(engine.item));
        }
        return stacks;
    }

    public static VehicleType getVehicle(String find) {
        for (VehicleType type : types) {
            if (!type.shortName.equals(find)) continue;
            return type;
        }
        return null;
    }

    @Override
    public void reloadModel() {
        this.model = FlansMod.proxy.loadModel(this.modelString, this.shortName, ModelVehicle.class);
    }

    @Override
    public EntityDriveable createDriveable(World world, double x, double y, double z, DriveableData data) {
        return new EntityVehicle(world, x, y, z, this, data);
    }

    static {
        parsers.put("SquashMobs", (split, d) -> {
            d.squashMobs = Boolean.parseBoolean(split[1]);
        });
        parsers.put("FourWheelDrive", (split, d) -> {
            d.fourWheelDrive = Boolean.parseBoolean(split[1]);
        });
        parsers.put("Tank", (split, d) -> {
            d.tank = Boolean.parseBoolean(split[1]);
        });
        parsers.put("TankMode", (split, d) -> {
            d.tank = Boolean.parseBoolean(split[1]);
        });
        parsers.put("HasDoor", (split, d) -> {
            d.hasDoor = Boolean.parseBoolean(split[1]);
        });
        parsers.put("RotateWheels", (split, d) -> {
            d.rotateWheels = Boolean.parseBoolean(split[1]);
        });
        parsers.put("TurnLeftSpeed", (split, d) -> {
            d.turnLeftModifier = Float.parseFloat(split[1]);
        });
        parsers.put("TurnRightSpeed", (split, d) -> {
            d.turnRightModifier = Float.parseFloat(split[1]);
        });
        parsers.put("ShootDelay", (split, d) -> {
            d.shootDelaySecondary = Integer.parseInt(split[1]);
        });
        parsers.put("ShellDelay", (split, d) -> {
            d.shootDelayPrimary = Integer.parseInt(split[1]);
        });
        parsers.put("ShellSound", (split, d) -> {
            d.shootSoundSecondary = split[1];
            FlansMod.proxy.loadSound(d.contentPack, "driveables", split[1]);
        });
        parsers.put("ShootSound", (split, d) -> {
            d.shootSoundPrimary = split[1];
            FlansMod.proxy.loadSound(d.contentPack, "driveables", split[1]);
        });
    }
}

