/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables.collisions;

import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.driveables.collisions.CollisionPlane;
import com.flansmod.common.vector.Vector3f;

public class CollisionTest {
    public Vector3f eRad;
    public Vector3f R3Velocity;
    public Vector3f R3Position;
    public Vector3f velocity;
    public Vector3f normalisedVelocity;
    public Vector3f basePoint;
    public boolean didCollide;
    public double nearestDistance;
    public Vector3f intersectionPoint;
    public int collisionRecursiveDepth;
    public boolean isOnTop = false;
    public Vector3f collisionPlaneNormal;
    public EnumDriveablePart part;

    public CollisionTest(Vector3f ellipsoid, Vector3f origin, Vector3f motion) {
        this.eRad = ellipsoid;
        this.R3Velocity = motion;
        this.R3Position = origin;
        this.velocity = this.ConvertR3ToESpace(motion);
        this.normalisedVelocity = this.velocity.normalise(this.normalisedVelocity);
        this.basePoint = origin;
    }

    public void checkTriangle(CollisionTest test, Vector3f p1, Vector3f p2, Vector3f p3) {
        CollisionPlane trianglePlane = new CollisionPlane(p1, p2, p3);
        if (trianglePlane.isFrontFacingTo(test.normalisedVelocity)) {
            Vector3f baseSubNormal;
            Vector3f planeIntersectionPoint;
            double t0;
            boolean embeddedInPlane = false;
            double signedDistToTrianglePlane = trianglePlane.signedDistanceTo(test.basePoint);
            float normalDotVelocity = Vector3f.dot(trianglePlane.normal, test.velocity);
            if (normalDotVelocity == 0.0f) {
                if (Math.abs(signedDistToTrianglePlane) >= 1.0) {
                    return;
                }
                embeddedInPlane = true;
                t0 = 0.0;
                double t1 = 1.0;
            } else {
                t0 = (-1.0 - signedDistToTrianglePlane) / (double)normalDotVelocity;
                double t1 = (1.0 - signedDistToTrianglePlane) / (double)normalDotVelocity;
                if (t0 > t1) {
                    double temp = t1;
                    t1 = t0;
                    t0 = temp;
                }
                if (t0 > 1.0 || t1 < 0.0) {
                    return;
                }
                if (t0 < 0.0) {
                    t0 = 0.0;
                }
                if (t1 < 0.0) {
                    t1 = 0.0;
                }
                if (t0 > 1.0) {
                    t0 = 1.0;
                }
                if (t1 > 1.0) {
                    t1 = 1.0;
                }
            }
            Vector3f collisionPoint = new Vector3f(0.0f, 0.0f, 0.0f);
            boolean foundCollision = false;
            float t = 1.0f;
            if (!embeddedInPlane && this.checkPointInTriangle(planeIntersectionPoint = Vector3f.add(baseSubNormal = Vector3f.sub(this.basePoint, trianglePlane.normal, null), new Vector3f(t0 * (double)test.velocity.x, t0 * (double)test.velocity.y, t0 * (double)test.velocity.z), null), p1, p2, p3)) {
                foundCollision = true;
                t = (float)t0;
                collisionPoint = planeIntersectionPoint;
            }
            if (!foundCollision) {
                float newT;
                float f;
                Vector3f baseSubP3;
                Vector3f baseSubP2;
                float c;
                Vector3f baseSubP1;
                float b;
                Vector3f velocity = test.velocity;
                Vector3f base = test.basePoint;
                float velocitySquaredLength = velocity.lengthSquared();
                float a = velocitySquaredLength;
                if (this.getLowestRoot(a, b = 2.0f * Vector3f.dot(velocity, baseSubP1 = Vector3f.sub(base, p1, null)), c = baseSubP1.lengthSquared() - 1.0f, t) != 1.2345679E8f) {
                    t = this.getLowestRoot(a, b, c, t);
                    foundCollision = true;
                    collisionPoint = p1;
                }
                if (this.getLowestRoot(a, b = 2.0f * Vector3f.dot(velocity, baseSubP2 = Vector3f.sub(base, p2, null)), c = baseSubP2.lengthSquared(), t) != 1.2345679E8f) {
                    t = this.getLowestRoot(a, b, c, t);
                    foundCollision = true;
                    collisionPoint = p2;
                }
                if (this.getLowestRoot(a, b = 2.0f * Vector3f.dot(velocity, baseSubP3 = Vector3f.sub(base, p3, null)), c = baseSubP3.lengthSquared(), t) != 1.2345679E8f) {
                    t = this.getLowestRoot(a, b, c, t);
                    foundCollision = true;
                    collisionPoint = p3;
                }
                Vector3f edge = Vector3f.sub(p2, p1, null);
                Vector3f baseToVertex = Vector3f.sub(p1, base, null);
                float edgeSquaredLength = edge.lengthSquared();
                float edgeDotVelocity = Vector3f.dot(edge, velocity);
                float edgeDotBaseToVertex = Vector3f.dot(edge, baseToVertex);
                a = edgeSquaredLength * -velocitySquaredLength + edgeDotVelocity * edgeDotVelocity;
                b = edgeSquaredLength * (2.0f * Vector3f.dot(velocity, baseToVertex)) - 2.0f * edgeDotVelocity * edgeDotBaseToVertex;
                if (this.getLowestRoot(a, b, c = edgeSquaredLength * (1.0f - baseToVertex.lengthSquared()) + edgeDotBaseToVertex * edgeDotBaseToVertex, t) != 1.2345679E8f && (double)(f = (edgeDotVelocity * (newT = this.getLowestRoot(a, b, c, t)) - edgeDotBaseToVertex) / edgeSquaredLength) >= 0.0 && (double)f <= 1.0) {
                    t = newT;
                    foundCollision = true;
                    collisionPoint = Vector3f.add(p1, new Vector3f(f * edge.x, f * edge.y, f * edge.z), null);
                }
                edge = Vector3f.sub(p3, p2, null);
                baseToVertex = Vector3f.sub(p2, base, null);
                edgeSquaredLength = edge.lengthSquared();
                edgeDotVelocity = Vector3f.dot(edge, velocity);
                edgeDotBaseToVertex = Vector3f.dot(edge, baseToVertex);
                a = edgeSquaredLength * -velocitySquaredLength + edgeDotVelocity * edgeDotVelocity;
                b = edgeSquaredLength * (2.0f * Vector3f.dot(velocity, baseToVertex)) - 2.0f * edgeDotVelocity * edgeDotBaseToVertex;
                if (this.getLowestRoot(a, b, c = edgeSquaredLength * (1.0f - baseToVertex.lengthSquared()) + edgeDotBaseToVertex * edgeDotBaseToVertex, t) != 1.2345679E8f && (double)(f = (edgeDotVelocity * (newT = this.getLowestRoot(a, b, c, t)) - edgeDotBaseToVertex) / edgeSquaredLength) >= 0.0 && (double)f <= 1.0) {
                    t = newT;
                    foundCollision = true;
                    collisionPoint = Vector3f.add(p2, new Vector3f(f * edge.x, f * edge.y, f * edge.z), null);
                }
                edge = Vector3f.sub(p1, p3, null);
                baseToVertex = Vector3f.sub(p3, base, null);
                edgeSquaredLength = edge.lengthSquared();
                edgeDotVelocity = Vector3f.dot(edge, velocity);
                edgeDotBaseToVertex = Vector3f.dot(edge, baseToVertex);
                a = edgeSquaredLength * -velocitySquaredLength + edgeDotVelocity * edgeDotVelocity;
                b = edgeSquaredLength * (2.0f * Vector3f.dot(velocity, baseToVertex)) - 2.0f * edgeDotVelocity * edgeDotBaseToVertex;
                if (this.getLowestRoot(a, b, c = edgeSquaredLength * (1.0f - baseToVertex.lengthSquared()) + edgeDotBaseToVertex * edgeDotBaseToVertex, t) != 1.2345679E8f && (double)(f = (edgeDotVelocity * (newT = this.getLowestRoot(a, b, c, t)) - edgeDotBaseToVertex) / edgeSquaredLength) >= 0.0 && (double)f <= 1.0) {
                    t = newT;
                    foundCollision = true;
                    collisionPoint = Vector3f.add(p3, new Vector3f(f * edge.x, f * edge.y, f * edge.z), null);
                }
            }
            if (foundCollision) {
                float distToCollision = t * test.velocity.length();
                if (!test.didCollide || (double)distToCollision < test.nearestDistance) {
                    test.nearestDistance = distToCollision;
                    test.intersectionPoint = collisionPoint;
                    test.didCollide = true;
                }
            }
        }
    }

    public float getLowestRoot(float a, float b, float c, float maxR) {
        float r2;
        float determinant = b * b - 4.0f * a * c;
        if (determinant < 0.0f) {
            return 1.2345679E8f;
        }
        float sqrtD = (float)Math.sqrt(determinant);
        float r1 = (-b - sqrtD) / (2.0f * a);
        if (r1 > (r2 = (-b + sqrtD) / (2.0f * a))) {
            float temp = r2;
            r2 = r1;
            r1 = temp;
        }
        if (r1 > 0.0f && r1 < maxR) {
            return r1;
        }
        if (r2 > 0.0f && r2 < maxR) {
            return r2;
        }
        return 1.2345679E8f;
    }

    public boolean checkPointInTriangle(Vector3f point, Vector3f p1, Vector3f p2, Vector3f p3) {
        float y;
        float e;
        Vector3f edge1 = Vector3f.sub(p2, p1, null);
        Vector3f edge2 = Vector3f.sub(p3, p1, null);
        float a = Vector3f.dot(edge1, edge1);
        float b = Vector3f.dot(edge1, edge2);
        float c = Vector3f.dot(edge2, edge2);
        float acSUBbb = a * c - b * b;
        Vector3f vp = new Vector3f(point.x - p1.x, point.y - p1.y, point.z - p1.z);
        float d = Vector3f.dot(vp, edge1);
        float x = d * c - (e = Vector3f.dot(vp, edge2)) * b;
        float z = x + (y = e * a - d * b) - acSUBbb;
        return z < 0.0f && x >= 0.0f && y >= 0.0f;
    }

    public Vector3f ConvertR3ToESpace(Vector3f r3) {
        return new Vector3f(1.0f / this.eRad.x * r3.x, 1.0f / this.eRad.y * r3.y, 1.0f / this.eRad.z * r3.z);
    }

    public Vector3f ConvertESpaceToR3(Vector3f esp) {
        return new Vector3f(esp.x / (1.0f / this.eRad.x), esp.y / (1.0f / this.eRad.y), esp.z / (1.0f / this.eRad.z));
    }
}

