/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns;

import com.flansmod.client.model.ModelDefaultMuzzleFlash;
import com.flansmod.client.model.ModelGun;
import com.flansmod.client.model.ModelMG;
import com.flansmod.client.model.ModelMuzzleFlash;
import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.AttachmentType;
import com.flansmod.common.guns.EnumFireMode;
import com.flansmod.common.guns.EnumSecondaryFunction;
import com.flansmod.common.guns.EnumSpreadPattern;
import com.flansmod.common.guns.IScope;
import com.flansmod.common.guns.ItemBullet;
import com.flansmod.common.guns.ItemGrenade;
import com.flansmod.common.guns.ShootableType;
import com.flansmod.common.paintjob.PaintableType;
import com.flansmod.common.types.TypeFile;
import com.flansmod.common.vector.Vector3f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GunType
extends PaintableType
implements IScope {
    public List<ShootableType> ammo = new ArrayList<ShootableType>();
    public List<ShootableType> nonExplosiveAmmo = new ArrayList<ShootableType>();
    public boolean canForceReload = true;
    public int reloadTime;
    public int recoil;
    public float bulletSpread;
    public EnumSpreadPattern spreadPattern = EnumSpreadPattern.cube;
    public float damage = 0.0f;
    public float meleeDamage = 1.0f;
    public float bulletSpeed = 0.0f;
    public int numBullets = 1;
    public float shootDelay = 1.0f;
    public int numAmmoItemsInGun = 1;
    public EnumFireMode mode = EnumFireMode.FULLAUTO;
    public int numBurstRounds = 3;
    public float minigunStartSpeed = 15.0f;
    public float minigunMaxSpeed = 30.0f;
    public boolean canShootUnderwater = true;
    public float knockback = 0.0f;
    public EnumSecondaryFunction secondaryFunction = EnumSecondaryFunction.ADS_ZOOM;
    public boolean oneHanded = false;
    public boolean consumeGunUponUse = false;
    public String dropItemOnShoot = null;
    public int meleeTime = 1;
    public ArrayList<Vector3f> meleePath = new ArrayList();
    public ArrayList<Vector3f> meleePathAngles = new ArrayList();
    public ArrayList<Vector3f> meleeDamagePoints = new ArrayList();
    public boolean usableByPlayers = true;
    public boolean usableByMechas = true;
    public boolean showAttachments = true;
    public boolean showDamage = false;
    public boolean showRecoil = false;
    public boolean showSpread = false;
    public boolean showReloadTime = false;
    public boolean shield = false;
    public Vector3f shieldOrigin;
    public Vector3f shieldDimensions;
    public float shieldDamageAbsorption = 0.0f;
    public String shootSound;
    public int shootSoundLength;
    public boolean distortSound = true;
    public String reloadSound;
    public boolean useLoopingSounds = false;
    public String warmupSound;
    public int warmupSoundLength = 20;
    public String loopedSound;
    public int loopedSoundLength = 20;
    public String cooldownSound;
    public String meleeSound;
    public String idleSound;
    public int idleSoundLength;
    public boolean deployable = false;
    @SideOnly(value=Side.CLIENT)
    public ModelMG deployableModel;
    @SideOnly(value=Side.CLIENT)
    public ModelMuzzleFlash muzzleFlashModel;
    public String deployableTexture;
    public float standBackDist = 1.5f;
    public float topViewLimit = -60.0f;
    public float bottomViewLimit = 30.0f;
    public float sideViewLimit = 45.0f;
    public float pivotHeight = 0.375f;
    public String defaultScopeTexture;
    public boolean hasScopeOverlay = false;
    public float zoomLevel = 1.0f;
    public float FOVFactor = 1.5f;
    public ModelGun model;
    public boolean allowAllAttachments = false;
    public ArrayList<AttachmentType> allowedAttachments = new ArrayList();
    public boolean allowBarrelAttachments = false;
    public boolean allowScopeAttachments = false;
    public boolean allowStockAttachments = false;
    public boolean allowGripAttachments = false;
    public int numGenericAttachmentSlots = 0;
    public static HashMap<Integer, GunType> guns = new HashMap();
    public static ArrayList<GunType> gunList = new ArrayList();
    public float moveSpeedModifier = 1.0f;
    public float knockbackModifier = 0.0f;

    public GunType(TypeFile file) {
        super(file);
    }

    @Override
    public void postRead(TypeFile file) {
        super.postRead(file);
        gunList.add(this);
        guns.put(this.shortName.hashCode(), this);
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.checkMF();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void checkMF() {
        if (this.muzzleFlashModel == null) {
            this.muzzleFlashModel = new ModelDefaultMuzzleFlash();
        }
    }

    @Override
    protected void read(String[] split, TypeFile file) {
        super.read(split, file);
        try {
            this.damage = this.Read(split, "Damage", this.damage);
            this.canForceReload = this.Read(split, "CanForceReload", this.canForceReload);
            this.reloadTime = this.Read(split, "ReloadTime", this.reloadTime);
            this.recoil = this.Read(split, "Recoil", this.recoil);
            this.knockback = this.Read(split, "Knockback", this.knockback);
            this.bulletSpread = this.Read(split, "Accuracy", this.bulletSpread);
            this.bulletSpread = this.Read(split, "Spread", this.bulletSpread);
            this.numBullets = this.Read(split, "NumBullets", this.numBullets);
            this.consumeGunUponUse = this.Read(split, "ConsumeGunOnUse", this.consumeGunUponUse);
            this.dropItemOnShoot = this.Read(split, "DropItemOnShoot", this.dropItemOnShoot);
            this.numBurstRounds = this.Read(split, "NumBurstRounds", this.numBurstRounds);
            this.minigunStartSpeed = this.Read(split, "MinigunStartSpeed", this.minigunStartSpeed);
            if (split[0].equals("MeleeDamage")) {
                this.meleeDamage = Float.parseFloat(split[1]);
                if (this.meleeDamage > 0.0f) {
                    this.secondaryFunction = EnumSecondaryFunction.MELEE;
                }
            }
            this.showAttachments = this.Read(split, "ShowAttachments", this.showAttachments);
            this.showDamage = this.Read(split, "ShowDamage", this.showDamage);
            this.showRecoil = this.Read(split, "ShowRecoil", this.showRecoil);
            this.showSpread = this.Read(split, "ShowAccuracy", this.showSpread);
            this.showReloadTime = this.Read(split, "ShowReloadTime", this.showReloadTime);
            this.shootDelay = this.Read(split, "ShootDelay", this.shootDelay);
            this.shootSoundLength = this.Read(split, "SoundLength", this.shootSoundLength);
            this.distortSound = this.Read(split, "DistortSound", this.distortSound);
            this.idleSoundLength = this.Read(split, "IdleSoundLength", this.idleSoundLength);
            this.warmupSoundLength = this.Read(split, "WarmupSoundLength", this.warmupSoundLength);
            this.loopedSoundLength = this.Read(split, "LoopedSoundLength", this.loopedSoundLength);
            this.loopedSoundLength = this.Read(split, "SpinSoundLength", this.loopedSoundLength);
            if (split[0].equals("ShootSound")) {
                this.shootSound = split[1];
                FlansMod.proxy.loadSound(this.contentPack, "guns", split[1]);
            } else if (split[0].equals("ReloadSound")) {
                this.reloadSound = split[1];
                FlansMod.proxy.loadSound(this.contentPack, "guns", split[1]);
            } else if (split[0].equals("IdleSound")) {
                this.idleSound = split[1];
                FlansMod.proxy.loadSound(this.contentPack, "guns", split[1]);
            } else if (split[0].equals("MeleeSound")) {
                this.meleeSound = split[1];
                FlansMod.proxy.loadSound(this.contentPack, "guns", split[1]);
            } else if (split[0].equals("WarmupSound")) {
                this.warmupSound = split[1];
                FlansMod.proxy.loadSound(this.contentPack, "guns", split[1]);
            } else if (split[0].equals("LoopedSound") || split[0].equals("SpinSound")) {
                this.loopedSound = split[1];
                this.useLoopingSounds = true;
                FlansMod.proxy.loadSound(this.contentPack, "guns", split[1]);
            } else if (split[0].equals("CooldownSound")) {
                this.cooldownSound = split[1];
                FlansMod.proxy.loadSound(this.contentPack, "guns", split[1]);
            } else if (split[0].equals("Mode")) {
                this.mode = EnumFireMode.getFireMode(split[1]);
            } else if (split[0].equals("Scope")) {
                this.hasScopeOverlay = true;
                if (split[1].equals("None")) {
                    this.hasScopeOverlay = false;
                } else {
                    this.defaultScopeTexture = split[1];
                }
            } else if (split[0].equals("ZoomLevel")) {
                this.zoomLevel = Float.parseFloat(split[1]);
                if (this.zoomLevel > 1.0f) {
                    this.secondaryFunction = EnumSecondaryFunction.ZOOM;
                }
            } else if (split[0].equals("FOVZoomLevel")) {
                this.FOVFactor = Float.parseFloat(split[1]);
                if (this.FOVFactor > 1.0f) {
                    this.secondaryFunction = EnumSecondaryFunction.ADS_ZOOM;
                }
            } else if (split[0].equals("Deployable")) {
                this.deployable = split[1].equals("True");
            } else if (FMLCommonHandler.instance().getSide().isClient() && this.deployable && split[0].equals("DeployedModel")) {
                this.deployableModel = FlansMod.proxy.loadModel(split[1], this.shortName, ModelMG.class);
            } else if (FMLCommonHandler.instance().getSide().isClient() && split[0].equals("Model")) {
                this.model = FlansMod.proxy.loadModel(split[1], this.shortName, ModelGun.class);
            } else if (FMLCommonHandler.instance().getSide().isClient() && split[0].equals("MuzzleFlashModel")) {
                this.muzzleFlashModel = FlansMod.proxy.loadModel(split[1], this.shortName, ModelMuzzleFlash.class);
            }
            this.deployableTexture = this.Read(split, "DeployedTexture", this.deployableTexture);
            this.standBackDist = this.Read(split, "StandBackDistance", this.standBackDist);
            this.topViewLimit = this.Read(split, "TopViewLimit", this.topViewLimit);
            this.bottomViewLimit = this.Read(split, "BottomViewLimit", this.bottomViewLimit);
            this.sideViewLimit = this.Read(split, "SideViewLimit", this.sideViewLimit);
            this.pivotHeight = this.Read(split, "PivotHeight", this.pivotHeight);
            this.numAmmoItemsInGun = this.Read(split, "NumAmmoSlots", this.numAmmoItemsInGun);
            this.numAmmoItemsInGun = this.Read(split, "NumAmmoItemsInGun", this.numAmmoItemsInGun);
            this.numAmmoItemsInGun = this.Read(split, "LoadIntoGun", this.numAmmoItemsInGun);
            this.canShootUnderwater = this.Read(split, "CanShootUnderwater", this.canShootUnderwater);
            this.oneHanded = this.Read(split, "OneHanded", this.oneHanded);
            this.usableByPlayers = this.Read(split, "UsableByPlayers", this.usableByPlayers);
            this.usableByMechas = this.Read(split, "UsableByMechas", this.usableByMechas);
            if (split[0].equals("SpreadPattern")) {
                this.spreadPattern = EnumSpreadPattern.get(split[1]);
            }
            if (split[0].equals("Ammo")) {
                ShootableType type = ShootableType.getShootableType(split[1]);
                if (type != null) {
                    this.ammo.add(type);
                    if (type.explosionRadius <= 0.0f) {
                        this.nonExplosiveAmmo.add(type);
                    }
                }
            } else if (split[0].equals("BulletSpeed")) {
                this.bulletSpeed = split[1].toLowerCase().equals("instant") ? 0.0f : Float.parseFloat(split[1]);
                if (this.bulletSpeed > 3.0f) {
                    this.bulletSpeed = 0.0f;
                }
            } else if (split[0].equals("SecondaryFunction")) {
                this.secondaryFunction = EnumSecondaryFunction.get(split[1]);
            } else if (split[0].equals("UseCustomMelee") && Boolean.parseBoolean(split[1])) {
                this.secondaryFunction = EnumSecondaryFunction.CUSTOM_MELEE;
            }
            this.meleeTime = this.Read(split, "MeleeTime", this.meleeTime);
            if (split[0].equals("AddNode")) {
                this.meleePath.add(new Vector3f(Float.parseFloat(split[1]) / 16.0f, Float.parseFloat(split[2]) / 16.0f, Float.parseFloat(split[3]) / 16.0f));
                this.meleePathAngles.add(new Vector3f(Float.parseFloat(split[4]), Float.parseFloat(split[5]), Float.parseFloat(split[6])));
            } else if (split[0].equals("MeleeDamagePoint") || split[0].equals("MeleeDamageOffset")) {
                this.meleeDamagePoints.add(new Vector3f(Float.parseFloat(split[1]) / 16.0f, Float.parseFloat(split[2]) / 16.0f, Float.parseFloat(split[3]) / 16.0f));
            }
            this.moveSpeedModifier = this.Read(split, "MoveSpeedModifier", this.moveSpeedModifier);
            this.moveSpeedModifier = this.Read(split, "Slowness", this.moveSpeedModifier);
            this.knockbackModifier = this.Read(split, "KnockbackReduction", this.knockbackModifier);
            this.knockbackModifier = this.Read(split, "KnockbackModifier", this.knockbackModifier);
            this.allowAllAttachments = this.Read(split, "AllowAllAttachments", this.allowAllAttachments);
            if (split[0].equals("AllowAttachments")) {
                for (int i = 1; i < split.length; ++i) {
                    this.allowedAttachments.add(AttachmentType.getAttachment(split[i]));
                }
            }
            this.allowBarrelAttachments = this.Read(split, "AllowBarrelAttachments", this.allowBarrelAttachments);
            this.allowScopeAttachments = this.Read(split, "AllowScopeAttachments", this.allowScopeAttachments);
            this.allowStockAttachments = this.Read(split, "AllowStockAttachments", this.allowStockAttachments);
            this.allowGripAttachments = this.Read(split, "AllowGripAttachments", this.allowGripAttachments);
            this.numGenericAttachmentSlots = this.Read(split, "NumGenericAttachmentSlots", this.numGenericAttachmentSlots);
            if (split[0].toLowerCase().equals("shield")) {
                this.shield = true;
                this.shieldDamageAbsorption = Float.parseFloat(split[1]);
                this.shieldOrigin = new Vector3f(Float.parseFloat(split[2]) / 16.0f, Float.parseFloat(split[3]) / 16.0f, Float.parseFloat(split[4]) / 16.0f);
                this.shieldDimensions = new Vector3f(Float.parseFloat(split[5]) / 16.0f, Float.parseFloat(split[6]) / 16.0f, Float.parseFloat(split[7]) / 16.0f);
            }
        }
        catch (Exception e) {
            FlansMod.log.error("Reading gun file failed.");
            FlansMod.log.throwing((Throwable)e);
        }
    }

    public boolean isCorrectAmmo(ShootableType type) {
        return this.ammo.contains(type);
    }

    public boolean isCorrectAmmo(ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77973_b() instanceof ItemBullet) {
            return this.isCorrectAmmo(((ItemBullet)stack.func_77973_b()).type);
        }
        if (stack.func_77973_b() instanceof ItemGrenade) {
            return this.isCorrectAmmo(((ItemGrenade)stack.func_77973_b()).type);
        }
        return false;
    }

    @Override
    public void reloadModel() {
        this.model = FlansMod.proxy.loadModel(this.modelString, this.shortName, ModelGun.class);
    }

    @Override
    public float getZoomFactor() {
        return this.zoomLevel;
    }

    @Override
    public boolean hasZoomOverlay() {
        return this.hasScopeOverlay;
    }

    @Override
    public String getZoomOverlay() {
        return this.defaultScopeTexture;
    }

    @Override
    public float getFOVFactor() {
        return this.FOVFactor;
    }

    public IScope getCurrentScope(ItemStack gunStack) {
        AttachmentType attachedScope = this.getScope(gunStack);
        return attachedScope == null ? this : attachedScope;
    }

    public ArrayList<AttachmentType> getCurrentAttachments(ItemStack gun) {
        this.checkForTags(gun);
        ArrayList<AttachmentType> attachments = new ArrayList<AttachmentType>();
        NBTTagCompound attachmentTags = gun.func_77978_p().func_74775_l("attachments");
        NBTTagList genericsList = attachmentTags.func_150295_c("generics", 10);
        for (int i = 0; i < this.numGenericAttachmentSlots; ++i) {
            this.appendToList(gun, "generic_" + i, attachments);
        }
        this.appendToList(gun, "barrel", attachments);
        this.appendToList(gun, "scope", attachments);
        this.appendToList(gun, "stock", attachments);
        this.appendToList(gun, "grip", attachments);
        return attachments;
    }

    private void appendToList(ItemStack gun, String name, ArrayList<AttachmentType> attachments) {
        AttachmentType type = this.getAttachment(gun, name);
        if (type != null) {
            attachments.add(type);
        }
    }

    public AttachmentType getBarrel(ItemStack gun) {
        return this.getAttachment(gun, "barrel");
    }

    public AttachmentType getScope(ItemStack gun) {
        return this.getAttachment(gun, "scope");
    }

    public AttachmentType getStock(ItemStack gun) {
        return this.getAttachment(gun, "stock");
    }

    public AttachmentType getGrip(ItemStack gun) {
        return this.getAttachment(gun, "grip");
    }

    public AttachmentType getGeneric(ItemStack gun, int i) {
        return this.getAttachment(gun, "generic_" + i);
    }

    public ItemStack getBarrelItemStack(ItemStack gun) {
        return this.getAttachmentItemStack(gun, "barrel");
    }

    public ItemStack getScopeItemStack(ItemStack gun) {
        return this.getAttachmentItemStack(gun, "scope");
    }

    public ItemStack getStockItemStack(ItemStack gun) {
        return this.getAttachmentItemStack(gun, "stock");
    }

    public ItemStack getGripItemStack(ItemStack gun) {
        return this.getAttachmentItemStack(gun, "grip");
    }

    public ItemStack getGenericItemStack(ItemStack gun, int i) {
        return this.getAttachmentItemStack(gun, "generic_" + i);
    }

    public AttachmentType getAttachment(ItemStack gun, String name) {
        this.checkForTags(gun);
        return AttachmentType.getFromNBT(gun.func_77978_p().func_74775_l("attachments").func_74775_l(name));
    }

    public ItemStack getAttachmentItemStack(ItemStack gun, String name) {
        this.checkForTags(gun);
        return new ItemStack(gun.func_77978_p().func_74775_l("attachments").func_74775_l(name));
    }

    private void checkForTags(ItemStack gun) {
        if (!gun.func_77942_o()) {
            gun.func_77982_d(new NBTTagCompound());
        }
        if (!gun.func_77978_p().func_74764_b("attachments")) {
            NBTTagCompound attachmentTags = new NBTTagCompound();
            for (int i = 0; i < this.numGenericAttachmentSlots; ++i) {
                attachmentTags.func_74782_a("generic_" + i, (NBTBase)new NBTTagCompound());
            }
            attachmentTags.func_74782_a("barrel", (NBTBase)new NBTTagCompound());
            attachmentTags.func_74782_a("scope", (NBTBase)new NBTTagCompound());
            attachmentTags.func_74782_a("stock", (NBTBase)new NBTTagCompound());
            attachmentTags.func_74782_a("grip", (NBTBase)new NBTTagCompound());
            gun.func_77978_p().func_74782_a("attachments", (NBTBase)attachmentTags);
        }
    }

    public float getMeleeDamage(ItemStack stack) {
        float stackMeleeDamage = this.meleeDamage;
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackMeleeDamage *= attachment.meleeDamageMultiplier;
        }
        return stackMeleeDamage;
    }

    public float getDamage(ItemStack stack) {
        float stackDamage = this.damage;
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackDamage *= attachment.damageMultiplier;
        }
        return stackDamage;
    }

    public float getSpread(ItemStack stack) {
        float stackSpread = this.bulletSpread;
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackSpread *= attachment.spreadMultiplier;
        }
        return stackSpread;
    }

    public EnumSpreadPattern getSpreadPattern(ItemStack stack) {
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            if (attachment.spreadPattern == null) continue;
            return attachment.spreadPattern;
        }
        return this.spreadPattern;
    }

    public float getRecoil(ItemStack stack) {
        float stackRecoil = this.recoil;
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackRecoil *= attachment.recoilMultiplier;
        }
        return stackRecoil;
    }

    public float getBulletSpeed(ItemStack stack) {
        float stackBulletSpeed = this.bulletSpeed;
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackBulletSpeed *= attachment.bulletSpeedMultiplier;
        }
        return stackBulletSpeed;
    }

    public float getReloadTime(ItemStack stack) {
        float stackReloadTime = this.reloadTime;
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackReloadTime *= attachment.reloadTimeMultiplier;
        }
        return stackReloadTime;
    }

    public EnumFireMode getFireMode(ItemStack stack) {
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            if (attachment.modeOverride == null) continue;
            return attachment.modeOverride;
        }
        return this.mode;
    }

    public float GetShootDelay(ItemStack stack) {
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            if (attachment.modeOverride != EnumFireMode.BURST) continue;
            return Math.max(this.shootDelay, 3.0f);
        }
        float stackShootDelay = this.shootDelay;
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackShootDelay *= attachment.shootDelayMultiplier;
        }
        return stackShootDelay;
    }

    public static GunType getGun(String s) {
        return guns.get(s.hashCode());
    }

    public static GunType getGun(int hash) {
        return guns.get(hash);
    }

    @Override
    protected void preRead(TypeFile file) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBase GetModel() {
        return this.model;
    }

    @Override
    public float GetRecommendedScale() {
        return 60.0f;
    }

    public Integer getPumpDelayAfterReload() {
        if (this.model != null) {
            return this.model.pumpDelayAfterReload;
        }
        return 0;
    }

    public Integer getPumpDelay() {
        if (this.model != null) {
            return this.model.pumpDelay;
        }
        return 0;
    }

    public Integer getPumpTime() {
        if (this.model != null) {
            return this.model.pumpTime;
        }
        return 0;
    }
}

