/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.network;

import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.boxes.GunBoxType;
import com.flansmod.common.network.PacketBase;
import com.flansmod.common.types.InfoType;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketBuyWeapon
extends PacketBase {
    public String boxShortName;
    private String typeShortName;

    public PacketBuyWeapon() {
    }

    public PacketBuyWeapon(GunBoxType box, InfoType type) {
        this.boxShortName = box.shortName;
        this.typeShortName = type.shortName;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        PacketBuyWeapon.writeUTF(data, this.boxShortName);
        PacketBuyWeapon.writeUTF(data, this.typeShortName);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        this.boxShortName = PacketBuyWeapon.readUTF(data);
        this.typeShortName = PacketBuyWeapon.readUTF(data);
    }

    @Override
    public void handleServerSide(EntityPlayerMP playerEntity) {
        GunBoxType box = GunBoxType.getBox(this.boxShortName);
        box.block.buyGun(InfoType.getType(this.typeShortName), playerEntity.field_71071_by, box);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer clientPlayer) {
        FlansMod.log.warn("Received gun box purchase packet on client. Skipping.");
    }
}

