/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.network;

import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EntitySeat;
import com.flansmod.common.network.PacketBase;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketSeatUpdates
extends PacketBase {
    public int entityId;
    public int seatId;
    public float yaw;
    public float pitch;

    public PacketSeatUpdates() {
    }

    public PacketSeatUpdates(EntitySeat seat) {
        this.entityId = seat.driveable.func_145782_y();
        this.seatId = seat.seatInfo.id;
        this.yaw = seat.looking.getYaw();
        this.pitch = seat.looking.getPitch();
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        data.writeInt(this.entityId);
        data.writeInt(this.seatId);
        data.writeFloat(this.yaw);
        data.writeFloat(this.pitch);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        this.entityId = data.readInt();
        this.seatId = data.readInt();
        this.yaw = data.readFloat();
        this.pitch = data.readFloat();
        data.release();
    }

    @Override
    public void handleServerSide(EntityPlayerMP playerEntity) {
        if (playerEntity == null) {
            FlansMod.log.warn("Received seat update packet from a null player, skipping!");
            return;
        }
        EntityDriveable driveable = null;
        for (Object obj : playerEntity.field_70170_p.field_72996_f) {
            if (!(obj instanceof EntityDriveable) || ((Entity)obj).func_145782_y() != this.entityId) continue;
            driveable = (EntityDriveable)obj;
            break;
        }
        if (driveable != null) {
            driveable.getSeat((int)this.seatId).prevLooking = driveable.getSeat((int)this.seatId).looking.clone();
            driveable.getSeat((int)this.seatId).looking.setAngles(this.yaw, this.pitch, 0.0f);
            FlansMod.getPacketHandler().sendToAllAround(this, driveable.field_70165_t, driveable.field_70163_u, driveable.field_70161_v, 50.0f, driveable.field_71093_bK);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer clientPlayer) {
        EntityDriveable driveable = null;
        for (int i = 0; i < clientPlayer.field_70170_p.field_72996_f.size(); ++i) {
            Entity obj = (Entity)clientPlayer.field_70170_p.field_72996_f.get(i);
            if (!(obj instanceof EntityDriveable) || obj.func_145782_y() != this.entityId) continue;
            driveable = (EntityDriveable)obj;
            break;
        }
        if (driveable != null) {
            if (driveable.getSeat(this.seatId) == null || driveable.getSeat(this.seatId).func_184179_bs() == clientPlayer) {
                return;
            }
            driveable.getSeat((int)this.seatId).prevLooking = driveable.getSeat((int)this.seatId).looking.clone();
            driveable.getSeat((int)this.seatId).looking.setAngles(this.yaw, this.pitch, 0.0f);
        }
    }
}

