/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.client.model.ModelCustomArmour;
import com.flansmod.common.FlansMod;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.TypeFile;
import java.util.ArrayList;
import net.minecraft.client.model.ModelBase;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ArmourType
extends InfoType {
    public static ArrayList<ArmourType> armours = new ArrayList();
    public int type;
    public double defence;
    public int DamageReductionAmount;
    public int Durability;
    public int Toughness;
    public int Enchantability = 10;
    public String armourTextureName;
    public float moveSpeedModifier = 1.0f;
    public float knockbackModifier = 0.2f;
    public float jumpModifier = 1.0f;
    public boolean nightVision = false;
    public String overlay = null;
    public boolean smokeProtection = false;
    public boolean negateFallDamage = false;
    @SideOnly(value=Side.CLIENT)
    public ModelCustomArmour model;

    public ArmourType(TypeFile file) {
        super(file);
        armours.add(this);
    }

    @Override
    protected void read(String[] split, TypeFile file) {
        super.read(split, file);
        try {
            if (FMLCommonHandler.instance().getSide().isClient() && split[0].equals("Model")) {
                this.model = FlansMod.proxy.loadModel(split[1], this.shortName, ModelCustomArmour.class);
                this.model.type = this;
            }
            if (split[0].equals("Type")) {
                if (split[1].equals("Hat") || split[1].equals("Helmet")) {
                    this.type = 0;
                }
                if (split[1].equals("Chest") || split[1].equals("Body")) {
                    this.type = 1;
                }
                if (split[1].equals("Legs") || split[1].equals("Pants")) {
                    this.type = 2;
                }
                if (split[1].equals("Shoes") || split[1].equals("Boots")) {
                    this.type = 3;
                }
            }
            this.defence = this.Read(split, "DamageReduction", this.defence);
            this.defence = this.Read(split, "Defence", this.defence);
            this.moveSpeedModifier = this.Read(split, "MoveSpeedModifier", this.moveSpeedModifier);
            this.moveSpeedModifier = this.Read(split, "Slowness", this.moveSpeedModifier);
            this.jumpModifier = this.Read(split, "JumpModifier", this.jumpModifier);
            this.knockbackModifier = this.Read(split, "KnockbackReduction", this.knockbackModifier);
            this.knockbackModifier = this.Read(split, "KnockbackModifier", this.knockbackModifier);
            this.nightVision = this.Read(split, "NightVision", this.nightVision);
            this.negateFallDamage = this.Read(split, "NegateFallDamage", this.negateFallDamage);
            this.overlay = this.Read(split, "Overlay", this.overlay);
            this.smokeProtection = this.Read(split, "SmokeProtection", this.smokeProtection);
            this.armourTextureName = this.Read(split, "ArmourTexture", this.armourTextureName);
            this.armourTextureName = this.Read(split, "ArmorTexture", this.armourTextureName);
            this.Enchantability = this.Read(split, "Enchantability", this.Enchantability);
            this.Toughness = this.Read(split, "Toughness", this.Toughness);
            this.Durability = this.Read(split, "Durability", this.Durability);
            this.DamageReductionAmount = this.Read(split, "DamageReductionAmount", this.DamageReductionAmount);
        }
        catch (Exception e) {
            FlansMod.log.error("Reading armour file failed.");
            FlansMod.log.throwing((Throwable)e);
        }
    }

    public static ArmourType getArmourType(String string) {
        for (ArmourType armour : armours) {
            if (!armour.shortName.equals(string)) continue;
            return armour;
        }
        return null;
    }

    @Override
    public void reloadModel() {
        this.model = FlansMod.proxy.loadModel(this.modelString, this.shortName, ModelCustomArmour.class);
        if (this.model != null) {
            this.model.type = this;
        }
    }

    @Override
    protected void preRead(TypeFile file) {
    }

    @Override
    protected void postRead(TypeFile file) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBase GetModel() {
        return this.model;
    }
}

